/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotator;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotatorInfo;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClazyAnnotator;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CommonClangTidyUtil;
import com.jetbrains.cidr.lang.inspections.ClazyInspection;
import org.jetbrains.annotations.NotNull;

public class ShowClazyInfoAction
extends AnAction
implements DumbAware {
    public ShowClazyInfoAction() {
        super(ClangdBundle.message((String)"show.clazy.info.action.title", (Object[])new Object[0]));
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(e.getData(CommonDataKeys.PSI_FILE) != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        assert (file != null);
        try {
            file.putUserData(ClangTidyAnnotator.COLLECT_DEBUG_INFORMATION, (Object)true);
            ClazyInspection clazyInspection = CommonClangTidyUtil.getClazyInspection((PsiFile)file, (Project)file.getProject());
            if (clazyInspection == null) {
                return;
            }
            ClazyAnnotator annotator = new ClazyAnnotator(clazyInspection);
            ClangTidyAnnotatorInfo info = annotator.collectInformation(file);
            annotator.doAnnotate(info);
            String debugInformation = (String)file.getUserData(ClangTidyAnnotator.DEBUG_INFORMATION);
            if (debugInformation == null) {
                return;
            }
            LightVirtualFile outputFile = new LightVirtualFile("Clazy Info for " + StringUtil.wrapWithDoubleQuote((String)file.getName()), (FileType)PlainTextFileType.INSTANCE, (CharSequence)debugInformation);
            FileEditorManager.getInstance((Project)file.getProject()).openFile((VirtualFile)outputFile, false);
        }
        finally {
            file.putUserData(ClangTidyAnnotator.COLLECT_DEBUG_INFORMATION, null);
            file.putUserData(ClangTidyAnnotator.DEBUG_INFORMATION, null);
        }
    }
}

