/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.inspections.ClazyInspection;
import org.jetbrains.annotations.NotNull;

public class DisableClazyCheckIntentionAction
extends SuppressIntentionAction {
    @NotNull
    private final String myCheckName;

    public DisableClazyCheckIntentionAction(@NotNull String checkName) {
        this.myCheckName = checkName;
    }

    @NotNull
    public String getText() {
        return ClangdBundle.message((String)"inspection.disable.clangTidy.check", (Object[])new Object[]{StringUtil.wrapWithDoubleQuote((String)this.myCheckName)});
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        return this.getText();
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile((Project)project, it -> {
            InspectionToolWrapper wrapper = it.getInspectionTool(ClazyInspection.getInspectionShortName(), project);
            if (wrapper != null) {
                ClazyInspection inspection = (ClazyInspection)wrapper.getTool();
                inspection.setClazyChecks(inspection.getClazyChecks() + ",no" + StringUtil.trimStart((String)this.myCheckName, (String)"-Wclazy"));
            }
        });
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        ProjectInspectionProfileManager profileManager = ProjectInspectionProfileManager.getInstance((Project)project);
        InspectionProfileImpl currentProfile = profileManager.getCurrentProfile();
        InspectionToolWrapper toolWrapper = currentProfile.getInspectionTool(ClazyInspection.getInspectionShortName(), project);
        return toolWrapper != null;
    }
}

