/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.startup;

import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.KeyedLazyInstance;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.daemon.OCLegacyAnnotator;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettingsListener;
import com.jetbrains.cidr.lang.daemon.clang.usages.ClangFindUsagesHandlerFactory;
import com.jetbrains.cidr.lang.daemon.clang.usages.ClangFindUsagesProvider;
import com.jetbrains.cidr.lang.search.usages.OCFindUsagesHandlerFactory;
import com.jetbrains.cidr.lang.search.usages.OCFindUsagesProvider;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ClangdBridgeStartupActivity
implements StartupActivity.DumbAware {
    public void runActivity(@NotNull Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ClangdBridgeStartupActivity.runStartupActivity(project);
    }

    public static void runStartupActivity(@NotNull Project project) {
        project.getMessageBus().connect().subscribe(ClangdSettingsListener.TOPIC, (Object)new ClangdBridgeSettingsListener(project));
        ClangdBridgeStartupActivity.configureDefaultAnnotators(project);
        ClangdBridgeStartupActivity.configureFindUsages(project);
    }

    private static void configureDefaultAnnotators(@NotNull Project project) {
        boolean legacy = !ClangUtils.isClangdOn((Project)project) || !ClangUtils.isClangdShowErrors((Project)project);
        OCLegacyAnnotator.enable((Project)project, (boolean)legacy, (boolean)true);
    }

    private static void configureFindUsages(@NotNull Project project) {
        ExtensionPoint langFindUsagesPoint;
        Class<ClangFindUsagesProvider> providerToUnregister;
        Class<ClangFindUsagesHandlerFactory> factoryToUnregister;
        if (ClangUtils.isClangdOn((Project)project) && Registry.is((String)"clion.clang.clangd.index.on")) {
            factoryToUnregister = OCFindUsagesHandlerFactory.class;
            providerToUnregister = OCFindUsagesProvider.class;
        } else {
            factoryToUnregister = ClangFindUsagesHandlerFactory.class;
            providerToUnregister = ClangFindUsagesProvider.class;
        }
        for (FindUsagesHandlerFactory factory : FindUsagesHandlerFactory.EP_NAME.getPoint((AreaInstance)project).getExtensionList()) {
            if (!factory.getClass().equals(factoryToUnregister)) continue;
            FindUsagesHandlerFactory.EP_NAME.getPoint((AreaInstance)project).unregisterExtension(factoryToUnregister);
            break;
        }
        if ((langFindUsagesPoint = LanguageFindUsages.INSTANCE.getPoint()) != null) {
            String providerClassName = providerToUnregister.getName();
            ArrayList<KeyedLazyInstance> instancesToUnregister = new ArrayList<KeyedLazyInstance>();
            for (KeyedLazyInstance extension : langFindUsagesPoint.getExtensionList()) {
                if (!(extension instanceof LanguageExtensionPoint) || !providerClassName.equals(((LanguageExtensionPoint)extension).implementationClass)) continue;
                instancesToUnregister.add(extension);
            }
            for (KeyedLazyInstance instance : instancesToUnregister) {
                langFindUsagesPoint.unregisterExtension((Object)instance);
            }
            LanguageFindUsages.INSTANCE.invalidateCacheForExtension(OCLanguage.getInstance().getID());
            LanguageFindUsages.INSTANCE.invalidateCacheForExtension("OCStringsFile");
        }
    }

    private static class ClangdBridgeSettingsListener
    implements ClangdSettingsListener {
        @NotNull
        private final Project myProject;

        ClangdBridgeSettingsListener(@NotNull Project project) {
            this.myProject = project;
        }

        public void onClangdOnChanged(boolean value) {
            ClangdBridgeStartupActivity.configureDefaultAnnotators(this.myProject);
        }

        public void onClangdShowErrorsChanged(boolean value) {
            ClangdBridgeStartupActivity.configureDefaultAnnotators(this.myProject);
        }
    }
}

