/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.navigation;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionSymbolInformation;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionLineMarker;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionLineMarkerKind;
import com.jetbrains.cidr.lang.daemon.clang.clangd.navigation.ClangNaiveGotoActionSync;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import icons.CidrLangIcons;
import javax.swing.Icon;
import org.eclipse.lsp4j.SymbolKind;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ClangLineMarkerInfo
extends LineMarkerInfo<PsiElement> {
    public ClangLineMarkerInfo(@NotNull PsiElement element, @NotNull ClionLineMarker marker) {
        super(element, OCElementUtil.getTextRangeWithoutComments((PsiElement)element), ClangLineMarkerInfo.getIcon(marker.getKind()), psiElement -> ClangLineMarkerInfo.getActionName(marker), ClangLineMarkerInfo.createNavigationHandler(element, marker), GutterIconRenderer.Alignment.RIGHT, () -> ClangLineMarkerInfo.getActionName(marker));
    }

    @NotNull
    private static Icon getIcon(@NotNull ClionLineMarkerKind kind) {
        switch (kind) {
            case DECL_DEF: {
                return CidrLangIcons.AssocFile;
            }
            case DIRECT_CHILDREN: 
            case ALL_CHILDREN: {
                return AllIcons.Gutter.OverridenMethod;
            }
            case DIRECT_PARENTS: 
            case ALL_PARENTS: {
                return AllIcons.Gutter.OverridingMethod;
            }
        }
        throw new AssertionError((Object)("Unexpected marker kind: " + kind));
    }

    @Nls
    @NotNull
    private static String getActionName(@NotNull ClionLineMarker marker) {
        CLionSymbolInformation sourceSymbol = marker.getSource();
        CLionSymbolInformation targetSymbol = (CLionSymbolInformation)marker.getTargets().get(0);
        switch (marker.getKind()) {
            case DIRECT_PARENTS: 
            case ALL_PARENTS: {
                switch (sourceSymbol.getKind()) {
                    case Method: {
                        return OCBundle.message((String)"goto.super.type.name1", (Object[])new Object[]{StringUtil.decapitalize((String)sourceSymbol.getKind().toString()), "`" + targetSymbol.getContainerName() + "`"});
                    }
                    case Constructor: 
                    case Function: {
                        return OCBundle.message((String)"goto.super.type.name2", (Object[])new Object[]{targetSymbol.getContainerName()});
                    }
                }
                return OCBundle.message((String)"goto.super.type.name3", (Object[])new Object[0]);
            }
            case DIRECT_CHILDREN: 
            case ALL_CHILDREN: {
                SymbolKind sourceKind = sourceSymbol.getKind();
                if (sourceKind == SymbolKind.Class || sourceKind == SymbolKind.Struct) {
                    return OCBundle.message((String)"goto.subclass", (Object[])new Object[0]);
                }
                if (sourceKind == SymbolKind.Method) {
                    return OCBundle.message((String)"goto.overridden.methods", (Object[])new Object[0]);
                }
                return OCBundle.message((String)"goto.overridden.functions", (Object[])new Object[0]);
            }
        }
        return "";
    }

    @NotNull
    private static GutterIconNavigationHandler<PsiElement> createNavigationHandler(@NotNull PsiElement element, @NotNull ClionLineMarker marker) {
        String actionName = ClangLineMarkerInfo.getActionName(marker);
        ClangNaiveGotoActionSync action = new ClangNaiveGotoActionSync(actionName, ClangLineMarkerInfo.getIcon(marker.getKind()), element.getProject(), element, marker.getTargets());
        return (e, elt) -> action.navigate(e, null);
    }
}

