/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.documentation;

import com.intellij.openapi.util.text.HtmlChunk;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.documentation.ClangDocumentationProviderKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClionHoverInfo;
import com.jetbrains.cidr.lang.dfa.contextSensitive.valueProvider.OCDFAAggregationValue;
import com.jetbrains.cidr.lang.dfa.contextSensitive.valueProvider.OCDFAAnythingValue;
import com.jetbrains.cidr.lang.dfa.contextSensitive.valueProvider.OCDFARangeValue;
import com.jetbrains.cidr.lang.dfa.contextSensitive.valueProvider.OCDFASetOfValues;
import com.jetbrains.cidr.lang.dfa.contextSensitive.valueProvider.OCDFASingleValue;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a#\u0010\u0006\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u000e\u001a\u00020\u000f*\u00060\u0010j\u0002`\u00112\u0006\u0010\r\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u000f*\u00060\u0010j\u0002`\u0011H\u0002\u001a-\u0010\u0013\u001a\u00020\u000f*\u00060\u0010j\u0002`\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u000b\u0010\u0017\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0007H\u0002\u001a\u001a\u0010\u0018\u001a\u00020\u000f*\u00060\u0010j\u0002`\u00112\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a\u001a\u0010\u0019\u001a\u00020\u000f*\u00060\u0010j\u0002`\u00112\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a\u001a\u0010\u001a\u001a\u00020\u000f*\u00060\u0010j\u0002`\u00112\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0018\u0010\u001b\u001a\u00020\u000f*\u00060\u0010j\u0002`\u00112\u0006\u0010\r\u001a\u00020\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"stringRegex", "Lkotlin/text/Regex;", "addBytes", "", "numBytes", "", "formatHoverInfo", "Lorg/jetbrains/annotations/Nls;", "hoverInfo", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClionHoverInfo;", "possibleValuesDFA", "Lcom/jetbrains/cidr/lang/dfa/contextSensitive/valueProvider/OCDFAAggregationValue;", "tryParseValueFromHover", "value", "addAggregationValue", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "addBreakIfRequired", "addConstructionAssignment", "construction", "", "assignment", "copyOrMoveText", "addMoveCopyability", "addOffset", "addSizeAndPadding", "addValueFromHover", "intellij.c.clangdBridge"})
public final class ClangDocumentationProviderKt {
    private static final Regex stringRegex;

    private static final String addBytes(long numBytes) {
        String byteWord = OCBundle.message((String)"qdoc.byte.0", (Object[])new Object[]{numBytes});
        return numBytes + " " + byteWord;
    }

    private static final void addAggregationValue(StringBuilder $this$addAggregationValue, OCDFAAggregationValue value) {
        String string;
        OCDFAAggregationValue oCDFAAggregationValue = value;
        if (Intrinsics.areEqual((Object)oCDFAAggregationValue, (Object)OCDFAAnythingValue.INSTANCE) || oCDFAAggregationValue instanceof OCDFASingleValue) {
            string = OCBundle.message((String)"qdoc.value", (Object[])new Object[0]);
        } else if (oCDFAAggregationValue instanceof OCDFARangeValue) {
            string = OCBundle.message((String)"qdoc.value.range", (Object[])new Object[0]);
        } else if (oCDFAAggregationValue instanceof OCDFASetOfValues) {
            string = OCBundle.message((String)"qdoc.possible.values", (Object[])new Object[0]);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String header = string;
        $this$addAggregationValue.append(HtmlChunk.text((String)header).bold());
        $this$addAggregationValue.append(" = ");
        $this$addAggregationValue.append(value.getRepresentation());
    }

    private static final String tryParseValueFromHover(String value) {
        Integer numberVal;
        Number number = StringsKt.toIntOrNull((String)value);
        if (number == null) {
            number = numberVal = StringsKt.toDoubleOrNull((String)value);
        }
        if (numberVal != null) {
            return ((Number)numberVal).toString();
        }
        return stringRegex.replace((CharSequence)value, (Function1)tryParseValueFromHover.1.INSTANCE);
    }

    private static final void addBreakIfRequired(StringBuilder $this$addBreakIfRequired) {
        CharSequence charSequence = $this$addBreakIfRequired;
        if (charSequence.length() > 0) {
            $this$addBreakIfRequired.append(HtmlChunk.br());
        }
    }

    private static final void addValueFromHover(StringBuilder $this$addValueFromHover, String value) {
        $this$addValueFromHover.append(HtmlChunk.text((String)OCBundle.message((String)"qdoc.value", (Object[])new Object[0])).bold());
        $this$addValueFromHover.append(" = ");
        String valueStr = ClangDocumentationProviderKt.tryParseValueFromHover(value);
        $this$addValueFromHover.append(valueStr);
    }

    private static final void addOffset(StringBuilder $this$addOffset, ClionHoverInfo hoverInfo) {
        Object object = hoverInfo;
        if (object == null || (object = object.getOffset()) == null) {
            return;
        }
        long offset = (Long)object;
        if (offset == 0L) {
            return;
        }
        ClangDocumentationProviderKt.addBreakIfRequired($this$addOffset);
        String bytesStr = ClangDocumentationProviderKt.addBytes(offset);
        $this$addOffset.append(HtmlChunk.text((String)OCBundle.message((String)"qdoc.offset", (Object[])new Object[0])).bold());
        $this$addOffset.append(" = ");
        $this$addOffset.append(bytesStr);
    }

    private static final void addSizeAndPadding(StringBuilder $this$addSizeAndPadding, ClionHoverInfo hoverInfo) {
        long padding;
        Object object = hoverInfo;
        if (object == null || (object = object.getSize()) == null) {
            return;
        }
        long size = (Long)object;
        ClangDocumentationProviderKt.addBreakIfRequired($this$addSizeAndPadding);
        String sizeStr = ClangDocumentationProviderKt.addBytes(size);
        $this$addSizeAndPadding.append(HtmlChunk.text((String)OCBundle.message((String)"qdoc.size", (Object[])new Object[0])).bold());
        $this$addSizeAndPadding.append(" = ");
        $this$addSizeAndPadding.append(sizeStr);
        Long l = hoverInfo.getPadding();
        long l2 = padding = l != null ? l : 0L;
        if (padding != 0L) {
            $this$addSizeAndPadding.append(" (+ ");
            $this$addSizeAndPadding.append(padding);
            $this$addSizeAndPadding.append(" " + OCBundle.message((String)"qdoc.padding", (Object[])new Object[0]) + ")");
        }
    }

    private static final void addConstructionAssignment(StringBuilder $this$addConstructionAssignment, boolean construction, boolean assignment, String copyOrMoveText) {
        if (!construction && !assignment) {
            return;
        }
        ClangDocumentationProviderKt.addBreakIfRequired($this$addConstructionAssignment);
        $this$addConstructionAssignment.append(HtmlChunk.text((String)copyOrMoveText).bold());
        $this$addConstructionAssignment.append(": ");
        if (construction) {
            $this$addConstructionAssignment.append(HtmlChunk.text((String)OCBundle.message((String)"qdoc.construction", (Object[])new Object[0])));
        }
        if (assignment) {
            if (construction) {
                $this$addConstructionAssignment.append(", ");
            }
            $this$addConstructionAssignment.append(HtmlChunk.text((String)OCBundle.message((String)"qdoc.assignment", (Object[])new Object[0])));
        }
    }

    private static final void addMoveCopyability(StringBuilder $this$addMoveCopyability, ClionHoverInfo hoverInfo) {
        if (hoverInfo == null) {
            return;
        }
        ClangDocumentationProviderKt.addConstructionAssignment($this$addMoveCopyability, Intrinsics.areEqual((Object)hoverInfo.getCopyConstructible(), (Object)true), Intrinsics.areEqual((Object)hoverInfo.getCopyAssignable(), (Object)true), OCBundle.message((String)"qdoc.copy", (Object[])new Object[0]));
        ClangDocumentationProviderKt.addConstructionAssignment($this$addMoveCopyability, Intrinsics.areEqual((Object)hoverInfo.getMoveConstructible(), (Object)true), Intrinsics.areEqual((Object)hoverInfo.getMoveAssignable(), (Object)true), OCBundle.message((String)"qdoc.move", (Object[])new Object[0]));
    }

    private static final String formatHoverInfo(ClionHoverInfo hoverInfo, OCDFAAggregationValue possibleValuesDFA) {
        StringBuilder stringBuilder;
        if (hoverInfo == null && possibleValuesDFA == null) {
            return null;
        }
        StringBuilder $this$buildString = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (possibleValuesDFA != null) {
            ClangDocumentationProviderKt.addAggregationValue($this$buildString, possibleValuesDFA);
        } else {
            ClionHoverInfo clionHoverInfo = hoverInfo;
            if ((clionHoverInfo != null ? clionHoverInfo.getValue() : null) != null) {
                String string = hoverInfo.getValue();
                Intrinsics.checkNotNull((Object)string);
                ClangDocumentationProviderKt.addValueFromHover($this$buildString, string);
            }
        }
        ClangDocumentationProviderKt.addOffset($this$buildString, hoverInfo);
        ClangDocumentationProviderKt.addSizeAndPadding($this$buildString, hoverInfo);
        ClangDocumentationProviderKt.addMoveCopyability($this$buildString, hoverInfo);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    static {
        String string = "&((u8|u|U|L)?R?\".*?\")\\[0]";
        stringRegex = new Regex(string);
    }

    public static final /* synthetic */ String access$formatHoverInfo(ClionHoverInfo hoverInfo, OCDFAAggregationValue possibleValuesDFA) {
        return ClangDocumentationProviderKt.formatHoverInfo(hoverInfo, possibleValuesDFA);
    }
}

