/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.editorActions.TabOutScopesTracker;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.SmartList;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionFlags;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionItem;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.ClangdCompletionUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.editor.OCTypedHandlerDelegate;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextEdit;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ClangdInsertHandler
implements InsertHandler<LookupElement> {
    private final CLionCompletionItem completion;
    private final int prefixLength;
    private final String charBeforePrefix;
    private final Position completionCaretPosition;

    private static boolean isFunctionLike(@NotNull CLionCompletionItem completion) {
        return completion.getKind() == CompletionItemKind.Function || completion.getKind() == CompletionItemKind.Method || completion.getKind() == CompletionItemKind.Constructor || completion.getKind() == CompletionItemKind.Text && CLionCompletionFlags.isMacro((int)completion.getCLionFlags()) && completion.getLabel().startsWith("(");
    }

    @Contract(pure=true)
    ClangdInsertHandler(@NotNull CLionCompletionItem completion, int prefixLength, String charBeforePrefix, Position completionCaretPosition) {
        this.completion = completion;
        this.prefixLength = prefixLength;
        this.charBeforePrefix = charBeforePrefix;
        this.completionCaretPosition = completionCaretPosition;
    }

    private static int matchingRBracket(@NotNull HighlighterIterator iterator, IElementType lBracketType, IElementType rBracketType) {
        int balance = 1;
        while (!iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            if (lBracketType == OCTokenTypes.LT && tokenType == OCTokenTypes.LTLT) {
                balance += 2;
            } else if (rBracketType == OCTokenTypes.GT && tokenType == OCTokenTypes.GTGT) {
                balance -= 2;
            } else if (tokenType == lBracketType) {
                ++balance;
            } else if (tokenType == rBracketType) {
                --balance;
            }
            if (balance <= 0) {
                int rAngleOffset = iterator.getStart();
                iterator.advance();
                return rAngleOffset;
            }
            iterator.advance();
        }
        return -1;
    }

    private String handleMatchingSignature(InsertionContext context, String insertion, char completionChar, Ref<Integer> editEndOffset, Ref<Integer> newCaretOffset) {
        if (!this.completion.getLabel().startsWith("(") && !this.completion.getLabel().startsWith("<")) {
            return insertion;
        }
        EditorHighlighter highlighter = context.getEditor().getHighlighter();
        @NotNull HighlighterIterator iterator = highlighter.createIterator(context.getTailOffset());
        if (iterator.atEnd()) {
            return insertion;
        }
        Document document = context.getDocument();
        int lineEndOffset = document.getLineEndOffset(document.getLineNumber(context.getTailOffset()));
        if (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(iterator.getTokenType())) {
            iterator.advance();
        }
        if (iterator.atEnd()) {
            return insertion;
        }
        int prevInsertionLength = ((String)insertion).length();
        IElementType tokenType = iterator.getTokenType();
        if (this.completion.getLabel().startsWith("<") && ((String)insertion).contains("<")) {
            if (tokenType != OCTokenTypes.LT) {
                return insertion;
            }
            int lAngleBracketOffset = iterator.getStart();
            iterator.advance();
            if (iterator.atEnd()) {
                return insertion;
            }
            int rAngleBracketOffset = ClangdInsertHandler.matchingRBracket(iterator, (IElementType)OCTokenTypes.LT, (IElementType)OCTokenTypes.GT);
            if (rAngleBracketOffset < 0 || rAngleBracketOffset > lineEndOffset) {
                return insertion;
            }
            insertion = ((String)insertion).substring(0, ((String)insertion).indexOf("<")) + "<";
            editEndOffset.set((Object)(lAngleBracketOffset + 1));
            newCaretOffset.set((Object)((Integer)newCaretOffset.get() + ((String)insertion).length() - prevInsertionLength));
            return insertion;
        }
        if (tokenType != OCTokenTypes.LPAR || !((String)insertion).contains("(")) {
            return insertion;
        }
        int lParOffset = iterator.getStart();
        iterator.advance();
        if (lParOffset > lineEndOffset) {
            return insertion;
        }
        int rParOffset = ClangdInsertHandler.matchingRBracket(iterator, (IElementType)OCTokenTypes.LPAR, (IElementType)OCTokenTypes.RPAR);
        if (rParOffset < 0) {
            return insertion;
        }
        if (!((String)insertion).endsWith("}")) {
            boolean noParameters = this.completion.getLabel().endsWith("()");
            if (completionChar == '(' || !noParameters || rParOffset - lParOffset != 1) {
                insertion = ((String)insertion).substring(0, ((String)insertion).indexOf("(")) + "(";
                editEndOffset.set((Object)(lParOffset + 1));
            } else {
                insertion = ((String)insertion).substring(0, ((String)insertion).indexOf("(")) + "()";
                editEndOffset.set((Object)(rParOffset + 1));
            }
            newCaretOffset.set((Object)((Integer)newCaretOffset.get() + ((String)insertion).length() - prevInsertionLength));
            return insertion;
        }
        if (completionChar != '\t') {
            return insertion;
        }
        int lBraceOffset = -1;
        while (!iterator.atEnd()) {
            tokenType = iterator.getTokenType();
            if (tokenType == OCTokenTypes.LBRACE) {
                lBraceOffset = iterator.getStart();
                break;
            }
            iterator.advance();
        }
        if (lBraceOffset == -1) {
            return insertion;
        }
        insertion = ((String)insertion).substring(0, ((String)insertion).length() - 2);
        editEndOffset.set((Object)lBraceOffset);
        iterator.advance();
        if (iterator.atEnd()) {
            return insertion;
        }
        int bodyStartOffset = iterator.getStart();
        if (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(iterator.getTokenType())) {
            iterator.advance();
            if (iterator.atEnd()) {
                return insertion;
            }
            bodyStartOffset = iterator.getStart();
            tokenType = iterator.getTokenType();
            if (tokenType == OCTokenTypes.RBRACE) {
                bodyStartOffset = Math.max(lBraceOffset + 1, bodyStartOffset - 1);
            }
            iterator.retreat();
        }
        newCaretOffset.set((Object)((Integer)newCaretOffset.get() + bodyStartOffset - lBraceOffset - 1));
        iterator.retreat();
        if (!BraceMatchingUtil.matchBrace((CharSequence)context.getDocument().getCharsSequence(), (FileType)context.getFile().getFileType(), (HighlighterIterator)iterator, (boolean)true)) {
            return insertion;
        }
        iterator.retreat();
        if (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(iterator.getTokenType())) {
            iterator.retreat();
        }
        context.getEditor().getSelectionModel().setSelection(bodyStartOffset, Math.max(bodyStartOffset, iterator.getEnd()));
        return insertion;
    }

    private boolean isFunctionCall(String newText) {
        return ClangdInsertHandler.isFunctionLike(this.completion) && !this.completion.getLabel().startsWith("()") && (newText.endsWith("()") || newText.endsWith(", )"));
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Document document = context.getDocument();
        TextEdit textEdit = (TextEdit)this.completion.getTextEdit().getLeft();
        if (textEdit == null) {
            return;
        }
        if (FileUtilRt.getExtension((String)context.getFile().getName()).endsWith("m")) {
            context.setAddCompletionChar(false);
        }
        Editor editor = context.getEditor();
        int startOffset = context.getStartOffset();
        Position currentStartPos = ClangLanguageServiceUtils.offset2LspPos((Document)document, (int)startOffset);
        int lineDiff = 0;
        int columnDiff = 0;
        if (this.completionCaretPosition.getLine() != currentStartPos.getLine() || this.completionCaretPosition.getCharacter() - this.prefixLength != currentStartPos.getCharacter()) {
            if (editor.getCaretModel().getCaretCount() == 1) {
                return;
            }
            if (this.charBeforePrefix.isEmpty() || !this.charBeforePrefix.equals(".") && !this.charBeforePrefix.equals(">") || ClangdCompletionUtils.getText(document, startOffset - 1, startOffset).equals(this.charBeforePrefix)) {
                lineDiff = currentStartPos.getLine() - this.completionCaretPosition.getLine();
                columnDiff = currentStartPos.getCharacter() - (this.completionCaretPosition.getCharacter() - this.prefixLength);
            } else {
                return;
            }
        }
        ArrayList<TextEdit> allTextEdits = new ArrayList<TextEdit>(Collections.singletonList(textEdit));
        if (this.completion.getAdditionalTextEdits() != null) {
            allTextEdits.addAll(this.completion.getAdditionalTextEdits());
        }
        allTextEdits.sort((left, right) -> {
            Position rightStart;
            Position leftStart = left.getRange().getStart();
            if (leftStart.equals((Object)(rightStart = right.getRange().getStart()))) {
                return 0;
            }
            if (leftStart.getLine() < rightStart.getLine()) {
                return 1;
            }
            if (leftStart.getLine() == rightStart.getLine() && leftStart.getCharacter() < rightStart.getCharacter()) {
                return 1;
            }
            return -1;
        });
        document.deleteString(startOffset + this.prefixLength, context.getTailOffset());
        boolean needReformat = false;
        boolean wasFunctionCall = false;
        Caret completionCaret = ClangdCompletionUtils.getCompletionCaret(context, this.prefixLength);
        for (int i = 0; i < allTextEdits.size(); ++i) {
            String textSoFar;
            int includeStartIndex;
            Position start = ((TextEdit)allTextEdits.get(i)).getRange().getStart();
            Position end = ((TextEdit)allTextEdits.get(i)).getRange().getEnd();
            if (lineDiff != 0 || columnDiff != 0) {
                start = new Position(start.getLine() + lineDiff, start.getCharacter() + columnDiff);
                end = new Position(end.getLine() + lineDiff, end.getCharacter() + columnDiff);
            }
            int editStartOffset = document.getLineCount() == 0 ? 0 : ClangLanguageServiceUtils.lspPos2Offset((Document)document, (Position)start);
            Ref editEndOffset = new Ref((Object)(document.getLineCount() == 0 ? 0 : ClangLanguageServiceUtils.lspPos2Offset((Document)document, (Position)end)));
            char completionChar = context.getCompletionChar();
            Object newText = ((TextEdit)allTextEdits.get(i)).getNewText();
            if (i == 0 && ((String)newText).endsWith(" ") && ClangdCompletionUtils.hasMatchingSpaceAfterInsertion(document, (Integer)editEndOffset.get())) {
                newText = StringUtil.trimEnd((String)newText, (char)' ');
            }
            Ref newCaretOffset = new Ref((Object)(editStartOffset + ((String)newText).length()));
            boolean functionDefinitionCompletion = ((String)newText).endsWith("}");
            String documentText = ClangdCompletionUtils.getText(document, context.getTailOffset(), document.getTextLength());
            if (this.completion.getLabel().startsWith("(") || this.completion.getLabel().startsWith("<")) {
                if (completionChar == '(' && ((String)newText).contains("(")) {
                    context.setAddCompletionChar(false);
                }
                newText = this.handleMatchingSignature(context, (String)newText, completionChar, (Ref<Integer>)editEndOffset, (Ref<Integer>)newCaretOffset);
            } else if (((String)newText).endsWith(":") && documentText.startsWith(":")) {
                newText = ((String)newText).substring(0, ((String)newText).length() - (((String)newText).endsWith("::") ? 2 : 1));
                editEndOffset.set((Object)context.getTailOffset());
                newCaretOffset.set((Object)(editStartOffset + ((String)newText).length()));
            }
            if (this.completion.getKind() == CompletionItemKind.File && (includeStartIndex = StringUtil.lastIndexOfAny((CharSequence)(textSoFar = ClangdCompletionUtils.getText(editor, 0, (int)((Integer)editEndOffset.get()))), (String)"\"<")) > 0) {
                boolean angled;
                boolean bl = angled = textSoFar.charAt(includeStartIndex) == '<';
                if (ClangdCompletionUtils.getText(editor, (int)((Integer)editEndOffset.get()), (Integer)editEndOffset.get() + 1).equals("\n")) {
                    newText = (String)newText + (angled ? (char)'>' : '\"');
                }
                if (angled) {
                    OCTypedHandlerDelegate.overTypeNextRightAngleBracket();
                } else {
                    OCTypedHandlerDelegate.overTypeNextQuote();
                }
                newCaretOffset.set((Object)((Integer)newCaretOffset.get() + 1));
            }
            if ((Integer)editEndOffset.get() > document.getTextLength()) {
                editEndOffset.set((Object)document.getTextLength());
            }
            document.replaceString(editStartOffset, ((Integer)editEndOffset.get()).intValue(), (CharSequence)newText);
            if (((String)newText).endsWith(":")) {
                OCTypedHandlerDelegate.overTypeNextColon((int)(((String)newText).endsWith("::") ? 2 : 1));
            }
            if (i == 0 && completionCaret != null) {
                if (functionDefinitionCompletion) {
                    completionCaret.moveToOffset((Integer)newCaretOffset.get() - 1);
                    needReformat = true;
                    continue;
                }
                if (((String)newText).endsWith("<>")) {
                    newCaretOffset.set((Object)((Integer)newCaretOffset.get() - 1));
                    TabOutScopesTracker.getInstance().registerEmptyScope(editor, ((Integer)newCaretOffset.get()).intValue());
                } else if (this.isFunctionCall((String)newText)) {
                    newCaretOffset.set((Object)((Integer)newCaretOffset.get() - 1));
                    TabOutScopesTracker.getInstance().registerEmptyScope(editor, ((Integer)newCaretOffset.get()).intValue());
                    if (((String)newText).endsWith("<>()")) {
                        newCaretOffset.set((Object)((Integer)newCaretOffset.get() - 2));
                        TabOutScopesTracker.getInstance().registerEmptyScope(editor, ((Integer)newCaretOffset.get()).intValue(), (Integer)newCaretOffset.get() + 2);
                    } else if (((String)newText).endsWith("<><<<>>>()")) {
                        newCaretOffset.set((Object)((Integer)newCaretOffset.get() - 8));
                        TabOutScopesTracker.getInstance().registerEmptyScope(editor, ((Integer)newCaretOffset.get()).intValue(), (Integer)newCaretOffset.get() + 4);
                        TabOutScopesTracker.getInstance().registerEmptyScope(editor, (Integer)newCaretOffset.get() + 4, (Integer)newCaretOffset.get() + 8);
                    } else if (((String)newText).endsWith("<<<>>>()")) {
                        newCaretOffset.set((Object)((Integer)newCaretOffset.get() - 4));
                        TabOutScopesTracker.getInstance().registerEmptyScope(editor, ((Integer)newCaretOffset.get()).intValue(), (Integer)newCaretOffset.get() + 4);
                    }
                }
                if (((Integer)newCaretOffset.get()).intValue() != completionCaret.getOffset()) {
                    completionCaret.moveToOffset(((Integer)newCaretOffset.get()).intValue());
                }
            }
            if (!this.isFunctionCall((String)newText)) continue;
            needReformat = true;
            wasFunctionCall = true;
        }
        if (needReformat && editor.getCaretModel().getAllCarets().size() == 1 && completionCaret != null) {
            Position reformatStart = ((TextEdit)allTextEdits.get(allTextEdits.size() - 1)).getRange().getStart();
            int reformatStartOffset = document.getLineCount() == 0 ? 0 : ClangLanguageServiceUtils.lspPos2Offset((Document)document, (Position)reformatStart);
            ClangdCompletionUtils.reformatCompletion(context, reformatStartOffset, completionCaret.getOffset());
        }
        if (this.completion.getKind() == CompletionItemKind.File) {
            ClangdInsertHandler.removeErrorForExistingHeader(context.getProject(), document, startOffset, context.getTailOffset());
        }
        if (wasFunctionCall) {
            AutoPopupController.getInstance((Project)context.getProject()).autoPopupParameterInfo(editor, null);
        }
    }

    private static void removeErrorForExistingHeader(@NotNull Project project, @NotNull Document document, int startOffset, int endOffset) {
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        if (documentManager.getCachedPsiFile(document) == null) {
            return;
        }
        SmartList infosToDispose = new SmartList();
        DaemonCodeAnalyzerEx.processHighlights((Document)document, (Project)project, null, (int)startOffset, (int)endOffset, arg_0 -> ClangdInsertHandler.lambda$removeErrorForExistingHeader$1((List)infosToDispose, arg_0));
        for (HighlightInfo info : infosToDispose) {
            info.getHighlighter().dispose();
        }
    }

    private static /* synthetic */ boolean lambda$removeErrorForExistingHeader$1(List infosToDispose, HighlightInfo info) {
        infosToDispose.add(info);
        return true;
    }
}

