/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.ExternalFormatProcessor;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.ClangdLiveTemplate;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangdCompletionUtils {
    @NotNull
    public static String getText(@NotNull Document document, int startOffset, int endOffset) {
        if (startOffset >= 0 && endOffset > startOffset) {
            CharSequence chars = document.getImmutableCharSequence();
            return chars.subSequence(Math.min(chars.length(), startOffset), Math.min(chars.length(), endOffset)).toString();
        }
        return "";
    }

    @NotNull
    public static String getText(@NotNull Editor editor, int startOffset, int endOffset) {
        return ClangdCompletionUtils.getText(editor.getDocument(), startOffset, endOffset);
    }

    public static boolean hasMatchingSpaceAfterInsertion(@NotNull Document document, int endOffset) {
        return endOffset < document.getTextLength() && ClangdCompletionUtils.getText(document, endOffset, endOffset + 1).equals(" ");
    }

    public static boolean adjustCompletionInLiveTemplateIfNeeded(@NotNull Project project, @NotNull Editor editor, @NotNull Document document, @NotNull String insertion, int endOffset) {
        Template currentTemplate = TemplateManager.getInstance((Project)project).getActiveTemplate(editor);
        if (currentTemplate != null && insertion.endsWith(" ")) {
            document.replaceString(endOffset - 1, endOffset, (CharSequence)"");
            return true;
        }
        return false;
    }

    public static boolean isLiveTemplateNameSegmentCompletion(@NotNull Project project, @NotNull Editor editor) {
        Template currentTemplate = TemplateManager.getInstance((Project)project).getActiveTemplate(editor);
        if (currentTemplate == null) {
            return false;
        }
        @Nullable TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)editor);
        if (templateState == null) {
            return false;
        }
        if (currentTemplate.getSegmentsCount() <= templateState.getCurrentVariableNumber()) {
            return false;
        }
        return currentTemplate.getSegmentName(templateState.getCurrentVariableNumber()).equals("name") && currentTemplate instanceof ClangdLiveTemplate && ((ClangdLiveTemplate)currentTemplate).getDontCompleteName();
    }

    static void reformatCompletion(@NotNull InsertionContext context, int startOffset, int endOffset) {
        Document document = context.getDocument();
        Project project = context.getProject();
        @NotNull Editor editor = context.getEditor();
        if (editor.getCaretModel().getCaretCount() != 1) {
            return;
        }
        int cursorOffset = editor.getCaretModel().getCurrentCaret().getOffset();
        RangeMarker marker = document.createRangeMarker(startOffset, endOffset);
        RangeMarker cursorMarker = document.createRangeMarker(cursorOffset, cursorOffset);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        }
        PsiDocumentManager.getInstance((Project)project).performForCommittedDocument(document, () -> CommandProcessor.getInstance().runUndoTransparentAction(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            int _startOffset = marker.getStartOffset();
            int _endOffset = marker.getEndOffset();
            int _cursorOffset = cursorMarker.getStartOffset();
            cursorMarker.dispose();
            marker.dispose();
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (psiFile == null) {
                return;
            }
            if (ExternalFormatProcessor.useExternalFormatter((PsiFile)psiFile)) {
                ExternalFormatProcessor.formatRangeInFile((PsiFile)psiFile, (TextRange)new TextRange(_startOffset, _endOffset), (boolean)true, (boolean)true, (boolean)false, (int)_cursorOffset);
                return;
            }
            int cursorLine = document.getLineNumber(_cursorOffset);
            String cursorLineText = document.getText(DocumentUtil.getLineTextRange((Document)document, (int)cursorLine));
            if (cursorLineText.trim().isEmpty()) {
                int endLine;
                int startLine = document.getLineNumber(_startOffset);
                for (int line = endLine = document.getLineNumber(_endOffset); line >= startLine; --line) {
                    if (line == cursorLine) {
                        CodeStyleManager.getInstance((Project)project).adjustLineIndent(psiFile, document.getLineStartOffset(line));
                        editor.getCaretModel().moveToOffset(document.getLineEndOffset(line));
                        continue;
                    }
                    OCChangeUtil.reformatTextIfNotInjected((PsiFile)psiFile, (int)document.getLineStartOffset(line), (int)document.getLineEndOffset(line));
                }
                return;
            }
            OCChangeUtil.reformatTextIfNotInjected((PsiFile)psiFile, (int)_startOffset, (int)_endOffset);
        })));
    }

    static void reindentCompletion(@NotNull InsertionContext context, int startOffset, int endOffset) {
        Document document = context.getDocument();
        Project project = context.getProject();
        RangeMarker marker = document.createRangeMarker(startOffset, endOffset);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        }
        PsiDocumentManager.getInstance((Project)project).performForCommittedDocument(document, () -> CommandProcessor.getInstance().runUndoTransparentAction(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            int _startOffset = marker.getStartOffset();
            int _endOffset = marker.getEndOffset();
            marker.dispose();
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (psiFile == null) {
                return;
            }
            int startLine = document.getLineNumber(_startOffset);
            int endLine = document.getLineNumber(_endOffset);
            for (int line = startLine; line <= endLine; ++line) {
                String indent;
                int startOfLineOffset = document.getLineStartOffset(line);
                String string = indent = ExternalFormatProcessor.useExternalFormatter((PsiFile)psiFile) ? ExternalFormatProcessor.indentLine((PsiFile)psiFile, (int)startOfLineOffset) : OCChangeUtil.indentLineIfNotInjected((PsiFile)psiFile, (int)startOfLineOffset);
                if (indent == null) continue;
                int startOfTextInLine = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)startOfLineOffset, (String)" \t");
                document.replaceString(startOfLineOffset, startOfTextInLine, (CharSequence)indent);
            }
        })));
    }

    public static String trimKeywordLookup(@NotNull String lookupString) {
        return StringUtil.trimEnd((String)StringUtil.trimEnd((String)StringUtil.trimEnd((String)StringUtil.trimStart((String)StringUtil.trimStart((String)StringUtil.trimStart((String)lookupString.trim(), (String)"@"), (String)"~"), (String)"#"), (String)";"), (String)"}").trim(), (String)"{").trim();
    }

    @Nullable
    public static Caret getCompletionCaret(@NotNull InsertionContext context, int prefixLength) {
        List allCarets = context.getEditor().getCaretModel().getAllCarets();
        if (allCarets.size() == 1) {
            return (Caret)allCarets.get(0);
        }
        for (Caret caret : allCarets) {
            if (caret.getOffset() != context.getStartOffset() + prefixLength) continue;
            return caret;
        }
        return null;
    }
}

