/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.StatisticsWeigher;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.completion.impl.LiftShorterItemsClassifier;
import com.intellij.codeInsight.completion.impl.LiveTemplateWeigher;
import com.intellij.codeInsight.completion.impl.RealPrefixMatchingWeigher;
import com.intellij.codeInsight.completion.ml.MLWeigherUtil;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.ClassifierFactory;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElementImpl;
import com.intellij.codeInsight.template.impl.TextExpression;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.codeInsight.template.postfix.templates.LanguagePostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatesUtils;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixChangedBuiltinTemplate;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.intellij.util.indexing.DumbModeAccessType;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResultFuture;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionFlags;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionItem;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionKind;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionList;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionSnippetFlags;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.ClangPostfixTemplateFlags;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.ClangdCompletionUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.ClangdInsertHandler;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.ClangdLiveTemplate;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.ClangdLookupElement;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.ClangdPostfixTemplateProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.SnippetInsertHandler;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangFileFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.editor.completion.ExternalCompletionProvider;
import com.jetbrains.cidr.lang.editor.completion.OCNameSuggestionContributor;
import com.jetbrains.cidr.lang.editor.completion.OCNonImportedReferenceCompletionContributor;
import com.jetbrains.cidr.lang.editor.completion.QualifiedSelectorCompletionContributor;
import com.jetbrains.cidr.lang.parser.OCExpressionCodeFragmentType;
import com.jetbrains.cidr.lang.parser.OCQualifiedIdCodeFragmentType;
import com.jetbrains.cidr.lang.parser.OCTypeCodeFragmentType;
import com.jetbrains.cidr.lang.preprocessor.OCFileActiveConfigurationCache;
import com.jetbrains.cidr.lang.psi.OCFragmentVirtualFile;
import com.jetbrains.cidr.lang.psi.impl.OCCodeFragmentImpl;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import icons.CidrLangIcons;
import icons.CidrProjectModelIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionTriggerKind;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangdCodeCompletionProvider
implements ExternalCompletionProvider,
DumbAware {
    @NonNls
    private static final String CPP_GROUP = "C/C++";
    @NonNls
    private static final String COMPLETION_SEPARATOR = "\\\\u2029";
    private static final ConcurrentHashMap<Icon, Icon> myDesaturatedIconsCache = new ConcurrentHashMap();

    private static boolean isKeyword(@NotNull CLionCompletionItem completion) {
        return completion.getKind() == CompletionItemKind.Keyword || completion.getKind() == CompletionItemKind.Snippet;
    }

    private static boolean isHeaderFile(@NotNull CLionCompletionItem completion) {
        return completion.getKind() == CompletionItemKind.File;
    }

    private static boolean isFolder(@NotNull CLionCompletionItem completion) {
        return completion.getKind() == CompletionItemKind.Folder;
    }

    private static boolean isPPDirective(@NotNull CLionCompletionItem completion) {
        return CLionCompletionFlags.isDirective((int)completion.getCLionFlags());
    }

    @Nullable
    private static Icon iconFromCompletionKind(@NotNull CLionCompletionItem item, @NotNull OCVisibility visibility) {
        CompletionItemKind itemKind = item.getKind();
        int clionFlags = item.getCLionFlags();
        boolean applyVisibility = false;
        Icon baseIcon = null;
        switch (itemKind) {
            case Enum: {
                baseIcon = CidrLangIcons.CodeAssistantEnum;
                break;
            }
            case File: {
                baseIcon = CidrLangIcons.FileTypes.H;
                break;
            }
            case Folder: {
                baseIcon = CLionCompletionFlags.isFramework((int)clionFlags) ? CidrProjectModelIcons.Framework : PlatformIcons.FOLDER_ICON;
                break;
            }
            case Class: 
            case Struct: {
                applyVisibility = true;
                if (CLionCompletionFlags.isClass((int)clionFlags)) {
                    baseIcon = CidrLangIcons.CodeAssistantClass;
                    break;
                }
                if (CLionCompletionFlags.isUnion((int)clionFlags)) {
                    baseIcon = CidrLangIcons.CodeAssistantUnion;
                    break;
                }
                baseIcon = CidrLangIcons.CodeAssistantStruct;
                break;
            }
            case Field: {
                applyVisibility = true;
                baseIcon = CidrLangIcons.CodeAssistantField;
                if (CLionCompletionFlags.isStatic((int)clionFlags)) {
                    baseIcon = OCIcons.getStaticIcon((Icon)baseIcon);
                }
                if (!CLionCompletionFlags.isConstant((int)clionFlags)) break;
                baseIcon = OCIcons.getConstIcon((Icon)baseIcon);
                break;
            }
            case Function: 
            case Method: 
            case Constructor: {
                applyVisibility = true;
                baseIcon = OCIcons.getFunctionIcon((boolean)CLionCompletionFlags.isStatic((int)clionFlags), (boolean)false, (!CLionCompletionFlags.isVirtualMethod((int)clionFlags) ? 1 : 0) != 0, null);
                baseIcon = CLionCompletionFlags.isConstant((int)clionFlags) ? OCIcons.getConstIcon((Icon)baseIcon) : baseIcon;
                break;
            }
            case Variable: {
                Icon icon = baseIcon = CLionCompletionFlags.isLocal((int)clionFlags) ? CidrLangIcons.CodeAssistantLocal : CidrLangIcons.CodeAssistantGlobal;
                if (!CLionCompletionFlags.isConstant((int)clionFlags)) break;
                baseIcon = OCIcons.getConstIcon((Icon)baseIcon);
                break;
            }
            case Module: {
                baseIcon = CidrLangIcons.CodeAssistantNamespace;
                break;
            }
            case TypeParameter: 
            case Reference: 
            case Interface: {
                baseIcon = CidrLangIcons.CodeAssistantType;
                break;
            }
            case Text: {
                if (!CLionCompletionFlags.isMacro((int)clionFlags)) break;
                baseIcon = CidrLangIcons.CodeAssistantMacro;
                break;
            }
            case EnumMember: 
            case Value: {
                baseIcon = CidrLangIcons.CodeAssistantEnumConst;
                break;
            }
            case Property: {
                baseIcon = CidrLangIcons.CodeAssistantParameter;
                break;
            }
        }
        if (baseIcon != null && (CLionCompletionFlags.isNotAvailable((int)clionFlags) || CLionCompletionFlags.isNotAccessible((int)clionFlags))) {
            if (myDesaturatedIconsCache.containsKey(baseIcon)) {
                baseIcon = myDesaturatedIconsCache.get(baseIcon);
            } else {
                Icon desaturatedIcon = IconUtil.desaturate((Icon)baseIcon);
                myDesaturatedIconsCache.put(baseIcon, desaturatedIcon);
                baseIcon = desaturatedIcon;
            }
        }
        return applyVisibility ? OCIcons.getVisibilityIcon((OCVisibility)visibility, (Icon)baseIcon) : baseIcon;
    }

    private static Range subtractFromRange(Range range, Position shift) {
        Position start = range.getStart();
        Position end = range.getEnd();
        start.setLine(start.getLine() - shift.getLine());
        if (start.getLine() == 0) {
            start.setCharacter(start.getCharacter() - shift.getCharacter());
        }
        end.setLine(end.getLine() - shift.getLine());
        if (end.getLine() == 0) {
            end.setCharacter(end.getCharacter() - shift.getCharacter());
        }
        range.setStart(start);
        range.setEnd(end);
        return range;
    }

    private static Range addToRange(Range range, Position shift) {
        Position start = range.getStart();
        Position end = range.getEnd();
        if (start.getLine() == 0) {
            start.setCharacter(start.getCharacter() + shift.getCharacter());
        }
        start.setLine(start.getLine() + shift.getLine());
        if (end.getLine() == 0) {
            end.setCharacter(end.getCharacter() + shift.getCharacter());
        }
        end.setLine(end.getLine() + shift.getLine());
        range.setStart(start);
        range.setEnd(end);
        return range;
    }

    private static ClangdLiveTemplate decodeCompletion(@NotNull CLionCompletionItem completion, Position extraPositionOffset, Position fakeEditorOffset, @NotNull Project project) {
        String wholeCompletion = completion.getLabel();
        String[] lines = wholeCompletion.split(COMPLETION_SEPARATOR);
        String signature = lines[0];
        completion.setLabel(signature);
        completion.setKind(CompletionItemKind.forValue((int)Integer.parseInt(lines[1])));
        completion.setDetail(lines[2]);
        completion.setFilterText(lines[3]);
        completion.setSortText(lines[4]);
        completion.setCLionFlags(Integer.parseInt(lines[5]));
        completion.setCLionSnippetFlags(Integer.parseInt(lines[6]));
        completion.setFromFile(lines[7]);
        @NotNull String wslMsId = ClangUtils.getCurrentWslMsId((Project)project);
        if (!wslMsId.isEmpty()) {
            completion.setFromFile(ClangUrlConverter.fromWslPath((String)completion.getFromFile(), (String)wslMsId));
        }
        completion.setFromFileOffset(Integer.parseUnsignedInt(lines[8]));
        Object insertText = lines[9];
        int rangeStartLine = Integer.parseInt(lines[10]);
        int rangeStartChar = Integer.parseInt(lines[11]);
        int rangeEndLine = Integer.parseInt(lines[12]);
        int rangeEndChar = Integer.parseInt(lines[13]);
        Range range = new Range(new Position(rangeStartLine, rangeStartChar), new Position(rangeEndLine, rangeEndChar));
        completion.setTextEdit(Either.forLeft((Object)new TextEdit(range, (String)insertText)));
        Ref nextReplacementIndex = new Ref((Object)14);
        Supplier<Boolean> nextReplacement = () -> lines.length > (Integer)nextReplacementIndex.get();
        while (nextReplacement.get().booleanValue()) {
            int index = (Integer)nextReplacementIndex.get();
            int startLine = Integer.parseInt(lines[index + 1]);
            int startChar = Integer.parseInt(lines[index + 2]);
            int endLine = Integer.parseInt(lines[index + 3]);
            int endChar = Integer.parseInt(lines[index + 4]);
            if (completion.getAdditionalTextEdits() == null) {
                completion.setAdditionalTextEdits(Collections.singletonList(new TextEdit(new Range(new Position(startLine, startChar), new Position(endLine, endChar)), lines[index])));
            } else {
                completion.getAdditionalTextEdits().add(new TextEdit(new Range(new Position(startLine, startChar), new Position(endLine, endChar)), lines[index]));
            }
            nextReplacementIndex.set((Object)(index + 5));
        }
        ClangdLiveTemplate snippet = null;
        if (ClangdCodeCompletionProvider.isKeyword(completion)) {
            if (ClangdCodeCompletionProvider.isPPDirective(completion)) {
                completion.setFilterText("#" + completion.getFilterText());
            }
            if (completion.getKind() == CompletionItemKind.Snippet) {
                Matcher snippetMatcher = Pattern.compile("\\$\\{[0-9]+:([^}]+)}").matcher((CharSequence)insertText);
                Object snippetText = insertText;
                ArrayList<Variable> variables = new ArrayList<Variable>();
                int shift = 0;
                int insertTextShift = 0;
                boolean insertPlaceholders = CLionCompletionSnippetFlags.needInsertPlaceholders((int)completion.getCLionSnippetFlags());
                while (snippetMatcher.find()) {
                    String matched = snippetMatcher.group(1).replaceAll("-", "_");
                    if (variables.isEmpty()) {
                        insertText = ((String)insertText).substring(0, snippetMatcher.start()) + "<caret>" + ((String)insertText).substring(snippetMatcher.end());
                        insertTextShift += 7 - (snippetMatcher.end() - snippetMatcher.start());
                    } else {
                        insertText = ((String)insertText).substring(0, snippetMatcher.start() + insertTextShift) + ((String)insertText).substring(snippetMatcher.end() + insertTextShift);
                        insertTextShift += snippetMatcher.start() - snippetMatcher.end();
                    }
                    snippetText = ((String)snippetText).substring(0, snippetMatcher.start() + shift) + "$" + matched + "$" + ((String)snippetText).substring(snippetMatcher.end() + shift);
                    shift += matched.length() + 2 - (snippetMatcher.end() - snippetMatcher.start());
                    variables.add(new Variable(matched, null, (Expression)new TextExpression(matched), true, false));
                }
                if (insertPlaceholders) {
                    snippet = new ClangdLiveTemplate(completion.getFilterText(), (String)snippetText, CPP_GROUP);
                    String description = ((String)snippetText).replaceAll("\\$", "");
                    snippet.setDescription(description);
                    if (CLionCompletionSnippetFlags.dontCompleteName((int)completion.getCLionSnippetFlags())) {
                        snippet.setDontCompleteName(true);
                    }
                    if (!((String)snippetText).endsWith(")")) {
                        snippet.setToReformat(true);
                    }
                    for (Variable variable : variables) {
                        if (description.substring(0, description.indexOf(variable.getName())).trim().endsWith("{")) {
                            snippet.setEndSegmentNumber(variables.indexOf(variable));
                            break;
                        }
                        snippet.addVariable(variable.getName(), variable.getDefaultValueExpression(), variable.isAlwaysStopAt());
                    }
                }
            }
            if (((String)insertText).contains("(<caret>,")) {
                insertText = ((String)insertText).replaceAll(", |,", "");
            }
        } else if (ClangdCodeCompletionProvider.isHeaderFile(completion)) {
            if (((String)insertText).endsWith("\"") || ((String)insertText).endsWith(">")) {
                completion.setFilterText(((String)insertText).substring(0, ((String)insertText).length() - 1));
            }
        } else if (ClangdCodeCompletionProvider.isFolder(completion) && ((String)insertText).endsWith("/")) {
            completion.setFilterText(((String)insertText).substring(0, ((String)insertText).length() - 1));
        }
        ((TextEdit)completion.getTextEdit().getLeft()).setNewText((String)insertText);
        if (extraPositionOffset.getLine() != 0 || extraPositionOffset.getCharacter() != 0) {
            ((TextEdit)completion.getTextEdit().getLeft()).setRange(ClangdCodeCompletionProvider.subtractFromRange(((TextEdit)completion.getTextEdit().getLeft()).getRange(), extraPositionOffset));
        }
        if (fakeEditorOffset.getLine() != 0 || fakeEditorOffset.getCharacter() != 0) {
            ((TextEdit)completion.getTextEdit().getLeft()).setRange(ClangdCodeCompletionProvider.addToRange(((TextEdit)completion.getTextEdit().getLeft()).getRange(), fakeEditorOffset));
        }
        return snippet;
    }

    @NotNull
    private static String getActionShortcut() {
        return KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("CodeCompletion"));
    }

    private static CompletionSorterImpl createClangdSorter(@NotNull CompletionParameters parameters) {
        final CompletionLocation location = new CompletionLocation(parameters);
        CompletionSorterImpl sorter = ((CompletionSorterImpl)CompletionService.getCompletionService().emptySorter()).weigh((LookupElementWeigher)new LiveTemplateWeigher()).weigh(new LookupElementWeigher("exactMatch"){

            @NotNull
            public Comparable weigh(@NotNull LookupElement element, @NotNull WeighingContext context) {
                LookupElementPresentation presentation = new LookupElementPresentation();
                element.renderElement(presentation);
                if (presentation.getItemText() == null) {
                    return Boolean.valueOf(true);
                }
                return Boolean.valueOf(!presentation.getItemText().equals(context.itemPattern(element)));
            }

            public boolean isPrefixDependent() {
                return true;
            }
        }).weigh(new LookupElementWeigher("exactPrefixMatch"){

            @NotNull
            public Comparable weigh(@NotNull LookupElement element, @NotNull WeighingContext context) {
                return Boolean.valueOf(!element.getLookupString().startsWith(context.itemPattern(element)));
            }

            public boolean isPrefixDependent() {
                return true;
            }
        }).weigh(new LookupElementWeigher("priority"){

            @NotNull
            public Double weigh(@NotNull LookupElement element) {
                ClangdLookupElement clangdElement = (ClangdLookupElement)((Object)element.as(ClangdLookupElement.CLASS_CONDITION_KEY));
                if (clangdElement != null) {
                    return -clangdElement.getScore();
                }
                return 0.0;
            }
        }).weigh((LookupElementWeigher)new RealPrefixMatchingWeigher()).weigh(new LookupElementWeigher("alphabetic"){

            @NotNull
            public String weigh(@NotNull LookupElement element) {
                ClangdLookupElement clangdElement = (ClangdLookupElement)((Object)element.as(ClangdLookupElement.CLASS_CONDITION_KEY));
                if (clangdElement == null || !ClangdCodeCompletionProvider.isKeyword(clangdElement.getCompletionItem())) {
                    return "";
                }
                return StringUtil.trimStart((String)element.getLookupString(), (String)"#").trim();
            }
        }).weigh(new LookupElementWeigher("kind"){

            @NotNull
            public Boolean weigh(@NotNull LookupElement element) {
                ClangdLookupElement clangdElement = (ClangdLookupElement)((Object)element.as(ClangdLookupElement.CLASS_CONDITION_KEY));
                if (clangdElement != null) {
                    return clangdElement.getKind() == CompletionItemKind.Snippet;
                }
                return false;
            }
        }).withClassifier((ClassifierFactory)new ClassifierFactory<LookupElement>("stats"){

            public Classifier<LookupElement> createClassifier(Classifier<LookupElement> next) {
                return new StatisticsWeigher.LookupStatisticsWeigher(location, next);
            }
        }).weigh(new LookupElementWeigher("alphabetic"){

            @NotNull
            public String weigh(@NotNull LookupElement element) {
                return StringUtil.trimStart((String)element.getLookupString(), (String)"#").trim();
            }
        }).withClassifier("prefix", true, (ClassifierFactory)new ClassifierFactory<LookupElement>("liftShorter"){

            public Classifier<LookupElement> createClassifier(Classifier<LookupElement> next) {
                return new LiftShorterItemsClassifier("liftShorter", next, new LiftShorterItemsClassifier.LiftingCondition(), false);
            }
        });
        LookupElementWeigher mlWeigher = MLWeigherUtil.findMLWeigher((CompletionLocation)location);
        if (mlWeigher != null) {
            sorter = sorter.weigh(mlWeigher);
        }
        return sorter;
    }

    protected LookupElement lookup(final @NotNull CLionCompletionItem completion, @Nullable Icon icon, int prefixLength, String charBeforePrefix, Position completionCaretPosition, @Nullable ClangdLiveTemplate snippet) {
        String qualifier;
        if (completion.getKind() == CompletionItemKind.Snippet) {
            if (snippet != null) {
                return new LiveTemplateLookupElementImpl(snippet, false){

                    public void handleInsert(@NotNull InsertionContext context) {
                        Document document = context.getDocument();
                        int completionStart = ClangLanguageServiceUtils.lspPos2Offset((Document)document, (Position)((TextEdit)completion.getTextEdit().getLeft()).getRange().getStart());
                        if (completionStart != context.getStartOffset()) {
                            document.deleteString(completionStart, context.getStartOffset());
                            context.getOffsetMap().addOffset(CompletionInitializationContext.START_OFFSET, completionStart);
                        }
                        super.handleInsert(context);
                    }
                };
            }
            String type = completion.getDetail();
            String description = CLionCompletionSnippetFlags.dontInsertName((int)completion.getCLionSnippetFlags()) || !type.isEmpty() ? completion.getLabel() : completion.getFilterText() + completion.getLabel();
            return SnippetInsertHandler.snippetLookup(completion).withBoldness(true).withPresentableText(completion.getFilterText()).withTailText(type.isEmpty() ? "" : description).withTypeText(type.isEmpty() ? description : type).withIcon(icon);
        }
        if (completion.getKind() == CompletionItemKind.Keyword) {
            String newText = ((TextEdit)completion.getTextEdit().getLeft()).getNewText();
            final boolean hasSpaceAfterKeyword = newText.endsWith(" ");
            return LookupElementBuilder.create((Object)completion, (String)newText.trim()).withPresentableText(completion.getFilterText()).withTypeText(completion.getDetail()).withTailText(completion.getLabel()).withBoldness(true).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                    boolean isObjC = FileUtilRt.getExtension((String)context.getFile().getName()).endsWith("m");
                    if (isObjC) {
                        context.setAddCompletionChar(false);
                    }
                    Document document = context.getDocument();
                    int endOffset = context.getTailOffset();
                    if (TemplateManager.getInstance((Project)context.getProject()).getActiveTemplate(context.getEditor()) == null && hasSpaceAfterKeyword && (context.getCompletionChar() != ' ' || isObjC)) {
                        Caret completionCaret;
                        if (!ClangdCompletionUtils.hasMatchingSpaceAfterInsertion(document, endOffset)) {
                            document.insertString(endOffset, (CharSequence)" ");
                        }
                        if ((completionCaret = ClangdCompletionUtils.getCompletionCaret(context, item.getLookupString().length())) != null) {
                            completionCaret.moveToOffset(endOffset + 1);
                        }
                    }
                }
            });
        }
        Object presentation = completion.getFilterText();
        String insertedText = ((TextEdit)completion.getTextEdit().getLeft()).getNewText();
        int presentationStringStart = insertedText.indexOf((String)presentation);
        String string = qualifier = presentationStringStart >= 0 ? insertedText.substring(0, presentationStringStart) : "";
        if (CLionCompletionFlags.isOverrideCall((int)completion.getCLionFlags()) || qualifier.endsWith("::")) {
            completion.setRequiredQualifier(qualifier);
            presentation = qualifier + (String)presentation;
        }
        return LookupElementBuilder.create((Object)completion, (String)StringUtil.trimStart((String)completion.getFilterText(), (String)"~")).withPresentableText((String)presentation).withTypeText(completion.getDetail()).withTailText(completion.getLabel()).withIcon(icon).withStrikeoutness(CLionCompletionFlags.isDeprecated((int)completion.getCLionFlags())).withInsertHandler((InsertHandler)new ClangdInsertHandler(completion, prefixLength, charBeforePrefix, completionCaretPosition));
    }

    private static boolean isCppFile(@NotNull VirtualFile file, FileTypeManager fileTypeManager) {
        @NotNull FileType type = fileTypeManager.getFileTypeByFile(file);
        return type.equals(OCLanguageUtils.getBaseFileType());
    }

    private static boolean isValidHeaderFile(@NotNull String fileName, @NotNull VirtualFile origFile, @NotNull String textSoFar, @Nullable OCResolveConfiguration resolveConfiguration) {
        if (resolveConfiguration == null) {
            return true;
        }
        OCLanguageKind languageKind = resolveConfiguration.getDeclaredLanguageKind(origFile);
        if (languageKind == null) {
            return true;
        }
        OCCompilerSettings compilerSettings = resolveConfiguration.getCompilerSettings(languageKind);
        int includeStartIndex = StringUtil.lastIndexOfAny((CharSequence)textSoFar, (String)"\"<") + 1;
        String additionalPath = textSoFar.substring(includeStartIndex);
        int lastSlashIndex = StringUtil.lastIndexOfAny((CharSequence)additionalPath, (String)"/");
        additionalPath = lastSlashIndex > 0 ? additionalPath.substring(0, lastSlashIndex + 1) : "";
        LocalFileSystem localFS = LocalFileSystem.getInstance();
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        @Nullable VirtualFile foundFile = localFS.findFileByPath(origFile.getParent().getPath() + "/" + additionalPath + fileName);
        if (foundFile != null) {
            return ClangdCodeCompletionProvider.isCppFile(foundFile, fileTypeManager);
        }
        for (HeadersSearchPath path : compilerSettings.getHeadersSearchPaths()) {
            foundFile = localFS.findFileByPath(path.getPath() + "/" + additionalPath + fileName);
            if (foundFile == null) continue;
            return ClangdCodeCompletionProvider.isCppFile(foundFile, fileTypeManager);
        }
        return true;
    }

    @NotNull
    private LookupElement createClangdItem(@NotNull CompletionResultSet result2, CLionCompletionItem completion, String charBeforePrefix, Position completionCaretPosition, OCVisibility visibility, ClangdLiveTemplate snippet) {
        int prefixLength = result2.getPrefixMatcher().getPrefix().length();
        if (ClangdCodeCompletionProvider.isKeyword(completion)) {
            if (charBeforePrefix.equals("@")) {
                completion.setFilterText("@" + completion.getFilterText());
            }
            Icon icon = null;
            if (CLionCompletionFlags.isSnippetFunction((int)completion.getCLionFlags())) {
                icon = OCIcons.getFunctionIcon((boolean)false, (boolean)false, (boolean)false, null);
            }
            return ClangdLookupElement.withCompletionItem(this.lookup(completion, icon, prefixLength, charBeforePrefix, completionCaretPosition, snippet), completion);
        }
        Icon icon = ClangdCodeCompletionProvider.iconFromCompletionKind(completion, visibility);
        return ClangdLookupElement.withCompletionItem(this.lookup(completion, icon, prefixLength, charBeforePrefix, completionCaretPosition, snippet), completion);
    }

    private void consumeResult(@NotNull CompletionParameters parameters, @NotNull VirtualFile virtualFile, @Nullable OCResolveConfiguration resolveConfiguration, @NotNull CompletionResultSet result2, @NotNull Either<List<CLionCompletionItem>, CLionCompletionList> completionResult, String charBeforePrefix, Position completionCaretPosition, Position extraPositionOffset, Position fakeEditorOffset) {
        List completions = completionResult.isLeft() ? (List)completionResult.getLeft() : ((CLionCompletionList)completionResult.getRight()).getItems();
        int invocationCount = parameters.getInvocationCount();
        if (parameters.getProcess().isAutopopupCompletion()) {
            ++invocationCount;
        }
        String textSoFar = null;
        boolean fileCompletion = false;
        for (CLionCompletionItem completion : completions) {
            ClangdLiveTemplate snippet = ClangdCodeCompletionProvider.decodeCompletion(completion, extraPositionOffset, fakeEditorOffset, parameters.getPosition().getProject());
            if (!fileCompletion && completion.getKind() == CompletionItemKind.File && result2.getPrefixMatcher().getPrefix().contains("/")) {
                fileCompletion = true;
                String prefix = result2.getPrefixMatcher().getPrefix();
                prefix = prefix.substring(prefix.indexOf("/") + 1);
                result2 = result2.withPrefixMatcher(prefix);
            }
            if (((CLionCompletionList)completionResult.getRight()).anyAvailableOrAccessibleResults() && (CLionCompletionFlags.isNotAccessible((int)completion.getCLionFlags()) || CLionCompletionFlags.isNotAvailable((int)completion.getCLionFlags())) && invocationCount <= 1) {
                if (invocationCount != 1) continue;
                result2.addLookupAdvertisement(ClangdBundle.message((String)"completion.press.shortcut.for.non.public.members", (Object[])new Object[]{ClangdCodeCompletionProvider.getActionShortcut()}));
                --invocationCount;
                continue;
            }
            if (completion.getKind() == CompletionItemKind.File && FileUtilRt.getExtension((String)completion.getFilterText()).isEmpty()) {
                if (textSoFar == null) {
                    textSoFar = ClangdCompletionUtils.getText(parameters.getEditor(), 0, parameters.getOffset());
                }
                if (!ClangdCodeCompletionProvider.isValidHeaderFile(completion.getFilterText(), virtualFile, textSoFar, resolveConfiguration)) continue;
            }
            OCVisibility visibility = CLionCompletionFlags.isPrivate((int)completion.getCLionFlags()) ? OCVisibility.PRIVATE : (CLionCompletionFlags.isProtected((int)completion.getCLionFlags()) ? OCVisibility.PROTECTED : OCVisibility.PUBLIC);
            @NotNull LookupElement element = this.createClangdItem(result2, completion, charBeforePrefix, completionCaretPosition, visibility, snippet);
            boolean prefixMatches = result2.getPrefixMatcher().prefixMatches(element);
            if (!prefixMatches) continue;
            try {
                result2.addElement(element);
            }
            catch (ProcessCanceledException processCanceledException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consume(@NotNull CompletionParameters parameters, @NotNull VirtualFile virtualFile, @Nullable OCResolveConfiguration resolveConfiguration, @NotNull CompletionResultSet result2, @NotNull Either<List<CLionCompletionItem>, CLionCompletionList> completionResult, int line, int column, @NotNull String fileText, String charBeforePrefix, Position completionCaretPosition, Position extraPositionOffset, Position fakeEditorOffset, @NotNull Pair<Integer, ArrayList<String>> postfixTemplates, CLionCompletionKind completionKind) throws ExecutionException, TimeoutException {
        this.consumeResult(parameters, virtualFile, resolveConfiguration, result2, completionResult, charBeforePrefix, completionCaretPosition, extraPositionOffset, fakeEditorOffset);
        ProgressManager progressManager = ProgressManager.getInstance();
        while (completionResult.isRight() && ((CLionCompletionList)completionResult.getRight()).isIncomplete()) {
            ProgressIndicator completionIndicator = progressManager.getProgressIndicator();
            if (completionIndicator == null || completionIndicator.isCanceled()) {
                return;
            }
            ClangResultFuture<Either<List<CLionCompletionItem>, CLionCompletionList>> future = this.clangdCompletionFuture(parameters, virtualFile, CompletionTriggerKind.TriggerForIncompleteCompletions, line, column, fileText, extraPositionOffset, postfixTemplates, completionKind);
            try {
                completionResult = (Either)CidrConcurrentUtilsKt.waitCancelAware((Future)future.asFuture(), (long)Long.MAX_VALUE, (String)"complete");
            }
            finally {
                future.release();
            }
            if (completionResult == null) break;
            this.consumeResult(parameters, virtualFile, resolveConfiguration, result2, (Either<List<CLionCompletionItem>, CLionCompletionList>)completionResult, charBeforePrefix, completionCaretPosition, extraPositionOffset, fakeEditorOffset);
        }
    }

    protected void waitForCompletionCache(ClangLanguageService service, VirtualFile virtualFile) {
    }

    private ClangResultFuture<Either<List<CLionCompletionItem>, CLionCompletionList>> clangdCompletionFuture(@NotNull CompletionParameters parameters, @NotNull VirtualFile virtualFile, @NotNull CompletionTriggerKind kind, int line, int column, @NotNull String fileText, Position extraPositionOffset, @NotNull Pair<Integer, ArrayList<String>> postfixTemplates, CLionCompletionKind completionKind) {
        Project project = parameters.getPosition().getProject();
        ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted((Project)project);
        if (virtualFile instanceof OCFragmentVirtualFile) {
            int parentOffset = ((OCFragmentVirtualFile)virtualFile).getParentOffset();
            LineColumn lineColumn = StringUtil.offsetToLineColumn((CharSequence)((OCFragmentVirtualFile)virtualFile).getParentFileContent(), (int)parentOffset);
            if (lineColumn != null) {
                extraPositionOffset.setLine(lineColumn.line);
                extraPositionOffset.setCharacter(lineColumn.column);
            }
            virtualFile = virtualFile.getParent();
        }
        this.waitForCompletionCache(service, virtualFile);
        Ref resultRef = Ref.create();
        service.complete(virtualFile, line, column, fileText, kind, completionKind, postfixTemplates, result2 -> resultRef.set((Object)result2.iWillNotForgetToCancelTheFuture()));
        return (ClangResultFuture)resultRef.get();
    }

    private static void waitForConsumerFinished(@NotNull CompletableFuture<Void> accepted) {
        try {
            CidrConcurrentUtilsKt.waitCancelAware(accepted, (long)Long.MAX_VALUE, (String)"clangd all completions");
        }
        catch (ExecutionException | TimeoutException exception) {
            CidrLogService.LOG.warn((Throwable)exception);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean isEnabled(@NotNull Project project) {
        ClangdSettings settings = ClangdSettings.getInstance((Project)project);
        return settings != null && settings.isClangdOn() && settings.getCompletionType() != ClangdSettings.CompletionType.Builtin;
    }

    private static void runNameSuggestionContributor(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> {
            List contributors = CompletionContributor.forParameters((CompletionParameters)parameters);
            for (CompletionContributor contributor : contributors) {
                if (!(contributor instanceof OCNameSuggestionContributor)) continue;
                contributor.fillCompletionVariants(parameters, result2);
                return;
            }
        });
    }

    private static void runExtraCompletionContributors(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2, int invocationCount, boolean allowNameSuggestions) {
        if (!allowNameSuggestions && invocationCount <= 1) {
            return;
        }
        DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> {
            List contributors = CompletionContributor.forParameters((CompletionParameters)parameters);
            for (CompletionContributor contributor : contributors) {
                if (invocationCount > 1 && (contributor instanceof OCNonImportedReferenceCompletionContributor || contributor instanceof QualifiedSelectorCompletionContributor)) {
                    parameters.setCompleteOnlyNotImported(true);
                    contributor.fillCompletionVariants(parameters, result2);
                }
                if (contributor instanceof OCNameSuggestionContributor && allowNameSuggestions) {
                    contributor.fillCompletionVariants(parameters, result2);
                }
                if (!result2.isStopped()) continue;
                break;
            }
        });
    }

    @NotNull
    private static Pair<Integer, ArrayList<String>> getEnabledPostfixTemplates() {
        int enabledPostfixTemplates = 0;
        ArrayList<String> postfixKeys = new ArrayList<String>(Collections.nCopies(ClangPostfixTemplateFlags.values().length - 1, ""));
        for (PostfixTemplateProvider provider : LanguagePostfixTemplate.LANG_EP.allForLanguage((Language)OCLanguage.getInstance())) {
            if (!(provider instanceof ClangdPostfixTemplateProvider)) continue;
            @NotNull Set templates = PostfixTemplatesUtils.getAvailableTemplates((PostfixTemplateProvider)provider);
            for (PostfixTemplate template : templates) {
                ClangPostfixTemplateFlags flag;
                if (!template.isEnabled(provider)) continue;
                String name = template.getPresentableName();
                if (template instanceof PostfixChangedBuiltinTemplate) {
                    name = ((PostfixChangedBuiltinTemplate)template).getBuiltinTemplate().getPresentableName();
                }
                if ((flag = ClangPostfixTemplateFlags.fromString(name)) == ClangPostfixTemplateFlags.None) continue;
                long value = flag.getValue();
                int index = (int)(Math.log(value) / Math.log(2.0));
                postfixKeys.set(index, template.getPresentableName());
                enabledPostfixTemplates = (int)((long)enabledPostfixTemplates | value);
            }
        }
        return new Pair((Object)enabledPostfixTemplates, postfixKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet originalResult, @NotNull CompletionType completionType) {
        Project project = parameters.getPosition().getProject();
        if (!this.isEnabled(project)) {
            return;
        }
        PsiFile psiFile = parameters.getOriginalFile();
        VirtualFile virtualFile = psiFile.getViewProvider().getVirtualFile();
        ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted((Project)project);
        if (service.isFileBanned(virtualFile.getUrl())) {
            return;
        }
        ClangLanguageService clangdService = ClangLanguageServiceProvider.getIfStarted((Project)project);
        VirtualFile mainVirtualFile = virtualFile;
        IElementType fragmentElementType = null;
        int parentFileOffset = 0;
        if (psiFile instanceof OCCodeFragmentImpl) {
            fragmentElementType = ((OCCodeFragmentImpl)psiFile).getContentElementType();
            if (!(virtualFile instanceof OCFragmentVirtualFile)) {
                PsiElement psiContext = psiFile.getContext();
                if (psiContext == null) {
                    return;
                }
                OCCodeFragmentImpl newFragment = new OCCodeFragmentImpl(project, OCElementFactory.getLanguageKindFromContext((PsiElement)psiContext), (CharSequence)psiFile.getText(), true, fragmentElementType);
                newFragment.setContext(psiContext);
                virtualFile = newFragment.getVirtualFile();
            }
            if (virtualFile instanceof OCFragmentVirtualFile) {
                parentFileOffset = ((OCFragmentVirtualFile)virtualFile).getParentOffset();
            }
            mainVirtualFile = virtualFile.getParent();
        }
        CompletionSorterImpl sorter = ClangdCodeCompletionProvider.createClangdSorter(parameters);
        CompletionResultSet result2 = originalResult.withRelevanceSorter((CompletionSorter)sorter);
        int offset = parameters.getOffset();
        Editor editor = parameters.getEditor();
        if (ClangdCompletionUtils.isLiveTemplateNameSegmentCompletion(project, editor)) {
            ClangdCodeCompletionProvider.runNameSuggestionContributor(parameters, result2);
            result2.stopHere();
            return;
        }
        List allCarets = editor.getCaretModel().getAllCarets();
        Caret completionCaret = (Caret)allCarets.get(0);
        String prefix = result2.getPrefixMatcher().getPrefix();
        if (prefix.contains(".")) {
            int dotPos = prefix.lastIndexOf(".");
            offset -= prefix.length() - dotPos;
            result2 = result2.withPrefixMatcher(prefix.substring(dotPos + 1));
        }
        Position fakeEditorOffset = new Position(0, 0);
        if (fragmentElementType != null) {
            completionCaret = (Caret)allCarets.get(0);
            Position caretOffset = ClangLanguageServiceUtils.offset2LspPos((Document)editor.getDocument(), (int)(completionCaret.getOffset() - offset));
            fakeEditorOffset.setLine(caretOffset.getLine());
            fakeEditorOffset.setCharacter(caretOffset.getCharacter());
        } else {
            for (Caret caret : allCarets) {
                if (offset == caret.getOffset()) {
                    completionCaret = caret;
                    break;
                }
                if (!ClangdCompletionUtils.getText(editor, caret.getOffset() - prefix.length(), caret.getOffset()).equals(prefix)) continue;
                offset = caret.getOffset();
                completionCaret = caret;
                break;
            }
        }
        int prefixOffset = offset - prefix.length();
        String charBeforePrefix = ClangdCompletionUtils.getText(editor, prefixOffset - 1, prefixOffset);
        @NotNull Pair postfixTemplates = allCarets.size() > 1 ? new Pair((Object)0, new ArrayList()) : ClangdCodeCompletionProvider.getEnabledPostfixTemplates();
        ClangFileFacade helper = clangdService.getClangIdeFacade().getFileFacade(virtualFile);
        String fileText = psiFile instanceof OCCodeFragmentImpl ? (helper != null ? helper.getText().toString() : "") : "";
        LineColumn lineColumn = helper != null ? helper.getLineColumn(offset + parentFileOffset) : null;
        int line = lineColumn != null ? lineColumn.line : 0;
        int column = lineColumn != null ? lineColumn.column : 0;
        Position extraPositionOffset = new Position(0, 0);
        CLionCompletionKind completionKind = CLionCompletionKind.Default;
        if (completionType == CompletionType.SMART) {
            completionKind = CLionCompletionKind.Smart;
        } else if (fragmentElementType != null) {
            completionKind = fragmentElementType instanceof OCQualifiedIdCodeFragmentType ? CLionCompletionKind.Namespace : (fragmentElementType instanceof OCTypeCodeFragmentType ? CLionCompletionKind.Type : (fragmentElementType instanceof OCExpressionCodeFragmentType ? CLionCompletionKind.Expression : CLionCompletionKind.OrdinaryName));
        }
        ClangResultFuture<Either<List<CLionCompletionItem>, CLionCompletionList>> future = this.clangdCompletionFuture(parameters, virtualFile, CompletionTriggerKind.Invoked, line, column, fileText, extraPositionOffset, (Pair<Integer, ArrayList<String>>)postfixTemplates, completionKind);
        OCResolveConfiguration resolveConfiguration = OCFileActiveConfigurationCache.getActiveConfiguration((VirtualFile)mainVirtualFile, (Project)parameters.getPosition().getProject());
        try {
            Position completionCaretPosition = completionCaret != null ? ClangLanguageServiceUtils.offset2LspPos((Document)editor.getDocument(), (int)completionCaret.getOffset()) : new Position(0, 0);
            ProgressManager progressManager = ProgressManager.getInstance();
            ProgressIndicator completionProgressIndicator = progressManager.getProgressIndicator();
            CompletionResultSet finalResult = result2;
            VirtualFile finalVirtualFile = virtualFile;
            CLionCompletionKind finalCompletionKind = completionKind;
            CompletionStage accepted = future.asFuture().thenAcceptAsync(completionResult -> {
                assert (progressManager.getProgressIndicator() == null) : "Freshly created Java Thread has progress indicator?!";
                progressManager.runProcess(() -> {
                    if (completionResult != null) {
                        try {
                            this.consume(parameters, finalVirtualFile, resolveConfiguration, finalResult, (Either<List<CLionCompletionItem>, CLionCompletionList>)completionResult, line, column, fileText, charBeforePrefix, completionCaretPosition, extraPositionOffset, fakeEditorOffset, (Pair<Integer, ArrayList<String>>)postfixTemplates, finalCompletionKind);
                        }
                        catch (ExecutionException | TimeoutException exception) {
                            CidrLogService.LOG.warn((Throwable)exception);
                        }
                    }
                }, (ProgressIndicator)ProgressWrapper.wrap((ProgressIndicator)completionProgressIndicator));
            });
            if (completionType != CompletionType.SMART) {
                ClangdCodeCompletionProvider.runExtraCompletionContributors(parameters, result2, parameters.getInvocationCount(), allCarets.size() == 1);
            }
            ClangdCodeCompletionProvider.waitForConsumerFinished((CompletableFuture<Void>)accepted);
            result2.stopHere();
        }
        finally {
            future.release();
        }
    }
}

