/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowablePairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.ExternalResolveUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangSym;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.OpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.SimpleOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangLocalWorkspace;
import com.jetbrains.cidr.lang.psi.OCExternalResolver;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ClangExternalResolver
implements OCExternalResolver {
    private static final Logger LOG = Logger.getInstance((String)ExternalResolveUtils.class.getName());
    private static final Key<CachedValue<Map<Integer, List<OCExternalResolver.Resolved>>>> TEST_CLANG_RESOLVE_CACHE = Key.create((String)"TEST_CLANG_RESOLVE_CACHE");
    private static final long CLANG_RESPONSE_TIMEOUT_MS = ApplicationManager.getApplication().isUnitTestMode() ? 30000L : Long.MAX_VALUE;

    private static List<OCExternalResolver.Resolved> doResolve(@NotNull PsiFile file, int offset, @NotNull ThrowablePairConsumer<ClangLanguageService, Ref<List<ClangSym>>, Exception> resolveFn) {
        List<OCExternalResolver.Resolved> result2;
        ClangLocalWorkspace workspace;
        CachedValueProvider provider;
        CachedValuesManager manager;
        if (!ClangUtils.isClangdOn((Project)file.getProject())) {
            return Collections.emptyList();
        }
        if (!ClangUtils.isNavigationViaClangd((Project)file.getProject())) {
            return Collections.emptyList();
        }
        Project project = file.getProject();
        VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
        Map cache = null;
        if (ApplicationManager.getApplication().isUnitTestMode() && (cache = (Map)(manager = CachedValuesManager.getManager((Project)project)).getCachedValue((UserDataHolder)file, TEST_CLANG_RESOLVE_CACHE, provider = () -> new CachedValueProvider.Result(new ConcurrentHashMap(), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false)).containsKey(offset)) {
            return (List)cache.get(offset);
        }
        ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted((Project)project);
        SimpleOpenRequestId openRequestId = null;
        if (ClangdBridge.CLANG_CAN_OPEN_FILE.get((UserDataHolder)project) != null && (workspace = service.getLocalWorkspace()) != null && !((Boolean)workspace.apply(virtualFile.getUrl(), wf -> wf.isOpened())).booleanValue()) {
            openRequestId = new SimpleOpenRequestId(ExternalResolveUtils.class, "Opened [" + virtualFile.getPath() + "]");
            service.notifyDocumentOpened(virtualFile, (OpenRequestId)openRequestId);
        }
        Ref clangSymsRef = Ref.create();
        try {
            resolveFn.consume((Object)service, (Object)clangSymsRef);
        }
        catch (TimeoutException ex) {
            LOG.warn(ClangExternalResolver.toMessageWithOffset(ex, file, offset));
        }
        catch (ExecutionException ex) {
            ClangUtils.logServerException((Logger)LOG, (String)ClangExternalResolver.toMessageWithOffset(ex, file, offset), (ExecutionException)ex);
        }
        catch (Exception ex) {
            if (ex instanceof ControlFlowException) {
                ExceptionUtil.rethrow((Throwable)ex);
            }
            LOG.error(ClangExternalResolver.toMessageWithOffset(ex, file, offset), (Throwable)ex);
        }
        List clangSyms = (List)clangSymsRef.get();
        if (openRequestId != null && ClangdBridge.CLANG_DONT_CLOSE_FILE.get((UserDataHolder)project) == null) {
            service.notifyDocumentClosed(virtualFile, (OpenRequestId)openRequestId);
        }
        List<Object> list = result2 = !ContainerUtil.isEmpty((Collection)clangSyms) ? clangSyms.stream().filter(sym -> !sym.isMacro).map(sym -> new OCExternalResolver.Resolved(sym.location.uri, sym.name, sym.location.position.getLine(), sym.location.position.getColumn())).collect(Collectors.toList()) : Collections.emptyList();
        if (cache != null) {
            cache.put(offset, result2);
        }
        return result2;
    }

    @NotNull
    public List<OCExternalResolver.Resolved> resolve(@NotNull PsiFile file, int offset) {
        VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
        return ClangExternalResolver.doResolve(file, offset, (ThrowablePairConsumer<ClangLanguageService, Ref<List<ClangSym>>, Exception>)((ThrowablePairConsumer)(service, ref) -> service.gotoDefinition(virtualFile, offset, res -> ref.set((Object)((List)res.waitForResult(CLANG_RESPONSE_TIMEOUT_MS))))));
    }

    @NotNull
    public List<OCExternalResolver.Resolved> resolveType(@NotNull PsiFile file, int offset) {
        VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
        return ClangExternalResolver.doResolve(file, offset, (ThrowablePairConsumer<ClangLanguageService, Ref<List<ClangSym>>, Exception>)((ThrowablePairConsumer)(service, ref) -> service.gotoTypeDeclaration(virtualFile, offset, res -> ref.set((Object)((List)res.waitForResult(CLANG_RESPONSE_TIMEOUT_MS))))));
    }

    @NotNull
    private static String toMessageWithOffset(@NotNull Throwable original, @NotNull PsiFile file, int offset) {
        try {
            return "When resolving " + file.getName() + ":" + offset + " happened [" + original.getMessage() + "]";
        }
        catch (Throwable thr) {
            return original.getMessage();
        }
    }
}

