/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.jarFinder.InternetAttachSourceProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.build.CachedModuleDataFinder;
import org.jetbrains.plugins.gradle.execution.target.GradleTargetUtil;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.execution.BuildLayoutParameters;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManager;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleLog;
import org.jetbrains.plugins.gradle.util.GradleModuleData;

public class GradleAttachSourcesProvider
implements AttachSourcesProvider {
    @NotNull
    public Collection<AttachSourcesProvider.AttachSourcesAction> getActions(List<LibraryOrderEntry> orderEntries, final PsiFile psiFile) {
        Map<LibraryOrderEntry, Module> gradleModules = GradleAttachSourcesProvider.getGradleModules(orderEntries);
        if (gradleModules.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singleton(new AttachSourcesProvider.AttachSourcesAction(){

            public String getName() {
                return GradleBundle.message((String)"gradle.action.download.sources", (Object[])new Object[0]);
            }

            public String getBusyText() {
                return GradleBundle.message((String)"gradle.action.download.sources.busy.text", (Object[])new Object[0]);
            }

            public ActionCallback perform(final List<LibraryOrderEntry> orderEntries) {
                String sourcesLocationFilePath;
                File sourcesLocationFile;
                Map<LibraryOrderEntry, Module> gradleModules = GradleAttachSourcesProvider.getGradleModules(orderEntries);
                if (gradleModules.isEmpty()) {
                    return ActionCallback.REJECTED;
                }
                final ActionCallback resultWrapper = new ActionCallback();
                final Project project = psiFile.getProject();
                Map.Entry<LibraryOrderEntry, Module> next = gradleModules.entrySet().iterator().next();
                final LibraryOrderEntry libraryOrderEntry = next.getKey();
                Module module = next.getValue();
                String libraryName = libraryOrderEntry.getLibraryName();
                if (libraryName == null) {
                    return ActionCallback.REJECTED;
                }
                final String artifactCoordinates = StringUtil.trimStart((String)libraryName, (String)(GradleConstants.SYSTEM_ID.getReadableName() + ": "));
                if (StringUtil.equals((CharSequence)libraryName, (CharSequence)artifactCoordinates)) {
                    return ActionCallback.REJECTED;
                }
                GradleModuleData gradleModuleData = CachedModuleDataFinder.getGradleModuleData((Module)module);
                if (gradleModuleData == null) {
                    return ActionCallback.REJECTED;
                }
                String gradlePath = gradleModuleData.getGradlePath();
                String sourceArtifactNotation = GradleAttachSourcesProvider.getSourcesArtifactNotation(artifactIdCandidate -> {
                    Object[] rootFiles = libraryOrderEntry.getRootFiles(OrderRootType.CLASSES);
                    return rootFiles.length == 0 || ContainerUtil.exists((Object[])rootFiles, file -> file.getName().startsWith((String)artifactIdCandidate));
                }, artifactCoordinates);
                try {
                    sourcesLocationFile = new File(FileUtil.createTempDirectory((String)"sources", (String)"loc"), "path.tmp");
                    sourcesLocationFilePath = StringUtil.escapeBackSlashes((String)sourcesLocationFile.getCanonicalPath());
                    Runtime.getRuntime().addShutdownHook(new Thread(() -> FileUtil.delete((File)sourcesLocationFile), "GradleAttachSourcesProvider cleanup"));
                }
                catch (IOException e) {
                    GradleLog.LOG.warn((Throwable)e);
                    return ActionCallback.REJECTED;
                }
                String taskName = "DownloadSources";
                String initScript = "allprojects {\n  afterEvaluate { project ->\n    if(project.path == '" + gradlePath + "') {\n        def overwrite = project.tasks.findByName('DownloadSources') != null\n        project.tasks.create(name: 'DownloadSources', overwrite: overwrite) {\n        doLast {\n          def configuration = null\n          def repository = project.repositories.toList().find {\n              logger.lifecycle('Attempt to download sources from ' + it.name)\n              project.repositories.clear()\n              project.repositories.add(it)\n              configuration = project.configurations.create('downloadSourcesFrom_' + UUID.randomUUID())\n              configuration.transitive = false\n              project.dependencies.add(configuration.name, '" + sourceArtifactNotation + "')\n              def files = null\n              try {\n                files = configuration.resolvedConfiguration.lenientConfiguration.getFiles()\n              } catch (java.lang.Throwable ignore) { }\n              return files && !files.isEmpty()\n          }\n          if (!repository) {\n              configuration = project.configurations.create('downloadSources_' + UUID.randomUUID())\n              configuration.transitive = false\n              project.dependencies.add(configuration.name, '" + sourceArtifactNotation + "')\n              configuration.resolve()\n          }\n          def sourcesPath = configuration?.singleFile?.path\n          if (sourcesPath) {\n            logger.lifecycle('Sources were downloaded to ' + sourcesPath)\n            new File('" + sourcesLocationFilePath + "').write sourcesPath\n          } else throw new RuntimeException('Sources download failed')\n        }\n      }\n    }\n  }\n}\n";
                UserDataHolderBase userData = new UserDataHolderBase();
                userData.putUserData(GradleTaskManager.INIT_SCRIPT_KEY, (Object)initScript);
                String gradleVmOptions = GradleSettings.getInstance((Project)project).getGradleVmOptions();
                final ExternalSystemTaskExecutionSettings settings = new ExternalSystemTaskExecutionSettings();
                settings.setExecutionName(this.getName());
                settings.setExternalProjectPath(gradleModuleData.getDirectoryToRunTask());
                settings.setTaskNames(Collections.singletonList(gradleModuleData.getTaskPath("DownloadSources", true)));
                settings.setVmOptions(gradleVmOptions);
                settings.setExternalSystemIdString(GradleConstants.SYSTEM_ID.getId());
                ExternalSystemUtil.runTask((ExternalSystemTaskExecutionSettings)settings, (String)"Run", (Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (TaskCallback)new TaskCallback(){

                    public void onSuccess() {
                        VirtualFile classesFile = libraryOrderEntry.getFiles(OrderRootType.CLASSES)[0];
                        File sourceJar = GradleAttachSourcesProvider.getSourceFile(artifactCoordinates, classesFile, project, settings.getExternalProjectPath());
                        if (sourceJar == null) {
                            try {
                                sourceJar = new File(FileUtil.loadFile((File)sourcesLocationFile));
                                FileUtil.delete((File)sourcesLocationFile);
                            }
                            catch (IOException e) {
                                GradleLog.LOG.warn((Throwable)e);
                            }
                        }
                        File finalSourceJar = sourceJar;
                        ApplicationManager.getApplication().invokeLater(() -> {
                            HashSet libraries = new HashSet();
                            for (LibraryOrderEntry orderEntry : orderEntries) {
                                ContainerUtil.addIfNotNull(libraries, (Object)orderEntry.getLibrary());
                            }
                            if (finalSourceJar != null) {
                                InternetAttachSourceProvider.attachSourceJar((File)finalSourceJar, libraries);
                            }
                            resultWrapper.setDone();
                        });
                    }

                    public void onFailure() {
                        resultWrapper.setRejected();
                        String title = GradleBundle.message((String)"gradle.notifications.sources.download.failed.title", (Object[])new Object[0]);
                        String message = GradleBundle.message((String)"gradle.notifications.sources.download.failed.content", (Object[])new Object[]{artifactCoordinates});
                        NotificationData notification = new NotificationData(title, message, NotificationCategory.WARNING, NotificationSource.PROJECT_SYNC);
                        notification.setBalloonNotification(true);
                        ExternalSystemNotificationManager.getInstance((Project)project).showNotification(GradleConstants.SYSTEM_ID, notification);
                    }
                }, (ProgressExecutionMode)ProgressExecutionMode.IN_BACKGROUND_ASYNC, (boolean)false, (UserDataHolderBase)userData);
                return resultWrapper;
            }
        });
    }

    @NotNull
    @ApiStatus.Internal
    static String getSourcesArtifactNotation(@NotNull Predicate<String> artifactIdChecker, String artifactCoordinates) {
        boolean isArtifactId;
        String[] split = artifactCoordinates.split(":");
        Object groupNameVersionCoordinates = split.length == 4 ? ((isArtifactId = artifactIdChecker.test(split[1])) ? split[0] + ":" + split[1] + ":" + split[3] : artifactCoordinates) : (split.length == 5 ? split[0] + ":" + split[1] + ":" + split[4] : artifactCoordinates);
        return (String)groupNameVersionCoordinates + ":sources";
    }

    @Nullable
    private static File getSourceFile(@NotNull String artifactCoordinates, VirtualFile classesFile, @NotNull Project project, @NotNull @NlsSafe String projectPath) {
        LibraryData data = new LibraryData(GradleConstants.SYSTEM_ID, artifactCoordinates);
        data.addPath(LibraryPathType.BINARY, VfsUtil.getLocalFile((VirtualFile)classesFile).getPath());
        BuildLayoutParameters buildLayoutParameters = GradleInstallationManager.getInstance().guessBuildLayoutParameters(project, projectPath);
        String gradleUserHome = (String)GradleTargetUtil.maybeGetLocalValue((TargetValue)buildLayoutParameters.getGradleUserHome());
        if (gradleUserHome == null) {
            return null;
        }
        GradleProjectResolverUtil.attachSourcesAndJavadocFromGradleCacheIfNeeded((File)new File(gradleUserHome), (LibraryData)data);
        Iterator iterator = data.getPaths(LibraryPathType.SOURCE).iterator();
        return iterator.hasNext() ? new File((String)iterator.next()) : null;
    }

    private static Map<LibraryOrderEntry, Module> getGradleModules(List<LibraryOrderEntry> libraryOrderEntries) {
        HashMap<LibraryOrderEntry, Module> result = new HashMap<LibraryOrderEntry, Module>();
        for (LibraryOrderEntry entry : libraryOrderEntries) {
            Module module;
            if (entry.isModuleLevel() || !ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)(module = entry.getOwnerModule()))) continue;
            result.put(entry, module);
        }
        return result;
    }
}

