/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.resolve.GradleGroovyProperty;
import org.jetbrains.plugins.gradle.service.resolve.GradleProjectAwareType;
import org.jetbrains.plugins.gradle.settings.GradleExtensionsSettings;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J2\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleExtensionsContributor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/NonCodeMembersContributor;", "()V", "getParentClassName", "", "processDynamicElements", "", "qualifierType", "Lcom/intellij/psi/PsiType;", "aClass", "Lcom/intellij/psi/PsiClass;", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "place", "Lcom/intellij/psi/PsiElement;", "state", "Lcom/intellij/psi/ResolveState;", "Companion", "intellij.gradle.java"})
public final class GradleExtensionsContributor
extends NonCodeMembersContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected String getParentClassName() {
        return "org.gradle.api.Project";
    }

    public void processDynamicElements(@NotNull PsiType qualifierType, @Nullable PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        Collection collection;
        if (!(qualifierType instanceof GradleProjectAwareType)) {
            return;
        }
        if (!ResolveUtilKt.shouldProcessProperties((PsiScopeProcessor)processor)) {
            return;
        }
        PsiFile file = place.getContainingFile();
        GradleExtensionsSettings.GradleExtensionsData gradleExtensionsData = Companion.getExtensionsFor((PsiElement)file);
        if (gradleExtensionsData == null) {
            return;
        }
        GradleExtensionsSettings.GradleExtensionsData data = gradleExtensionsData;
        String name = ResolveUtilKt.getName((PsiScopeProcessor)processor, (ResolveState)state);
        if (name == null) {
            collection = data.findAllProperties();
        } else {
            GradleExtensionsSettings.GradleProp gradleProp = data.findProperty(name);
            if (gradleProp == null) {
                return;
            }
            collection = CollectionsKt.listOf((Object)gradleProp);
        }
        Collection properties = collection;
        for (GradleExtensionsSettings.GradleProp property : properties) {
            if (processor.execute((PsiElement)new GradleGroovyProperty(property, (PsiElement)file), state)) continue;
            return;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleExtensionsContributor$Companion;", "", "()V", "getExtensionsFor", "Lorg/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$GradleExtensionsData;", "psiElement", "Lcom/intellij/psi/PsiElement;", "intellij.gradle.java"})
    public static final class Companion {
        @Nullable
        public final GradleExtensionsSettings.GradleExtensionsData getExtensionsFor(@NotNull PsiElement psiElement) {
            Project project = psiElement.getProject();
            PsiFile psiFile = psiElement.getContainingFile();
            if (psiFile == null || (psiFile = psiFile.getOriginalFile()) == null || (psiFile = psiFile.getVirtualFile()) == null) {
                return null;
            }
            PsiFile virtualFile = psiFile;
            Module module = ProjectFileIndex.getInstance((Project)project).getModuleForFile((VirtualFile)virtualFile);
            return GradleExtensionsSettings.getInstance((Project)project).getExtensionsFor(module);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

