/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.ide.plugins.DependencyCollector;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/GradleDependencyCollector;", "Lcom/intellij/ide/plugins/DependencyCollector;", "()V", "collectDependencies", "", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.gradle.java"})
public final class GradleDependencyCollector
implements DependencyCollector {
    @NotNull
    public List<String> collectDependencies(@NotNull Project project) {
        Collection projectInfoList = ProjectDataManager.getInstance().getExternalProjectsData(project, GradleConstants.SYSTEM_ID);
        List result = new ArrayList();
        for (ExternalProjectInfo externalProjectInfo : projectInfoList) {
            DataNode projectStructure;
            if (externalProjectInfo.getExternalProjectStructure() == null) {
                continue;
            }
            Collection libraries = ExternalSystemApiUtil.findAll((DataNode)projectStructure, (Key)ProjectKeys.LIBRARY);
            for (DataNode libraryNode : libraries) {
                String groupId = ((LibraryData)libraryNode.getData()).getGroupId();
                String artifactId = ((LibraryData)libraryNode.getData()).getArtifactId();
                if (groupId == null || artifactId == null) continue;
                result.add(groupId + ":" + artifactId);
            }
        }
        return result;
    }
}

