/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.navigation;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.navigation.GradleVersionCatalogGotoDeclarationHandlerKt;
import org.jetbrains.plugins.gradle.service.navigation.GradleVersionCatalogTomlAwareGotoDeclarationHandlerKt;
import org.jetbrains.plugins.gradle.service.navigation.TomlHeaderKind;
import org.jetbrains.plugins.gradle.service.navigation.TomlVersionCatalogVisitor;
import org.jetbrains.plugins.groovy.intentions.style.inference.InferenceProcessUtilKt;
import org.toml.lang.psi.TomlKeySegment;
import org.toml.lang.psi.TomlKeyValue;
import org.toml.lang.psi.TomlRecursiveVisitor;
import org.toml.lang.psi.TomlTable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0003H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/gradle/service/navigation/TomlVersionCatalogVisitor;", "Lorg/toml/lang/psi/TomlRecursiveVisitor;", "containingClasses", "", "Lcom/intellij/psi/PsiClass;", "targetMethod", "Lcom/intellij/psi/PsiMethod;", "(Ljava/util/List;Lcom/intellij/psi/PsiMethod;)V", "", "resolveTarget", "Lcom/intellij/psi/PsiElement;", "getResolveTarget", "()Lcom/intellij/psi/PsiElement;", "setResolveTarget", "(Lcom/intellij/psi/PsiElement;)V", "getTargetMethod", "()Lcom/intellij/psi/PsiMethod;", "resolveAsComponent", "", "values", "Lorg/toml/lang/psi/TomlKeyValue;", "visitTable", "element", "Lorg/toml/lang/psi/TomlTable;", "intellij.gradle.java"})
final class TomlVersionCatalogVisitor
extends TomlRecursiveVisitor {
    private final List<PsiClass> containingClasses;
    @Nullable
    private PsiElement resolveTarget;
    @NotNull
    private final PsiMethod targetMethod;

    @Nullable
    public final PsiElement getResolveTarget() {
        return this.resolveTarget;
    }

    public final void setResolveTarget(@Nullable PsiElement psiElement) {
        this.resolveTarget = psiElement;
    }

    public void visitTable(@NotNull TomlTable element) {
        Object object = element.getHeader().getKey();
        if (object == null || (object = object.getSegments()) == null || (object = (TomlKeySegment)CollectionsKt.singleOrNull((List)object)) == null || (object = object.getName()) == null || (object = GradleVersionCatalogTomlAwareGotoDeclarationHandlerKt.access$getTomlHeaderKind((String)object)) == null) {
            return;
        }
        Object headerKind = object;
        PsiClass firstClass = (PsiClass)CollectionsKt.firstOrNull(this.containingClasses);
        if (firstClass != null) {
            TomlHeaderKind tomlHeaderKind = GradleVersionCatalogTomlAwareGotoDeclarationHandlerKt.access$getTomlHeaderKind(firstClass);
            if (tomlHeaderKind == null) {
                return;
            }
            TomlHeaderKind firstClassKind = tomlHeaderKind;
            if (headerKind != firstClassKind) {
                return;
            }
            PsiType psiType = this.targetMethod.getReturnType();
            if (Intrinsics.areEqual((Object)(psiType != null && (psiType = InferenceProcessUtilKt.resolve((PsiType)psiType)) != null ? psiType.getQualifiedName() : null), (Object)"org.gradle.api.provider.Provider") ^ true) {
                return;
            }
            this.resolveAsComponent(element.getEntries());
            return;
        }
        switch (this.targetMethod.getName()) {
            case "getPlugins": {
                if (headerKind == TomlHeaderKind.PLUGINS) {
                    this.resolveTarget = (PsiElement)element;
                    break;
                }
                return;
            }
            case "getBundles": {
                if (headerKind == TomlHeaderKind.BUNDLES) {
                    this.resolveTarget = (PsiElement)element;
                    break;
                }
                return;
            }
            case "getVersions": {
                if (headerKind == TomlHeaderKind.VERSIONS) {
                    this.resolveTarget = (PsiElement)element;
                    break;
                }
                return;
            }
            default: {
                if (headerKind == TomlHeaderKind.LIBRARIES) {
                    this.resolveAsComponent(element.getEntries());
                    break;
                }
                return;
            }
        }
    }

    private final void resolveAsComponent(List<? extends TomlKeyValue> values) {
        String camelCasedName = GradleVersionCatalogGotoDeclarationHandlerKt.getCapitalizedAccessorName(this.targetMethod);
        for (TomlKeyValue tomlKeyValue : values) {
            Object object = (TomlKeySegment)CollectionsKt.firstOrNull((List)tomlKeyValue.getKey().getSegments());
            if (object == null || (object = object.getName()) == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{"_", "-"}, (boolean)false, (int)0, (int)6, null)) == null || (object = CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)"", null, null, (int)0, null, (Function1)resolveAsComponent.keyName.1.INSTANCE, (int)30, null)) == null) {
                continue;
            }
            Object keyName2 = object;
            if (!Intrinsics.areEqual((Object)camelCasedName, (Object)keyName2)) continue;
            this.resolveTarget = (PsiElement)tomlKeyValue;
            return;
        }
    }

    @NotNull
    public final PsiMethod getTargetMethod() {
        return this.targetMethod;
    }

    public TomlVersionCatalogVisitor(@NotNull List<? extends PsiClass> containingClasses, @NotNull PsiMethod targetMethod) {
        this.targetMethod = targetMethod;
        this.containingClasses = new ArrayList(containingClasses);
    }
}

