/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.navigation;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.UtilKt;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.plugins.gradle.service.navigation.TomlHeaderKind;
import org.jetbrains.plugins.gradle.service.navigation.TomlVersionCatalogVisitor;
import org.jetbrains.plugins.gradle.service.project.VersionCatalogProjectResolverKt;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.toml.lang.psi.TomlFile;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u000fH\u0002\u001a\u000e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u0001H\u0002\u001a\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u000b*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"METHOD_GET_BUNDLES", "", "METHOD_GET_PLUGINS", "METHOD_GET_VERSIONS", "TOML_TABLE_BUNDLES", "TOML_TABLE_LIBRARIES", "TOML_TABLE_PLUGINS", "TOML_TABLE_VERSIONS", "findTomlFile", "Lorg/toml/lang/psi/TomlFile;", "context", "Lcom/intellij/psi/PsiElement;", "name", "getTomlHeaderKind", "Lorg/jetbrains/plugins/gradle/service/navigation/TomlHeaderKind;", "Lcom/intellij/psi/PsiClass;", "resolveInToml", "Lcom/intellij/psi/PsiMethod;", "sourceElement", "intellij.gradle.java"})
public final class GradleVersionCatalogTomlAwareGotoDeclarationHandlerKt {
    private static final String TOML_TABLE_VERSIONS = "versions";
    private static final String TOML_TABLE_LIBRARIES = "libraries";
    private static final String TOML_TABLE_BUNDLES = "bundles";
    private static final String TOML_TABLE_PLUGINS = "plugins";
    private static final String METHOD_GET_PLUGINS = "getPlugins";
    private static final String METHOD_GET_VERSIONS = "getVersions";
    private static final String METHOD_GET_BUNDLES = "getBundles";

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final TomlFile findTomlFile(PsiElement context, String name) {
        void $this$castSafelyTo$iv;
        VirtualFile virtualFile4;
        void $this$castSafelyTo$iv2;
        PsiFile psiFile;
        VirtualFile virtualFile2;
        String string = org.jetbrains.plugins.gradle.service.resolve.UtilKt.getRootGradleProjectPath(context);
        if (string == null) return null;
        String path = string;
        Path settingsFile = Path.of(path, "settings.gradle");
        VirtualFile virtualFile3 = VfsUtil.findFile((Path)settingsFile, (boolean)false);
        if (virtualFile3 != null) {
            VirtualFile it = virtualFile2 = virtualFile3;
            boolean virtualFile4 = false;
            psiFile = PsiUtilCore.getPsiFile((Project)context.getProject(), (VirtualFile)it);
        } else {
            psiFile = null;
        }
        virtualFile2 = psiFile;
        boolean $i$f$castSafelyTo = false;
        Object v3 = $this$castSafelyTo$iv2;
        if (!(v3 instanceof GroovyFileBase)) {
            v3 = null;
        }
        GroovyFileBase groovyFileBase = v3;
        if (groovyFileBase == null) return null;
        GroovyFileBase settingsPsi = groovyFileBase;
        Map<String, Path> tomlRegistry = VersionCatalogProjectResolverKt.getVersionCatalogsData(settingsPsi);
        Path path2 = tomlRegistry.get(name);
        if (path2 == null) return null;
        Path toml = path2;
        VirtualFile virtualFile5 = VfsUtil.findFile((Path)toml, (boolean)false);
        VirtualFile virtualFile6 = virtualFile5;
        if (virtualFile5 == null) return null;
        VirtualFile it = virtualFile4 = virtualFile6;
        boolean bl = false;
        PsiFile psiFile2 = PsiManager.getInstance((Project)context.getProject()).findFile(it);
        virtualFile6 = psiFile2;
        if (psiFile2 == null) return null;
        virtualFile4 = virtualFile6;
        boolean $i$f$castSafelyTo2 = false;
        Object v9 = $this$castSafelyTo$iv;
        if (!(v9 instanceof TomlFile)) {
            v9 = null;
        }
        TomlFile tomlFile = v9;
        return tomlFile;
    }

    private static final PsiElement resolveInToml(PsiMethod $this$resolveInToml, PsiElement sourceElement) {
        TomlFile tomlFile;
        List containingClasses;
        block5: {
            Object[] objectArray = new PsiClass[1];
            PsiClass psiClass = $this$resolveInToml.getContainingClass();
            if (psiClass == null) {
                return null;
            }
            objectArray[0] = psiClass;
            containingClasses = CollectionsKt.mutableListOf((Object[])objectArray);
            while (((PsiClass)CollectionsKt.last((List)containingClasses)).getContainingClass() != null) {
                PsiClass psiClass2 = ((PsiClass)CollectionsKt.last((List)containingClasses)).getContainingClass();
                Intrinsics.checkNotNull((Object)psiClass2);
                containingClasses.add(psiClass2);
            }
            CollectionsKt.reverse((List)containingClasses);
            String string = ((PsiClass)CollectionsKt.first((List)containingClasses)).getName();
            if (string == null || (string = StringsKt.substringAfter$default((String)string, (String)"LibrariesFor", null, (int)2, null)) == null) {
                return null;
            }
            String name = string;
            Iterable iterable = CollectionsKt.listOf((Object[])new String[]{GroovyPropertyUtils.decapitalize((String)name), name});
            for (Object t : iterable) {
                String it = (String)t;
                boolean bl = false;
                TomlFile tomlFile2 = GradleVersionCatalogTomlAwareGotoDeclarationHandlerKt.findTomlFile(sourceElement, it);
                if (tomlFile2 == null) continue;
                tomlFile = tomlFile2;
                break block5;
            }
            tomlFile = null;
        }
        if (tomlFile == null) {
            return null;
        }
        TomlFile toml = tomlFile;
        TomlVersionCatalogVisitor tomlVisitor = new TomlVersionCatalogVisitor(UtilKt.tail((List)containingClasses), $this$resolveInToml);
        toml.accept((PsiElementVisitor)tomlVisitor);
        return tomlVisitor.getResolveTarget();
    }

    private static final TomlHeaderKind getTomlHeaderKind(PsiClass $this$getTomlHeaderKind) {
        String string = $this$getTomlHeaderKind.getName();
        if (string == null) {
            return null;
        }
        String name = string;
        return StringsKt.endsWith$default((String)name, (String)"VersionAccessors", (boolean)false, (int)2, null) ? TomlHeaderKind.VERSIONS : (StringsKt.endsWith$default((String)name, (String)"BundleAccessors", (boolean)false, (int)2, null) ? TomlHeaderKind.BUNDLES : (StringsKt.endsWith$default((String)name, (String)"PluginAccessors", (boolean)false, (int)2, null) ? TomlHeaderKind.PLUGINS : (StringsKt.endsWith$default((String)name, (String)"LibraryAccessors", (boolean)false, (int)2, null) ? TomlHeaderKind.LIBRARIES : null)));
    }

    private static final TomlHeaderKind getTomlHeaderKind(String $this$getTomlHeaderKind) {
        TomlHeaderKind tomlHeaderKind;
        switch ($this$getTomlHeaderKind) {
            case "versions": {
                tomlHeaderKind = TomlHeaderKind.VERSIONS;
                break;
            }
            case "libraries": {
                tomlHeaderKind = TomlHeaderKind.LIBRARIES;
                break;
            }
            case "bundles": {
                tomlHeaderKind = TomlHeaderKind.BUNDLES;
                break;
            }
            case "plugins": {
                tomlHeaderKind = TomlHeaderKind.PLUGINS;
                break;
            }
            default: {
                tomlHeaderKind = null;
            }
        }
        return tomlHeaderKind;
    }

    public static final /* synthetic */ TomlFile access$findTomlFile(PsiElement context, String name) {
        return GradleVersionCatalogTomlAwareGotoDeclarationHandlerKt.findTomlFile(context, name);
    }

    public static final /* synthetic */ PsiElement access$resolveInToml(PsiMethod $this$access_u24resolveInToml, PsiElement sourceElement) {
        return GradleVersionCatalogTomlAwareGotoDeclarationHandlerKt.resolveInToml($this$access_u24resolveInToml, sourceElement);
    }

    public static final /* synthetic */ TomlHeaderKind access$getTomlHeaderKind(String $this$access_u24getTomlHeaderKind) {
        return GradleVersionCatalogTomlAwareGotoDeclarationHandlerKt.getTomlHeaderKind($this$access_u24getTomlHeaderKind);
    }

    public static final /* synthetic */ TomlHeaderKind access$getTomlHeaderKind(PsiClass $this$access_u24getTomlHeaderKind) {
        return GradleVersionCatalogTomlAwareGotoDeclarationHandlerKt.getTomlHeaderKind($this$access_u24getTomlHeaderKind);
    }
}

