/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.openapi.util.text.Strings;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.Reader;
import java.io.StringReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXmlView;

public class TestEventXPPXmlView
implements TestEventXmlView {
    private static final HierarchicalStreamDriver DRIVER = new XppDriver();
    private String myTestEventType;
    private String myTestParentId;
    private String myTestId;
    private String myTestClassName;
    private String myTestEventResultType;
    private String myEventTitle;
    private String myEventOpenSettings;
    private String myEventMessage;
    private String myTestEventTest;
    private String myTestEventTestDescription;
    private String myEventTestReport;
    private String myEventTestResultActionFilePath;
    private String myEventTestResultFilePath;
    private String myEventTestResultExpected;
    private String myEventTestResultActual;
    private String myEventTestResultFailureType;
    private String myEventTestResultStackTrace;
    private String myEventTestResultErrorMsg;
    private String myEventTestResultEndTime;
    private String myEventTestResultStartTime;
    private String myTestName;
    private String myTestDisplayName;

    public TestEventXPPXmlView(@NotNull String xml) {
        HierarchicalStreamReader parser = DRIVER.createReader((Reader)new StringReader(xml));
        if (!"ijLog".equals(parser.getNodeName())) {
            throw new RuntimeException("root element must be 'ijLog'");
        }
        while (parser.hasMoreChildren()) {
            parser.moveDown();
            if ("event".equals(parser.getNodeName())) {
                this.myTestEventType = parser.getAttribute("type");
                this.myEventOpenSettings = parser.getAttribute("openSettings");
                this.myEventTestReport = parser.getAttribute("testReport");
                while (parser.hasMoreChildren()) {
                    parser.moveDown();
                    if ("title".equals(parser.getNodeName())) {
                        this.myEventTitle = parser.getValue();
                    } else if ("message".equals(parser.getNodeName())) {
                        this.myEventMessage = parser.getValue();
                    } else if ("test".equals(parser.getNodeName())) {
                        this.myTestParentId = parser.getAttribute("parentId");
                        this.myTestId = parser.getAttribute("id");
                        while (parser.hasMoreChildren()) {
                            parser.moveDown();
                            if ("descriptor".equals(parser.getNodeName())) {
                                this.myTestName = parser.getAttribute("name");
                                this.myTestDisplayName = parser.getAttribute("displayName");
                                this.myTestClassName = parser.getAttribute("className");
                            } else if ("event".equals(parser.getNodeName())) {
                                this.myTestEventTestDescription = parser.getAttribute("destination");
                                this.myTestEventTest = parser.getValue();
                            } else if ("result".equals(parser.getNodeName())) {
                                this.myTestEventResultType = parser.getAttribute("resultType");
                                this.myEventTestResultEndTime = parser.getAttribute("endTime");
                                this.myEventTestResultStartTime = parser.getAttribute("startTime");
                                while (parser.hasMoreChildren()) {
                                    parser.moveDown();
                                    if ("actualFilePath".equals(parser.getNodeName())) {
                                        this.myEventTestResultActionFilePath = parser.getValue();
                                    } else if ("filePath".equals(parser.getNodeName())) {
                                        this.myEventTestResultFilePath = parser.getValue();
                                    } else if ("expected".equals(parser.getNodeName())) {
                                        this.myEventTestResultExpected = parser.getValue();
                                    } else if ("actual".equals(parser.getNodeName())) {
                                        this.myEventTestResultActual = parser.getValue();
                                    } else if ("failureType".equals(parser.getNodeName())) {
                                        this.myEventTestResultFailureType = parser.getValue();
                                    } else if ("stackTrace".equals(parser.getNodeName())) {
                                        this.myEventTestResultStackTrace = parser.getValue();
                                    } else if ("errorMsg".equals(parser.getNodeName())) {
                                        this.myEventTestResultErrorMsg = parser.getValue();
                                    }
                                    parser.moveUp();
                                }
                            }
                            parser.moveUp();
                        }
                    }
                    parser.moveUp();
                }
            }
            parser.moveUp();
        }
    }

    @Override
    @NotNull
    public String getTestEventType() {
        return this.myTestEventType == null ? "" : this.myTestEventType;
    }

    @Override
    @NotNull
    public String getTestName() {
        return this.myTestName == null ? "" : this.myTestName;
    }

    @Override
    @NotNull
    public String getTestDisplayName() {
        return Strings.isEmpty((String)this.myTestDisplayName) ? this.getTestName() : this.myTestDisplayName;
    }

    @Override
    @NotNull
    public String getTestParentId() {
        return this.myTestParentId == null ? "" : this.myTestParentId;
    }

    @Override
    @NotNull
    public String getTestId() {
        return this.myTestId == null ? "" : this.myTestId;
    }

    @Override
    @NotNull
    public String getTestClassName() {
        return this.myTestClassName == null ? "" : this.myTestClassName;
    }

    @Override
    @NotNull
    public String getTestEventResultType() {
        return this.myTestEventResultType == null ? "" : this.myTestEventResultType;
    }

    @Override
    @NotNull
    public String getEventTitle() {
        return this.myEventTitle == null ? "" : this.myEventTitle;
    }

    @Override
    public boolean isEventOpenSettings() {
        return Boolean.parseBoolean(this.myEventOpenSettings == null ? "" : this.myEventOpenSettings);
    }

    @Override
    @NotNull
    public String getEventMessage() {
        return this.myEventMessage == null ? "" : this.myEventMessage;
    }

    @Override
    @NotNull
    public String getTestEventTest() {
        return this.myTestEventTest == null ? "" : this.myTestEventTest;
    }

    @Override
    @NotNull
    public String getTestEventTestDescription() {
        return this.myTestEventTestDescription == null ? "" : this.myTestEventTestDescription;
    }

    @Override
    @NotNull
    public String getEventTestReport() {
        return this.myEventTestReport == null ? "" : this.myEventTestReport;
    }

    @Override
    @NotNull
    public String getEventTestResultActualFilePath() {
        return this.myEventTestResultActionFilePath == null ? "" : this.myEventTestResultActionFilePath;
    }

    @Override
    @NotNull
    public String getEventTestResultFilePath() {
        return this.myEventTestResultFilePath == null ? "" : this.myEventTestResultFilePath;
    }

    @Override
    @NotNull
    public String getEventTestResultExpected() {
        return this.myEventTestResultExpected == null ? "" : this.myEventTestResultExpected;
    }

    @Override
    @NotNull
    public String getEventTestResultActual() {
        return this.myEventTestResultActual == null ? "" : this.myEventTestResultActual;
    }

    @Override
    @NotNull
    public String getEventTestResultFailureType() {
        return this.myEventTestResultFailureType == null ? "" : this.myEventTestResultFailureType;
    }

    @Override
    @NotNull
    public String getEventTestResultStackTrace() {
        return this.myEventTestResultStackTrace == null ? "" : this.myEventTestResultStackTrace;
    }

    @Override
    @NotNull
    public String getEventTestResultErrorMsg() {
        return this.myEventTestResultErrorMsg == null ? "" : this.myEventTestResultErrorMsg;
    }

    @Override
    @NotNull
    public String getEventTestResultEndTime() {
        return this.myEventTestResultEndTime == null ? "" : this.myEventTestResultEndTime;
    }

    @Override
    @NotNull
    public String getEventTestResultStartTime() {
        return this.myEventTestResultStartTime == null ? "" : this.myEventTestResultStartTime;
    }
}

