/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.events.TestOutputEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemMessageEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.TestOperationDescriptor;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXmlView;

public class OnOutputEvent
extends AbstractTestEvent {
    private static final String OUT = "StdOut";
    private static final String ERR = "StdErr";

    public OnOutputEvent(GradleTestsExecutionConsole executionConsole) {
        super(executionConsole);
    }

    @Override
    public void process(@NotNull TestEventXmlView eventXml) throws TestEventXmlView.XmlParserException {
        String testId = eventXml.getTestId();
        String destinationString = eventXml.getTestEventTestDescription();
        String output = this.decode(eventXml.getTestEventTest());
        Key destination = OUT.equals(destinationString) ? ProcessOutputTypes.STDOUT : ProcessOutputTypes.STDERR;
        this.doProcess(testId, output, destination);
    }

    @Override
    public void process(@NotNull ExternalSystemProgressEvent<? extends TestOperationDescriptor> testEvent) {
        if (!(testEvent instanceof ExternalSystemMessageEvent)) {
            return;
        }
        TestOperationDescriptor testDescriptor = (TestOperationDescriptor)testEvent.getDescriptor();
        String testId = testEvent.getEventId();
        String description = ((ExternalSystemMessageEvent)testEvent).getDescription();
        if (description == null) {
            this.doProcess(testId, "", ProcessOutputTypes.STDERR);
        } else if (description.startsWith(OUT)) {
            this.doProcess(testId, description.substring(OUT.length()), ProcessOutputTypes.STDOUT);
        } else if (description.startsWith(ERR)) {
            this.doProcess(testId, description.substring(ERR.length()), ProcessOutputTypes.STDERR);
        }
    }

    private void doProcess(String testId, String output, @NotNull Key type) {
        SMTestProxy testProxy = this.findTestProxy(testId);
        if (testProxy == null) {
            return;
        }
        testProxy.addOutput(output, type);
        this.getExecutionConsole().getEventPublisher().onTestOutput(testProxy, new TestOutputEvent(testProxy.getName(), output, type == ProcessOutputTypes.STDOUT));
    }
}

