/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.TestOperationDescriptor;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.GradleManager;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXmlView;
import org.jetbrains.plugins.gradle.service.project.GradleNotification;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class ConfigurationErrorEvent
extends AbstractTestEvent {
    public ConfigurationErrorEvent(GradleTestsExecutionConsole executionConsole) {
        super(executionConsole);
    }

    @Override
    public void process(@NotNull TestEventXmlView xml) throws TestEventXmlView.XmlParserException {
        @NlsSafe String errorTitle = xml.getEventTitle();
        String configurationErrorMsg = xml.getEventMessage();
        boolean openSettings = xml.isEventOpenSettings();
        final Project project = this.getProject();
        assert (project != null);
        String message = this.getConfigurationErrorMessage(configurationErrorMsg, openSettings);
        GradleNotification.NOTIFICATION_GROUP.createNotification(errorTitle, message, NotificationType.WARNING).setDisplayId("gradle.configuration.error").setListener(new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                notification.expire();
                if ("Gradle settings".equals(event.getDescription())) {
                    ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)GradleConstants.SYSTEM_ID);
                    assert (manager instanceof GradleManager);
                    GradleManager gradleManager = (GradleManager)manager;
                    Configurable configurable = gradleManager.getConfigurable(project);
                    ShowSettingsUtil.getInstance().editConfigurable(project, configurable);
                } else {
                    BrowserUtil.browse((String)event.getDescription());
                }
            }
        }).notify(project);
    }

    @Nls
    private String getConfigurationErrorMessage(@NlsSafe String configurationErrorMsg, boolean openSettings) {
        if (openSettings) {
            return new HtmlBuilder().append((HtmlChunk)HtmlChunk.br()).append("\n").append(configurationErrorMsg).append((HtmlChunk)HtmlChunk.link((String)"Gradle settings", (String)GradleBundle.message((String)"gradle.open.gradle.settings", (Object[])new Object[0]))).toString();
        }
        return new HtmlBuilder().append((HtmlChunk)HtmlChunk.br()).append("\n").append(configurationErrorMsg).toString();
    }

    @Override
    public void process(@NotNull ExternalSystemProgressEvent<? extends TestOperationDescriptor> testEvent) {
    }
}

