/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.junit.InheritorChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.execution.test.runner.AbstractGradleTestRunConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.PatternGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestClassGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.util.GradleExecutionSettingsUtil;
import org.jetbrains.plugins.gradle.util.TasksToRun;

public class TestMethodGradleConfigurationProducer
extends AbstractGradleTestRunConfigurationProducer<PsiMethod, PsiClass> {
    @Override
    public boolean isPreferredConfiguration(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        return !other.isProducedBy(PatternGradleConfigurationProducer.class) && (other.isProducedBy(TestClassGradleConfigurationProducer.class) || super.isPreferredConfiguration(self, other));
    }

    @Override
    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        return !other.isProducedBy(PatternGradleConfigurationProducer.class) && (other.isProducedBy(TestClassGradleConfigurationProducer.class) || super.shouldReplace(self, other));
    }

    @Nullable
    protected PsiMethod getPsiMethodForLocation(@NotNull Location<?> contextLocation) {
        Location<PsiMethod> location = GradleRunnerUtil.getMethodLocation(contextLocation);
        return location != null ? (PsiMethod)location.getPsiElement() : null;
    }

    @Override
    @Nullable
    protected PsiMethod getElement(@NotNull ConfigurationContext context) {
        Location location = context.getLocation();
        if (location == null) {
            return null;
        }
        PsiMethod psiMethod = this.getPsiMethodForLocation(location);
        if (psiMethod == null) {
            return null;
        }
        PsiClass psiClass = psiMethod.getContainingClass();
        if (psiClass == null || psiClass.getName() == null || psiClass.getQualifiedName() == null) {
            return null;
        }
        PsiFile psiFile = psiMethod.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile source = psiFile.getVirtualFile();
        if (source == null) {
            return null;
        }
        return psiMethod;
    }

    @Override
    @NotNull
    protected String getLocationName(@NotNull ConfigurationContext context, @NotNull PsiMethod element) {
        return element.getName();
    }

    @Override
    @NotNull
    protected String suggestConfigurationName(@NotNull ConfigurationContext context, @NotNull PsiMethod element, @NotNull List<? extends PsiClass> chosenElements) {
        PsiClass psiClass = Objects.requireNonNull(element.getContainingClass());
        List<? extends PsiClass> elements = chosenElements.isEmpty() ? List.of(psiClass) : chosenElements;
        return StringUtil.join(elements, aClass -> aClass.getName() + "." + element.getName(), (String)"|");
    }

    @Override
    protected void chooseSourceElements(@NotNull ConfigurationContext context, @NotNull PsiMethod element, @NotNull Consumer<List<PsiClass>> onElementsChosen) {
        PsiClass psiClass = Objects.requireNonNull(element.getContainingClass());
        InheritorChooser.chooseAbstractClassInheritors((ConfigurationContext)context, (PsiClass)psiClass, onElementsChosen);
    }

    @Override
    @NotNull
    protected List<AbstractGradleTestRunConfigurationProducer.TestTasksToRun> getAllTestsTaskToRun(@NotNull ConfigurationContext context, @NotNull PsiMethod element, @NotNull List<? extends PsiClass> chosenElements) {
        Project project = Objects.requireNonNull(context.getProject());
        Location location = Objects.requireNonNull(context.getLocation());
        VirtualFile source = Objects.requireNonNull(element.getContainingFile().getVirtualFile());
        PsiClass aClass = Objects.requireNonNull(element.getContainingClass());
        List<? extends PsiClass> elements = chosenElements.isEmpty() ? List.of(aClass) : chosenElements;
        ArrayList<AbstractGradleTestRunConfigurationProducer.TestTasksToRun> testsTasksToRun = new ArrayList<AbstractGradleTestRunConfigurationProducer.TestTasksToRun>();
        for (PsiClass psiClass : elements) {
            String testFilter = GradleExecutionSettingsUtil.createTestFilterFrom(location, psiClass, element);
            testsTasksToRun.addAll(ContainerUtil.map(TestMethodGradleConfigurationProducer.findAllTestsTaskToRun(source, project), it -> new AbstractGradleTestRunConfigurationProducer.TestTasksToRun((TasksToRun)it, testFilter)));
        }
        return testsTasksToRun;
    }
}

