/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.junit.InheritorChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.execution.test.runner.AbstractGradleTestRunConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.PatternGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestMethodGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;
import org.jetbrains.plugins.gradle.util.GradleExecutionSettingsUtil;
import org.jetbrains.plugins.gradle.util.TasksToRun;

public class TestClassGradleConfigurationProducer
extends AbstractGradleTestRunConfigurationProducer<PsiClass, PsiClass> {
    @Override
    public boolean isPreferredConfiguration(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        return !other.isProducedBy(PatternGradleConfigurationProducer.class) && !other.isProducedBy(TestMethodGradleConfigurationProducer.class) && super.isPreferredConfiguration(self, other);
    }

    @Override
    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        return !other.isProducedBy(PatternGradleConfigurationProducer.class) && !other.isProducedBy(TestMethodGradleConfigurationProducer.class) && super.shouldReplace(self, other);
    }

    @Nullable
    protected PsiClass getPsiClassForLocation(Location<?> contextLocation) {
        PsiClass[] classes;
        Location location = JavaExecutionUtil.stepIntoSingleClass(contextLocation);
        if (location == null) {
            return null;
        }
        TestFrameworks testFrameworks = TestFrameworks.getInstance();
        Iterator iterator = location.getAncestors(PsiClass.class, false);
        while (iterator.hasNext()) {
            Location classLocation = (Location)iterator.next();
            if (!testFrameworks.isTestClass((PsiClass)classLocation.getPsiElement())) continue;
            return (PsiClass)classLocation.getPsiElement();
        }
        PsiElement element = location.getPsiElement();
        if (element instanceof PsiClassOwner && (classes = ((PsiClassOwner)element).getClasses()).length == 1 && testFrameworks.isTestClass(classes[0])) {
            return classes[0];
        }
        return null;
    }

    @Override
    @Nullable
    protected PsiClass getElement(@NotNull ConfigurationContext context) {
        Location location = context.getLocation();
        if (location == null) {
            return null;
        }
        PsiClass psiClass = this.getPsiClassForLocation(location);
        if (psiClass == null) {
            return null;
        }
        PsiFile psiFile = psiClass.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile source = psiFile.getVirtualFile();
        if (source == null) {
            return null;
        }
        return psiClass;
    }

    @Override
    @NotNull
    protected String getLocationName(@NotNull ConfigurationContext context, @NotNull PsiClass element) {
        return Objects.requireNonNull(element.getName());
    }

    @Override
    @NotNull
    protected String suggestConfigurationName(@NotNull ConfigurationContext context, @NotNull PsiClass element, @NotNull List<? extends PsiClass> chosenElements) {
        List<? extends PsiClass> elements = chosenElements.isEmpty() ? List.of(element) : chosenElements;
        return StringUtil.join(elements, aClass -> aClass.getName(), (String)"|");
    }

    @Override
    protected void chooseSourceElements(@NotNull ConfigurationContext context, @NotNull PsiClass element, @NotNull Consumer<List<PsiClass>> onElementsChosen) {
        InheritorChooser.chooseAbstractClassInheritors((ConfigurationContext)context, (PsiClass)element, onElementsChosen);
    }

    @Override
    @NotNull
    protected List<AbstractGradleTestRunConfigurationProducer.TestTasksToRun> getAllTestsTaskToRun(@NotNull ConfigurationContext context, @NotNull PsiClass element, @NotNull List<? extends PsiClass> chosenElements) {
        Project project = Objects.requireNonNull(context.getProject());
        VirtualFile source = Objects.requireNonNull(element.getContainingFile().getVirtualFile());
        List<? extends PsiClass> elements = chosenElements.isEmpty() ? List.of(element) : chosenElements;
        ArrayList<AbstractGradleTestRunConfigurationProducer.TestTasksToRun> testsTasksToRun = new ArrayList<AbstractGradleTestRunConfigurationProducer.TestTasksToRun>();
        for (PsiClass psiClass : elements) {
            String testFilter = GradleExecutionSettingsUtil.createTestFilterFrom(psiClass);
            testsTasksToRun.addAll(ContainerUtil.map(TestClassGradleConfigurationProducer.findAllTestsTaskToRun(source, project), it -> new AbstractGradleTestRunConfigurationProducer.TestTasksToRun((TasksToRun)it, testFilter)));
        }
        return testsTasksToRun;
    }

    private static boolean pointsToMethod(@NotNull ConfigurationContext context) {
        Location location = context.getLocation();
        return location != null && GradleRunnerUtil.getMethodLocation(location) != null;
    }

    @Override
    protected boolean doSetupConfigurationFromContext(@NotNull GradleRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        if (TestClassGradleConfigurationProducer.pointsToMethod(context)) {
            return false;
        }
        return super.doSetupConfigurationFromContext(configuration, context, sourceElement);
    }

    @Override
    protected boolean doIsConfigurationFromContext(@NotNull GradleRunConfiguration configuration, @NotNull ConfigurationContext context) {
        if (TestClassGradleConfigurationProducer.pointsToMethod(context)) {
            return false;
        }
        return super.doIsConfigurationFromContext(configuration, context);
    }
}

