/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.build.BuildContentManager;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildViewManager;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.FailureResult;
import com.intellij.build.events.FileMessageEvent;
import com.intellij.build.events.FinishBuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.build.events.StartEvent;
import com.intellij.build.events.impl.ProgressBuildEventImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMRunnerConsolePropertiesProvider;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.history.actions.AbstractImportTestsAction;
import com.intellij.execution.testframework.sm.runner.ui.SMRootTestProxyFormatter;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.execution.testframework.sm.runner.ui.TestTreeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.externalSystem.execution.ExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.model.task.event.OperationDescriptor;
import com.intellij.openapi.externalSystem.model.task.event.TestOperationDescriptor;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfigurationViewManager;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemExecuteTaskTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.action.GradleRerunFailedTestsAction;
import org.jetbrains.plugins.gradle.execution.filters.ReRunTaskFilter;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleConsoleProperties;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestEventsProcessor;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsoleOutputProcessor;
import org.jetbrains.plugins.gradle.service.project.GradleTasksIndices;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleTaskData;

public class GradleTestsExecutionConsoleManager
implements ExternalSystemExecutionConsoleManager<GradleTestsExecutionConsole, ProcessHandler> {
    @NotNull
    public ProjectSystemId getExternalSystemId() {
        return GradleConstants.SYSTEM_ID;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public GradleTestsExecutionConsole attachExecutionConsole(final @NotNull Project project, final @NotNull ExternalSystemTask task, @Nullable ExecutionEnvironment env, @Nullable ProcessHandler processHandler) {
        TestTreeRenderer originalRenderer;
        RunConfiguration configuration;
        if (env == null) {
            return null;
        }
        SMTRunnerConsoleProperties consoleProperties = null;
        RunnerAndConfigurationSettings settings = env.getRunnerAndConfigurationSettings();
        if (settings == null) {
            RunProfile runProfile = env.getRunProfile();
            if (!(runProfile instanceof AbstractImportTestsAction.ImportRunProfile)) return null;
            configuration = ((AbstractImportTestsAction.ImportRunProfile)runProfile).getInitialConfiguration();
            if (configuration instanceof SMRunnerConsolePropertiesProvider) {
                consoleProperties = ((SMRunnerConsolePropertiesProvider)configuration).createTestConsoleProperties(DefaultRunExecutor.getRunExecutorInstance());
            }
        } else {
            configuration = settings.getConfiguration();
        }
        if (!(configuration instanceof ExternalSystemRunConfiguration)) {
            return null;
        }
        ExternalSystemRunConfiguration externalSystemRunConfiguration = (ExternalSystemRunConfiguration)configuration;
        if (consoleProperties == null) {
            consoleProperties = new GradleConsoleProperties(externalSystemRunConfiguration, env.getExecutor());
        }
        String testFrameworkName = externalSystemRunConfiguration.getSettings().getExternalSystemId().getReadableName();
        String splitterPropertyName = SMTestRunnerConnectionUtil.getSplitterPropertyName((String)testFrameworkName);
        GradleTestsExecutionConsole consoleView = new GradleTestsExecutionConsole(project, task.getId(), (TestConsoleProperties)consoleProperties, splitterPropertyName);
        SMTestRunnerConnectionUtil.initConsoleView((SMTRunnerConsoleView)consoleView, (String)testFrameworkName);
        final SMTestRunnerResultsForm resultsViewer = consoleView.getResultsViewer();
        TestTreeView testTreeView = resultsViewer.getTreeView();
        if (testTreeView != null && (originalRenderer = (TestTreeRenderer)ObjectUtils.tryCast((Object)testTreeView.getCellRenderer(), TestTreeRenderer.class)) != null) {
            originalRenderer.setAdditionalRootFormatter(new SMRootTestProxyFormatter(){

                public void format(@NotNull SMTestProxy.SMRootTestProxy testProxy, @NotNull TestTreeRenderer renderer2) {
                    if (!testProxy.isInProgress() && testProxy.isEmptySuite()) {
                        renderer2.clear();
                        renderer2.append(GradleBundle.message((String)"gradle.test.runner.ui.tests.tree.presentation.labels.no.tests.were.found", (Object[])new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
            });
        }
        final SMTestProxy.SMRootTestProxy testsRootNode = resultsViewer.getTestsRootNode();
        testsRootNode.setExecutionId(env.getExecutionId());
        testsRootNode.setSuiteStarted();
        consoleView.getEventPublisher().onTestingStarted(testsRootNode);
        if (processHandler != null) {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (testsRootNode.isInProgress()) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (event.getExitCode() == 1) {
                                testsRootNode.setTestFailed("", null, false);
                            } else {
                                testsRootNode.setFinished();
                            }
                            resultsViewer.onBeforeTestingFinished(testsRootNode);
                            resultsViewer.onTestingFinished(testsRootNode);
                        });
                    }
                }
            });
        }
        if (task instanceof ExternalSystemExecuteTaskTask) {
            consoleView.addMessageFilter((Filter)new ReRunTaskFilter((ExternalSystemExecuteTaskTask)task, env));
        }
        final Disposable disposable = Disposer.newDisposable((Disposable)consoleView, (String)"Gradle test runner build event listener disposable");
        final BuildViewManager buildViewManager = (BuildViewManager)project.getService(BuildViewManager.class);
        ((ExternalSystemRunConfigurationViewManager)project.getService(ExternalSystemRunConfigurationViewManager.class)).addListener(new BuildProgressListener(){

            public void onEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
                if (buildId != task.getId()) {
                    return;
                }
                if (event instanceof FinishBuildEvent) {
                    Disposer.dispose((Disposable)disposable);
                } else if (event instanceof StartBuildEvent) {
                    BuildDescriptor buildDescriptor = ((StartBuildEvent)event).getBuildDescriptor();
                    DefaultBuildDescriptor defaultBuildDescriptor = new DefaultBuildDescriptor(buildDescriptor.getId(), buildDescriptor.getTitle(), buildDescriptor.getWorkingDir(), buildDescriptor.getStartTime());
                    defaultBuildDescriptor.setActivateToolWindowWhenFailed(false);
                    event = new StartBuildEventImpl((BuildDescriptor)defaultBuildDescriptor, event.getMessage());
                }
                buildViewManager.onEvent(buildId, event);
                if (event instanceof StartEvent) {
                    ProgressBuildEventImpl progressBuildEvent = new ProgressBuildEventImpl(event.getId(), event.getParentId(), event.getEventTime(), event.getMessage(), -1L, -1L, "");
                    progressBuildEvent.setHint("- " + GradleBundle.message((String)"gradle.test.runner.build.tw.link.title", (Object[])new Object[0]));
                    buildViewManager.onEvent(buildId, (BuildEvent)progressBuildEvent);
                }
                GradleTestsExecutionConsoleManager.maybeOpenBuildToolWindow(event, project, testsRootNode);
            }
        }, disposable);
        return consoleView;
    }

    private static void maybeOpenBuildToolWindow(@NotNull BuildEvent event, @NotNull Project project, @NotNull SMTestProxy.SMRootTestProxy testsRootNode) {
        EventResult buildResult;
        if (event instanceof FileMessageEvent && ((FileMessageEvent)event).getKind() == MessageEvent.Kind.ERROR) {
            GradleTestsExecutionConsoleManager.openBuildToolWindow(project);
            return;
        }
        if (event instanceof FinishBuildEvent && (buildResult = ((FinishBuildEvent)event).getResult()) instanceof FailureResult) {
            if (!((FailureResult)buildResult).getFailures().isEmpty()) {
                GradleTestsExecutionConsoleManager.openBuildToolWindow(project);
            } else {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!testsRootNode.isInProgress() && testsRootNode.isEmptySuite()) {
                        GradleTestsExecutionConsoleManager.openBuildToolWindow(project);
                    }
                });
            }
        }
    }

    private static void openBuildToolWindow(@NotNull Project project) {
        ApplicationManager.getApplication().invokeLater(() -> {
            ToolWindow toolWindow = BuildContentManager.getInstance((Project)project).getOrCreateToolWindow();
            if (toolWindow.isAvailable() && !toolWindow.isVisible()) {
                toolWindow.show(null);
            }
        }, ModalityState.NON_MODAL, project.getDisposed());
    }

    public void onOutput(@NotNull GradleTestsExecutionConsole executionConsole, @NotNull ProcessHandler processHandler, @NotNull String text, @NotNull Key processOutputType) {
        GradleTestsExecutionConsoleOutputProcessor.onOutput(executionConsole, text, processOutputType);
    }

    public void onStatusChange(@NotNull GradleTestsExecutionConsole executionConsole, @NotNull ExternalSystemTaskNotificationEvent event) {
        ExternalSystemProgressEvent progressEvent;
        OperationDescriptor descriptor;
        if (event instanceof ExternalSystemTaskExecutionEvent && (descriptor = (progressEvent = ((ExternalSystemTaskExecutionEvent)event).getProgressEvent()).getDescriptor()) instanceof TestOperationDescriptor) {
            GradleTestEventsProcessor.onStatusChange(executionConsole, (ExternalSystemProgressEvent<? extends TestOperationDescriptor>)progressEvent);
        }
    }

    public boolean isApplicableFor(@NotNull ExternalSystemTask task) {
        ExternalSystemExecuteTaskTask taskTask;
        if (task instanceof ExternalSystemExecuteTaskTask && StringUtil.equals((CharSequence)(taskTask = (ExternalSystemExecuteTaskTask)task).getExternalSystemId().getId(), (CharSequence)GradleConstants.SYSTEM_ID.getId()) && (GradleTestsExecutionConsoleManager.hasTestOption(taskTask) || GradleTestsExecutionConsoleManager.hasTestTasks(taskTask))) {
            taskTask.putUserData(GradleConstants.RUN_TASK_AS_TEST, (Object)true);
            return true;
        }
        return false;
    }

    private static boolean hasTestOption(@NotNull ExternalSystemExecuteTaskTask task) {
        String options = task.getArguments();
        List tasksAndArguments = task.getTasksToExecute();
        return options != null && StringUtil.contains((CharSequence)options, (CharSequence)"--tests") || tasksAndArguments.contains("--tests");
    }

    private static boolean hasTestTasks(@NotNull ExternalSystemExecuteTaskTask task) {
        String modulePath = GradleTestsExecutionConsoleManager.getModulePath(task);
        List tasksAndArguments = task.getTasksToExecute();
        GradleTasksIndices tasksIndices = GradleTasksIndices.getInstance((Project)task.getIdeProject());
        List tasks = tasksIndices.findTasks(modulePath, tasksAndArguments);
        return ContainerUtil.or((Iterable)tasks, it -> GradleTestsExecutionConsoleManager.isTestTask(it));
    }

    private static boolean isTestTask(@Nullable GradleTaskData task) {
        return task != null && (task.isTest() || "check".equals(task.getName()) && "verification".equals(task.getGroup()));
    }

    @NotNull
    private static String getModulePath(@NotNull ExternalSystemExecuteTaskTask task) {
        String externalProjectPath = task.getExternalProjectPath();
        File file = new File(externalProjectPath);
        if (file.isFile()) {
            return StringUtil.trimEnd((String)externalProjectPath, (String)("/" + file.getName()));
        }
        return externalProjectPath;
    }

    public AnAction[] getRestartActions(@NotNull GradleTestsExecutionConsole consoleView) {
        GradleRerunFailedTestsAction rerunFailedTestsAction = new GradleRerunFailedTestsAction(consoleView);
        rerunFailedTestsAction.setModelProvider(() -> consoleView.getResultsViewer());
        return new AnAction[]{rerunFailedTestsAction};
    }
}

