/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.AbstractGradleTestRunConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.AllInPackageGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.util.GradleExecutionSettingsUtil;
import org.jetbrains.plugins.gradle.util.GradleUtil;
import org.jetbrains.plugins.gradle.util.TasksToRun;

public class AllInDirectoryGradleConfigurationProducer
extends AbstractGradleTestRunConfigurationProducer<PsiElement, PsiElement> {
    @Override
    public boolean isPreferredConfiguration(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        return !other.isProducedBy(AllInPackageGradleConfigurationProducer.class) && super.isPreferredConfiguration(self, other);
    }

    @Override
    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        return !other.isProducedBy(AllInPackageGradleConfigurationProducer.class) && super.shouldReplace(self, other);
    }

    @Override
    @Nullable
    protected PsiElement getElement(@NotNull ConfigurationContext context) {
        PsiElement psiElement = context.getPsiLocation();
        if (psiElement instanceof PsiFileSystemItem && ((PsiFileSystemItem)psiElement).isDirectory()) {
            return psiElement;
        }
        return null;
    }

    @Override
    @NotNull
    protected String getLocationName(@NotNull ConfigurationContext context, @NotNull PsiElement element) {
        Module module = Objects.requireNonNull(context.getModule());
        return String.format("'%s'", module.getName());
    }

    @Override
    @NotNull
    protected String suggestConfigurationName(@NotNull ConfigurationContext context, @NotNull PsiElement element, @NotNull List<? extends PsiElement> chosenElements) {
        Module module = Objects.requireNonNull(context.getModule());
        return ExecutionBundle.message((String)"test.in.scope.presentable.text", (Object[])new Object[]{module.getName()});
    }

    @Override
    protected void chooseSourceElements(@NotNull ConfigurationContext context, @NotNull PsiElement element, @NotNull Consumer<List<PsiElement>> onElementsChosen) {
        onElementsChosen.accept(Collections.emptyList());
    }

    @Override
    @NotNull
    protected List<AbstractGradleTestRunConfigurationProducer.TestTasksToRun> getAllTestsTaskToRun(@NotNull ConfigurationContext context, @NotNull PsiElement element, @NotNull List<? extends PsiElement> chosenElements) {
        Project project = Objects.requireNonNull(context.getProject());
        Module module = Objects.requireNonNull(context.getModule());
        VirtualFile directory = ((PsiFileSystemItem)element).getVirtualFile();
        List<VirtualFile> sources = AllInDirectoryGradleConfigurationProducer.findTestSourcesUnderDirectory(module, directory);
        String testFilter = GradleExecutionSettingsUtil.createTestWildcardFilter();
        ArrayList<AbstractGradleTestRunConfigurationProducer.TestTasksToRun> testsTasksToRun = new ArrayList<AbstractGradleTestRunConfigurationProducer.TestTasksToRun>();
        for (VirtualFile source : sources) {
            testsTasksToRun.addAll(ContainerUtil.map(AllInDirectoryGradleConfigurationProducer.findAllTestsTaskToRun(source, project), it -> new AbstractGradleTestRunConfigurationProducer.TestTasksToRun((TasksToRun)it, testFilter)));
        }
        return testsTasksToRun;
    }

    private static List<VirtualFile> findTestSourcesUnderDirectory(@NotNull Module module, @NotNull VirtualFile directory) {
        DataNode moduleDataNode = GradleUtil.findGradleModuleData((Module)module);
        if (moduleDataNode == null) {
            return Collections.emptyList();
        }
        String rootPath = directory.getPath();
        return ExternalSystemApiUtil.findAll((DataNode)moduleDataNode, (Key)ProjectKeys.TEST).stream().map(DataNode::getData).flatMap(it -> it.getSourceFolders().stream()).filter(it -> FileUtil.isAncestor((String)rootPath, (String)it, (boolean)false)).map(it -> VfsUtil.findFile((Path)Paths.get(it, new String[0]), (boolean)false)).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }
}

