/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.build;

import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ModuleFilesBuildTask;
import com.intellij.task.ModuleResourcesBuildTask;
import com.intellij.task.ProjectModelBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.impl.JpsProjectTaskRunner;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.jvm.ClassDirectoryBinaryNamingScheme;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.execution.build.CachedModuleDataFinder;
import org.jetbrains.plugins.gradle.execution.build.GradleBuildTasksProvider;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.task.VersionSpecificInitScript;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleModuleData;

@ApiStatus.Internal
public class TasksExecutionSettingsBuilder {
    @Language(value="Groovy")
    private static final String FORCE_COMPILE_TASKS_INIT_SCRIPT_TEMPLATE = "projectsEvaluated { \n  rootProject.findProject('%s')?.tasks?.withType(AbstractCompile) {  \n    outputs.upToDateWhen { false } \n  } \n}\n";
    private final MultiMap<String, String> buildTasksMap = MultiMap.createLinkedSet();
    private final MultiMap<String, String> cleanTasksMap = MultiMap.createLinkedSet();
    private final MultiMap<String, String> initScripts = MultiMap.createLinkedSet();
    private final MultiMap<String, VersionSpecificInitScript> versionedInitScripts = MultiMap.createLinkedSet();
    private final List<Module> modulesToBuild;
    private final List<Module> modulesOfResourcesToBuild;
    private final List<Module> modulesOfFiles;
    private final String gradleVmOptions;

    public TasksExecutionSettingsBuilder(@NotNull Project project, ProjectTask ... tasks) {
        this.gradleVmOptions = GradleSettings.getInstance((Project)project).getGradleVmOptions();
        Map taskMap = JpsProjectTaskRunner.groupBy(Arrays.asList(tasks));
        this.modulesToBuild = TasksExecutionSettingsBuilder.addModulesBuildTasks((Collection)taskMap.get(ModuleBuildTask.class), this.buildTasksMap, this.initScripts);
        this.modulesOfResourcesToBuild = TasksExecutionSettingsBuilder.addModulesBuildTasks((Collection)taskMap.get(ModuleResourcesBuildTask.class), this.buildTasksMap, this.initScripts);
        this.modulesOfFiles = TasksExecutionSettingsBuilder.addModulesBuildTasks((Collection)taskMap.get(ModuleFilesBuildTask.class), this.buildTasksMap, this.initScripts);
        TasksExecutionSettingsBuilder.addArtifactsBuildTasks((Collection)taskMap.get(ProjectModelBuildTask.class), this.cleanTasksMap, this.buildTasksMap, this.versionedInitScripts);
    }

    public Set<String> getRootPaths() {
        return this.buildTasksMap.keySet();
    }

    public List<Module> getAffectedModules() {
        return ContainerUtil.concat((List[])new List[]{this.modulesToBuild, this.modulesOfResourcesToBuild, this.modulesOfFiles});
    }

    public void addInitScripts(String rootProjectPath, VersionSpecificInitScript ... initScript) {
        Collection versionSpecificInitScripts = this.versionedInitScripts.getModifiable((Object)rootProjectPath);
        Collections.addAll(versionSpecificInitScripts, initScript);
    }

    public Collection<VersionSpecificInitScript> getVersionedInitScripts(String rootProjectPath) {
        return this.versionedInitScripts.get((Object)rootProjectPath);
    }

    public Collection<String> getInitScripts(String rootProjectPath) {
        return this.initScripts.get((Object)rootProjectPath);
    }

    public boolean containsTasksToExecuteFor(String rootProjectPath) {
        return this.getTasksToExecute(rootProjectPath).iterator().hasNext();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public ExternalSystemTaskExecutionSettings build(String rootProjectPath) {
        ExternalSystemTaskExecutionSettings settings = new ExternalSystemTaskExecutionSettings();
        File projectFile = new File(rootProjectPath);
        String projectName = projectFile.isFile() ? projectFile.getParentFile().getName() : projectFile.getName();
        String executionName = GradleBundle.message((String)"gradle.execution.name.build.project.", (Object[])new Object[]{projectName});
        settings.setExecutionName(executionName);
        settings.setExternalProjectPath(rootProjectPath);
        @NlsSafe List taskNames = ContainerUtil.collect(this.getTasksToExecute(rootProjectPath).iterator());
        settings.setTaskNames(taskNames);
        settings.setVmOptions(this.gradleVmOptions);
        settings.setExternalSystemIdString(GradleConstants.SYSTEM_ID.getId());
        return settings;
    }

    private Iterable<String> getTasksToExecute(String rootProjectPath) {
        Collection buildTasks = this.buildTasksMap.get((Object)rootProjectPath);
        Collection cleanTasks = this.cleanTasksMap.get((Object)rootProjectPath);
        return ContainerUtil.concat((Iterable)cleanTasks, (Iterable)buildTasks);
    }

    private static List<Module> addModulesBuildTasks(@Nullable Collection<? extends ProjectTask> projectTasks, @NotNull MultiMap<String, String> buildTasksMap, @NotNull MultiMap<String, String> initScripts) {
        if (ContainerUtil.isEmpty(projectTasks)) {
            return Collections.emptyList();
        }
        SmartList affectedModules = new SmartList();
        Map rootPathsMap = FactoryMap.create(module -> StringUtil.notNullize((String)GradleRunnerUtil.resolveProjectPath(module)));
        for (ProjectTask projectTask : projectTasks) {
            String buildTaskSuffix;
            GradleModuleData gradleModuleData;
            String externalProjectPath;
            String projectId;
            if (!(projectTask instanceof ModuleBuildTask)) continue;
            ModuleBuildTask moduleBuildTask = (ModuleBuildTask)projectTask;
            TasksExecutionSettingsBuilder.collectAffectedModules((List<Module>)affectedModules, moduleBuildTask);
            Module module2 = moduleBuildTask.getModule();
            String rootProjectPath = (String)rootPathsMap.get(module2);
            if (StringUtil.isEmpty((String)rootProjectPath) || (projectId = ExternalSystemApiUtil.getExternalProjectId((Module)module2)) == null || (externalProjectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module2)) == null || (gradleModuleData = CachedModuleDataFinder.getGradleModuleData((Module)module2)) == null) continue;
            boolean isGradleProjectDirUsedToRunTasks = gradleModuleData.getDirectoryToRunTask().equals(gradleModuleData.getGradleProjectDir());
            if (!isGradleProjectDirUsedToRunTasks) {
                rootProjectPath = gradleModuleData.getDirectoryToRunTask();
            }
            if (gradleModuleData.isBuildSrcModule()) continue;
            String gradlePath = gradleModuleData.getGradlePath();
            List taskDataList = ContainerUtil.mapNotNull((Collection)gradleModuleData.findAll(ProjectKeys.TASK), taskData -> taskData.isInherited() ? null : taskData);
            if (projectTasks.isEmpty()) continue;
            String taskPathPrefix = StringUtil.trimEnd((String)gradleModuleData.getFullGradlePath(), (String)":") + ":";
            List gradleModuleTasks = ContainerUtil.map((Collection)taskDataList, data -> StringUtil.trimStart((String)data.getName(), (String)taskPathPrefix));
            Collection projectInitScripts = initScripts.getModifiable((Object)rootProjectPath);
            Collection buildRootTasks = buildTasksMap.getModifiable((Object)rootProjectPath);
            String moduleType = ExternalSystemApiUtil.getExternalModuleType((Module)module2);
            if (!moduleBuildTask.isIncrementalBuild() && !(moduleBuildTask instanceof ModuleFilesBuildTask)) {
                projectInitScripts.add(String.format(FORCE_COMPILE_TASKS_INIT_SCRIPT_TEMPLATE, gradlePath));
            }
            if (moduleBuildTask.isIncludeRuntimeDependencies()) {
                projectInitScripts.add("System.setProperty('org.gradle.java.compile-classpath-packaging', 'true')\n");
            }
            String assembleTask = "assemble";
            boolean buildOnlyResources = projectTask instanceof ModuleResourcesBuildTask;
            String buildTaskPrefix = buildOnlyResources ? "process" : "";
            String string = buildTaskSuffix = buildOnlyResources ? "resources" : "classes";
            if ("sourceSet".equals(moduleType)) {
                String sourceSetName = GradleProjectResolverUtil.getSourceSetName((Module)module2);
                String gradleTask = TasksExecutionSettingsBuilder.getTaskName(buildTaskPrefix, buildTaskSuffix, sourceSetName);
                if (TasksExecutionSettingsBuilder.addIfContains(taskPathPrefix, gradleTask, gradleModuleTasks, buildRootTasks) || !"main".equals(sourceSetName) && !"test".equals(sourceSetName)) continue;
                buildRootTasks.add(taskPathPrefix + assembleTask);
                continue;
            }
            String gradleTask = TasksExecutionSettingsBuilder.getTaskName(buildTaskPrefix, buildTaskSuffix, null);
            if (TasksExecutionSettingsBuilder.addIfContains(taskPathPrefix, gradleTask, gradleModuleTasks, buildRootTasks)) {
                String gradleTestTask = TasksExecutionSettingsBuilder.getTaskName(buildTaskPrefix, buildTaskSuffix, "test");
                TasksExecutionSettingsBuilder.addIfContains(taskPathPrefix, gradleTestTask, gradleModuleTasks, buildRootTasks);
                continue;
            }
            if (!gradleModuleTasks.contains(assembleTask)) continue;
            buildRootTasks.add(taskPathPrefix + assembleTask);
        }
        return affectedModules;
    }

    @NotNull
    private static String getTaskName(@NotNull String taskPrefix, @NotNull String taskSuffix, @Nullable String sourceSetName) {
        if (Strings.isEmpty((String)sourceSetName)) {
            sourceSetName = "main";
        }
        return new ClassDirectoryBinaryNamingScheme(sourceSetName).getTaskName(taskPrefix, taskSuffix);
    }

    private static void addArtifactsBuildTasks(@Nullable Collection<? extends ProjectTask> tasks, @NotNull MultiMap<String, String> cleanTasksMap, @NotNull MultiMap<String, String> buildTasksMap, @NotNull MultiMap<String, VersionSpecificInitScript> versionedInitScripts) {
        if (ContainerUtil.isEmpty(tasks)) {
            return;
        }
        for (ProjectTask projectTask : tasks) {
            if (!(projectTask instanceof ProjectModelBuildTask)) continue;
            ProjectModelBuildTask projectModelBuildTask = (ProjectModelBuildTask)projectTask;
            for (GradleBuildTasksProvider buildTasksProvider : (GradleBuildTasksProvider[])GradleBuildTasksProvider.EP_NAME.getExtensions()) {
                if (!buildTasksProvider.isApplicable(projectModelBuildTask)) continue;
                buildTasksProvider.addBuildTasks(projectModelBuildTask, (Consumer<ExternalTaskPojo>)((Consumer)task -> cleanTasksMap.putValue((Object)task.getLinkedExternalProjectPath(), (Object)task.getName())), (Consumer<ExternalTaskPojo>)((Consumer)task -> buildTasksMap.putValue((Object)task.getLinkedExternalProjectPath(), (Object)task.getName())), (path, script) -> versionedInitScripts.putValue(path, script));
            }
        }
    }

    private static boolean addIfContains(@NotNull String taskPathPrefix, @NotNull String gradleTask, @NotNull List<String> moduleTasks, @NotNull Collection<String> buildRootTasks) {
        if (moduleTasks.contains(gradleTask)) {
            buildRootTasks.add(taskPathPrefix + gradleTask);
            return true;
        }
        return false;
    }

    private static void collectAffectedModules(@NotNull List<Module> affectedModules, @NotNull ModuleBuildTask moduleBuildTask) {
        Module module = moduleBuildTask.getModule();
        if (moduleBuildTask.isIncludeDependentModules()) {
            OrderEnumerator enumerator = ModuleRootManager.getInstance((Module)module).orderEntries().recursively();
            if (!moduleBuildTask.isIncludeRuntimeDependencies()) {
                enumerator = enumerator.compileOnly();
            }
            enumerator.forEachModule((Processor)new CommonProcessors.CollectProcessor(affectedModules));
        } else {
            affectedModules.add(module);
        }
    }
}

