/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.build;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiClass;
import com.intellij.task.ExecuteRunConfigurationTask;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.build.GradleBaseApplicationEnvironmentProvider;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003JR\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/gradle/execution/build/GradleApplicationEnvironmentProvider;", "Lorg/jetbrains/plugins/gradle/execution/build/GradleBaseApplicationEnvironmentProvider;", "Lcom/intellij/execution/application/ApplicationConfiguration;", "()V", "generateInitScript", "", "applicationConfiguration", "module", "Lcom/intellij/openapi/module/Module;", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "gradleTaskPath", "runAppTaskName", "mainClass", "Lcom/intellij/psi/PsiClass;", "javaExePath", "sourceSetName", "javaModuleName", "isApplicable", "", "task", "Lcom/intellij/task/ExecuteRunConfigurationTask;", "Companion", "intellij.gradle.java"})
public final class GradleApplicationEnvironmentProvider
extends GradleBaseApplicationEnvironmentProvider<ApplicationConfiguration> {
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    public boolean isApplicable(@NotNull ExecuteRunConfigurationTask task) {
        return task.getRunProfile() instanceof ApplicationConfiguration;
    }

    @Override
    @NotNull
    public String generateInitScript(@NotNull ApplicationConfiguration applicationConfiguration, @NotNull Module module, @NotNull JavaParameters params, @NotNull String gradleTaskPath, @NotNull String runAppTaskName, @NotNull PsiClass mainClass, @NotNull String javaExePath, @NotNull String sourceSetName, @Nullable String javaModuleName) {
        CharSequence charSequence;
        String string;
        String string2 = ProgramParametersUtil.getWorkingDir((CommonProgramRunConfigurationParameters)((CommonProgramRunConfigurationParameters)applicationConfiguration), (Project)module.getProject(), (Module)module);
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            string = FileUtil.toSystemIndependentName((String)it);
        } else {
            string = null;
        }
        String workingDir = string;
        String argsString = GradleBaseApplicationEnvironmentProvider.Companion.createEscapedParameters(params.getProgramParametersList().getParameters(), "args") + GradleBaseApplicationEnvironmentProvider.Companion.createEscapedParameters(params.getVMParametersList().getParameters(), "jvmArgs");
        boolean useManifestJar = applicationConfiguration.getShortenCommandLine() == ShortenCommandLine.MANIFEST;
        boolean useArgsFile = applicationConfiguration.getShortenCommandLine() == ShortenCommandLine.ARGS_FILE;
        boolean useClasspathFile = applicationConfiguration.getShortenCommandLine() == ShortenCommandLine.CLASSPATH_FILE;
        String intelliJRtPath = null;
        if (useClasspathFile) {
            try {
                intelliJRtPath = FileUtil.toCanonicalPath((String)PathManager.getJarPathForClass(Class.forName("com.intellij.rt.execution.CommandLineWrapper")));
            }
            catch (Throwable t) {
                LOG.warn("Unable to use classpath file", t);
                useClasspathFile = false;
            }
        }
        String initScript = "\n    def gradlePath = '" + gradleTaskPath + "'\n    def runAppTaskName = '" + runAppTaskName + "'\n    def mainClass = '" + mainClass.getQualifiedName() + "'\n    def javaExePath = mapPath('" + javaExePath + "')\n    def _workingDir = " + (String)((charSequence = (CharSequence)workingDir) == null || charSequence.length() == 0 ? "null\n" : "mapPath('" + workingDir + "')\n") + "\n    def sourceSetName = '" + sourceSetName + "'\n    def javaModuleName = " + (String)(javaModuleName == null ? "null\n" : "'" + javaModuleName + "'\n") + "\n    " + (useManifestJar ? "gradle.addListener(new ManifestTaskActionListener(runAppTaskName))\n" : "") + "\n    " + (useArgsFile ? "gradle.addListener(new ArgFileTaskActionListener(runAppTaskName))\n" : "") + "\n    " + (String)(useClasspathFile && intelliJRtPath != null ? "gradle.addListener(new ClasspathFileTaskActionListener(runAppTaskName, mainClass, mapPath('" + intelliJRtPath + "')))\n " : "") + "\n\n    import org.gradle.util.GradleVersion\n\n    allprojects {\n      afterEvaluate { project ->\n        if(project.path == gradlePath && project?.convention?.findPlugin(JavaPluginConvention)) {\n          def overwrite = project.tasks.findByName(runAppTaskName) != null\n          project.tasks.create(name: runAppTaskName, overwrite: overwrite, type: JavaExec) {\n            if (javaExePath) executable = javaExePath\n            main = mainClass\n            " + argsString + "\n            if (_workingDir) workingDir = _workingDir\n            standardInput = System.in\n            if (javaModuleName) {\n              classpath = tasks[sourceSets[sourceSetName].jarTaskName].outputs.files + project.sourceSets[sourceSetName].runtimeClasspath;\n              if (GradleVersion.current().baseVersion < GradleVersion.version(\"6.4\")) {\n                doFirst {\n                  jvmArgs += [\n                    '--module-path', classpath.asPath,\n                    '--module', javaModuleName + '/' + mainClass\n                  ]\n                  classpath = files()\n                }\n              } else {\n                mainModule = javaModuleName\n              }\n            } else {\n              classpath = project.sourceSets[sourceSetName].runtimeClasspath\n            }\n          }\n        }\n      }\n    }\n    " + (useManifestJar || useArgsFile || useClasspathFile ? "\n    import org.gradle.api.execution.TaskActionListener\n    import org.gradle.api.Task\n    import org.gradle.api.tasks.JavaExec\n    abstract class RunAppTaskActionListener implements TaskActionListener {\n      String myTaskName\n      File myClasspathFile\n      RunAppTaskActionListener(String taskName) {\n        myTaskName = taskName\n      }\n      void beforeActions(Task task) {\n        if(!(task instanceof JavaExec) || task.name != myTaskName) return\n        myClasspathFile = patchTaskClasspath(task)\n      }\n      void afterActions(Task task) {\n        if(myClasspathFile != null) { myClasspathFile.delete() }\n      }\n      abstract File patchTaskClasspath(JavaExec task)\n    }\n    " : "") + (useManifestJar ? "\n\n    import org.gradle.api.tasks.JavaExec\n    import java.util.jar.Attributes\n    import java.util.jar.JarOutputStream\n    import java.util.jar.Manifest\n    import java.util.zip.ZipEntry\n    class ManifestTaskActionListener extends RunAppTaskActionListener {\n      ManifestTaskActionListener(String taskName) {\n         super(taskName)\n      }\n      File patchTaskClasspath(JavaExec task) {\n        Manifest manifest = new Manifest()\n        Attributes attributes = manifest.getMainAttributes()\n        attributes.put(Attributes.Name.MANIFEST_VERSION, '1.0')\n        attributes.putValue('Class-Path', task.classpath.files.collect {it.toURI().toURL().toString()}.join(' '))\n        File file = File.createTempFile('generated-', '-manifest')\n        def oStream = new JarOutputStream(new FileOutputStream(file), manifest)\n        oStream.putNextEntry(new ZipEntry('META-INF/'))\n        oStream.close()\n        task.classpath = task.project.files(file.getAbsolutePath())\n        return file\n      }\n    }\n    " : "") + (useArgsFile ? "\n\n    import org.gradle.api.tasks.JavaExec\n    import org.gradle.process.CommandLineArgumentProvider\n    class ArgFileTaskActionListener extends RunAppTaskActionListener {\n      ArgFileTaskActionListener(String taskName) {\n         super(taskName)\n      }\n      File patchTaskClasspath(JavaExec task) {\n        File file = File.createTempFile('generated-', '-argFile')\n        def writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream(file), 'UTF-8'))\n        def lineSep = System.getProperty('line.separator')\n        writer.print('-classpath' + lineSep)\n        writer.print(quoteArg(task.classpath.asPath))\n        writer.print(lineSep)\n        writer.close()\n        task.jvmArgs('@' + file.absolutePath)\n        task.classpath = task.project.files([])\n        return file\n      }\n      private static String quoteArg(String arg) {\n        String specials = ' #\\'\\\"\\n\\r\\t\\f'\n        if (specials.find { arg.indexOf(it) != -1 } == null) return arg\n        StringBuilder sb = new StringBuilder(arg.length() * 2)\n        for (int i = 0; i < arg.length(); i++) {\n          char c = arg.charAt(i)\n          if (c == ' ' as char || c == '#' as char || c == '\\'' as char) sb.append('\"').append(c).append('\"')\n          else if (c == '\"' as char) sb.append(\"\\\"\\\\\\\"\\\"\")\n          else if (c == '\\n' as char) sb.append(\"\\\"\\\\n\\\"\")\n          else if (c == '\\r' as char) sb.append(\"\\\"\\\\r\\\"\")\n          else if (c == '\\t' as char) sb.append(\"\\\"\\\\t\\\"\")\n          else if (c == '\\f' as char) sb.append(\"\\\"\\\\f\\\"\")\n          else sb.append(c)\n        }\n        return sb.toString()\n      }}\n    " : "") + (useClasspathFile ? "\n\n    import org.gradle.api.tasks.JavaExec\n    import org.gradle.process.CommandLineArgumentProvider\n    class ClasspathFileTaskActionListener extends RunAppTaskActionListener {\n      String myMainClass\n      String myIntelliJRtPath\n      ClasspathFileTaskActionListener(String taskName, String mainClass, String intelliJRtPath) {\n         super(taskName)\n         myMainClass = mainClass\n         myIntelliJRtPath = intelliJRtPath\n      }\n      File patchTaskClasspath(JavaExec task) {\n        File file = File.createTempFile('generated-', '-classpathFile')\n        def writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream(file), 'UTF-8'))\n        task.classpath.files.each { writer.println(it.path) }\n        writer.close()\n        List args = [file.absolutePath, myMainClass] as List\n        args.addAll(task.args)\n        task.args = []\n        task.argumentProviders.add({ return args } as CommandLineArgumentProvider)\n        task.main = 'com.intellij.rt.execution.CommandLineWrapper'\n        task.classpath = task.project.files([myIntelliJRtPath])\n        return file\n      }\n    }\n    " : "");
        return initScript;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GradleApplicationEnvironmentProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/gradle/execution/build/GradleApplicationEnvironmentProvider$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.gradle.java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

