/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInspection.GradleBaseInspection;
import org.jetbrains.plugins.gradle.codeInspection.GradleInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/gradle/codeInspection/BintrayPublishingPluginInspection;", "Lorg/jetbrains/plugins/gradle/codeInspection/GradleBaseInspection;", "()V", "buildVisitor", "Lorg/jetbrains/plugins/groovy/codeInspection/BaseInspectionVisitor;", "MyVisitor", "intellij.gradle.java"})
public final class BintrayPublishingPluginInspection
extends GradleBaseInspection {
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new MyVisitor();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/gradle/codeInspection/BintrayPublishingPluginInspection$MyVisitor;", "Lorg/jetbrains/plugins/groovy/codeInspection/BaseInspectionVisitor;", "()V", "isApplyPlugin", "", "literal", "Lorg/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/literals/GrLiteralImpl;", "isPluginDSL", "visitLiteralExpression", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/literals/GrLiteral;", "intellij.gradle.java"})
    public static final class MyVisitor
    extends BaseInspectionVisitor {
        public void visitLiteralExpression(@NotNull GrLiteral literal) {
            PsiFile file = literal.getContainingFile();
            if (!FileUtilRt.extensionEquals((String)file.getName(), (String)"gradle")) {
                return;
            }
            super.visitLiteralExpression(literal);
            if (!(literal instanceof GrLiteralImpl) || !((GrLiteralImpl)literal).isStringLiteral()) {
                return;
            }
            if (Intrinsics.areEqual((Object)"com.jfrog.bintray", (Object)((GrLiteralImpl)literal).getValue()) && (this.isPluginDSL((GrLiteralImpl)literal) || this.isApplyPlugin((GrLiteralImpl)literal))) {
                this.registerError((PsiElement)literal, GradleInspectionBundle.message("bintray.publishing.plugin", new Object[0]), new LocalQuickFix[0], ProblemHighlightType.WARNING);
            }
        }

        private final boolean isApplyPlugin(GrLiteralImpl literal) {
            boolean bl;
            GrCall grCall;
            PsiElement psiElement;
            PsiElement psiElement2 = literal.getParent();
            if (!((psiElement2 != null && (psiElement2 = psiElement2.getParent()) != null ? psiElement2.getParent() : (psiElement = null)) instanceof GrCall)) {
                psiElement = null;
            }
            if ((grCall = (GrCall)psiElement) != null && (grCall = grCall.resolveMethod()) != null) {
                GrCall grCall2;
                GrCall it = grCall2 = grCall;
                boolean bl2 = false;
                PsiClass psiClass = it.getContainingClass();
                bl = Intrinsics.areEqual((Object)"org.gradle.api.plugins.PluginAware", (Object)(psiClass != null ? psiClass.getQualifiedName() : null)) && Intrinsics.areEqual((Object)"apply", (Object)it.getName());
            } else {
                bl = false;
            }
            return bl;
        }

        private final boolean isPluginDSL(GrLiteralImpl literal) {
            boolean bl;
            GrCall grCall;
            PsiElement psiElement = literal.getParent();
            Object object = psiElement != null ? psiElement.getParent() : null;
            if (!(object instanceof GrCall)) {
                object = null;
            }
            if ((grCall = (GrCall)object) != null && (grCall = grCall.resolveMethod()) != null) {
                GrCall grCall2;
                GrCall it = grCall2 = grCall;
                boolean bl2 = false;
                PsiClass psiClass = it.getContainingClass();
                bl = Intrinsics.areEqual((Object)"org.gradle.plugin.use.PluginDependenciesSpec", (Object)(psiClass != null ? psiClass.getQualifiedName() : null)) && Intrinsics.areEqual((Object)"id", (Object)it.getName());
            } else {
                bl = false;
            }
            return bl;
        }
    }
}

