/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiFile;
import icons.GradleIcons;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInsight.GradlePluginDescriptionsExtension;
import org.jetbrains.plugins.gradle.codeInsight.actions.AddGradleDslPluginActionHandler;
import org.jetbrains.plugins.gradle.config.GradleFileType;
import org.jetbrains.plugins.gradle.util.GradleBundle;

public class AddGradleDslPluginAction
extends CodeInsightAction {
    public static final String ID = "AddGradleDslPluginAction";
    static final ThreadLocal<String> TEST_THREAD_LOCAL = new ThreadLocal();
    private final List<Pair<String, String>> myPlugins;

    public AddGradleDslPluginAction() {
        this.getTemplatePresentation().setDescription(GradleBundle.messagePointer((String)"gradle.codeInsight.action.apply_plugin.description", (Object[])new Object[0]));
        this.getTemplatePresentation().setText(GradleBundle.messagePointer((String)"gradle.codeInsight.action.apply_plugin.text", (Object[])new Object[0]));
        this.getTemplatePresentation().setIcon(GradleIcons.Gradle);
        this.myPlugins = new ArrayList<Pair<String, String>>();
        for (GradlePluginDescriptionsExtension extension : (GradlePluginDescriptionsExtension[])GradlePluginDescriptionsExtension.EP_NAME.getExtensions()) {
            for (Map.Entry<String, String> pluginDescription : extension.getPluginDescriptions().entrySet()) {
                this.myPlugins.add((Pair<String, String>)Pair.pair((Object)pluginDescription.getKey(), (Object)pluginDescription.getValue()));
            }
        }
        this.myPlugins.sort(Pair.comparingByFirst());
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        return new AddGradleDslPluginActionHandler(this.myPlugins);
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (file instanceof PsiCompiledElement) {
            return false;
        }
        if (!GradleFileType.isGradleFile(file)) {
            return false;
        }
        return !"settings.gradle".equals(file.getName());
    }
}

