/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemResolveProjectTask;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataImportListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Function;
import com.intellij.util.messages.MessageBusConnection;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.plugins.gradle.util.GradleImportingUtil;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0007\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0002\u001a*\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0002\u001a*\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0002\u001a\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0007\u001a\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\r\u001a\u00020\u00022\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u001a\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0007\u001a\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\bH\u0002\u001a\u001e\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00192\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u001a"}, d2={"getExecutionTaskFinishPromise", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "getExternalSystemTaskFinishPromise", "isRelevantTask", "Lkotlin/Function1;", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "", "getExternalSystemTaskFinishPromiseImpl", "disposable", "getProjectDataLoadPromise", "project", "expectedProjectPath", "", "expectedProjects", "", "Ljava/nio/file/Path;", "getResolveTaskFinishPromise", "isResolveTask", "id", "whenResolveTaskStarted", "", "action", "Lkotlin/Function0;", "intellij.gradle.common"})
@JvmName(name="GradleImportingUtil")
public final class GradleImportingUtil {
    private static final boolean isResolveTask(ExternalSystemTaskId id) {
        ExternalSystemTask task2;
        if (id.getType() == ExternalSystemTaskType.RESOLVE_PROJECT && (task2 = ((ExternalSystemProcessingManager)ApplicationManager.getApplication().getService(ExternalSystemProcessingManager.class)).findTask(id)) instanceof ExternalSystemResolveProjectTask) {
            return !((ExternalSystemResolveProjectTask)task2).isPreviewMode();
        }
        return false;
    }

    @IntellijInternalApi
    public static final void whenResolveTaskStarted(@NotNull Function0<Unit> action2, @NotNull Disposable parentDisposable) {
        ExternalSystemProgressNotificationManager.getInstance().addNotificationListener((ExternalSystemTaskNotificationListener)new ExternalSystemTaskNotificationListenerAdapter(action2){
            final /* synthetic */ Function0 $action;

            public void onStart(@NotNull ExternalSystemTaskId id, @Nullable String workingDir) {
                if (GradleImportingUtil.access$isResolveTask(id)) {
                    this.$action.invoke();
                }
            }
            {
                this.$action = $captured_local_variable$0;
            }
        }, parentDisposable);
    }

    @IntellijInternalApi
    @NotNull
    public static final Promise<Project> getProjectDataLoadPromise(@NotNull Disposable parentDisposable) {
        return GradleImportingUtil.getResolveTaskFinishPromise(parentDisposable).thenAsync((Function)getProjectDataLoadPromise.1.INSTANCE);
    }

    @IntellijInternalApi
    @NotNull
    public static final Promise<Project> getExecutionTaskFinishPromise(@NotNull Disposable parentDisposable) {
        return GradleImportingUtil.getExternalSystemTaskFinishPromise(parentDisposable, (Function1<? super ExternalSystemTaskId, Boolean>)((Function1)getExecutionTaskFinishPromise.1.INSTANCE));
    }

    @TestOnly
    @NotNull
    public static final Promise<Project> getProjectDataLoadPromise() {
        return GradleImportingUtil.getExternalSystemTaskFinishPromise((Function1<? super ExternalSystemTaskId, Boolean>)((Function1)getProjectDataLoadPromise.2.INSTANCE)).thenAsync((Function)getProjectDataLoadPromise.3.INSTANCE);
    }

    @TestOnly
    @NotNull
    public static final Promise<Project> getProjectDataLoadPromise(@NotNull List<? extends Path> expectedProjects) {
        boolean bl;
        Collection collection = expectedProjects;
        boolean bl2 = bl = !collection.isEmpty();
        if (!bl) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return GradleImportingUtil.getExternalSystemTaskFinishPromise((Function1<? super ExternalSystemTaskId, Boolean>)((Function1)getProjectDataLoadPromise.4.INSTANCE)).thenAsync(new Function(expectedProjects){
            final /* synthetic */ List $expectedProjects;

            /*
             * WARNING - void declaration
             */
            public final Promise<Project> fun(Project project) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.$expectedProjects;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Path path = (Path)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void var11_11 = it;
                    String linkedProjectPath = FileUtil.toCanonicalPath((String)((Object)var11_11.toAbsolutePath()).toString());
                    Promise promise = GradleImportingUtil.access$getProjectDataLoadPromise(project, linkedProjectPath);
                    collection.add(promise);
                }
                return Promises.all((Collection)((List)destination$iv$iv), (Object)project, (boolean)false);
            }
            {
                this.$expectedProjects = list2;
            }
        });
    }

    @TestOnly
    @NotNull
    public static final Promise<Project> getExecutionTaskFinishPromise() {
        return GradleImportingUtil.getExternalSystemTaskFinishPromise((Function1<? super ExternalSystemTaskId, Boolean>)((Function1)getExecutionTaskFinishPromise.2.INSTANCE));
    }

    private static final Promise<Project> getResolveTaskFinishPromise(Disposable parentDisposable) {
        return GradleImportingUtil.getExternalSystemTaskFinishPromise(parentDisposable, (Function1<? super ExternalSystemTaskId, Boolean>)((Function1)getResolveTaskFinishPromise.1.INSTANCE));
    }

    private static final Promise<Project> getExternalSystemTaskFinishPromise(Disposable parentDisposable, Function1<? super ExternalSystemTaskId, Boolean> isRelevantTask) {
        Disposable disposable = Disposer.newDisposable((Disposable)parentDisposable, (String)"");
        return GradleImportingUtil.getExternalSystemTaskFinishPromiseImpl(disposable, isRelevantTask);
    }

    private static final Promise<Project> getExternalSystemTaskFinishPromise(Function1<? super ExternalSystemTaskId, Boolean> isRelevantTask) {
        Disposable disposable = Disposer.newDisposable((String)"");
        return GradleImportingUtil.getExternalSystemTaskFinishPromiseImpl(disposable, isRelevantTask);
    }

    private static final Promise<Project> getExternalSystemTaskFinishPromiseImpl(Disposable disposable, Function1<? super ExternalSystemTaskId, Boolean> isRelevantTask) {
        AsyncPromise promise = new AsyncPromise();
        ExternalSystemProgressNotificationManager.getInstance().addNotificationListener((ExternalSystemTaskNotificationListener)new ExternalSystemTaskNotificationListenerAdapter(isRelevantTask, disposable, promise){
            final /* synthetic */ Function1 $isRelevantTask;
            final /* synthetic */ Disposable $disposable;
            final /* synthetic */ AsyncPromise $promise;

            public void onSuccess(@NotNull ExternalSystemTaskId id) {
                if (((Boolean)this.$isRelevantTask.invoke((Object)id)).booleanValue()) {
                    Disposer.dispose((Disposable)this.$disposable);
                    Project project = id.findProject();
                    Intrinsics.checkNotNull((Object)project);
                    this.$promise.setResult((Object)project);
                }
            }

            public void onFailure(@NotNull ExternalSystemTaskId id, @NotNull Exception e) {
                if (((Boolean)this.$isRelevantTask.invoke((Object)id)).booleanValue()) {
                    Disposer.dispose((Disposable)this.$disposable);
                    this.$promise.setError((Throwable)e);
                }
            }

            public void onCancel(@NotNull ExternalSystemTaskId id) {
                if (((Boolean)this.$isRelevantTask.invoke((Object)id)).booleanValue()) {
                    Disposer.dispose((Disposable)this.$disposable);
                    this.$promise.cancel();
                }
            }
            {
                this.$isRelevantTask = $captured_local_variable$0;
                this.$disposable = $captured_local_variable$1;
                this.$promise = $captured_local_variable$2;
            }
        }, disposable);
        return (Promise)promise;
    }

    private static final Promise<Project> getProjectDataLoadPromise(Project project, String expectedProjectPath) {
        AsyncPromise promise = new AsyncPromise();
        Disposable parentDisposable = Disposer.newDisposable();
        MessageBusConnection connection = project.getMessageBus().connect(parentDisposable);
        connection.subscribe(ProjectDataImportListener.TOPIC, (Object)new ProjectDataImportListener(expectedProjectPath, parentDisposable, promise, project){
            final /* synthetic */ String $expectedProjectPath;
            final /* synthetic */ Disposable $parentDisposable;
            final /* synthetic */ AsyncPromise $promise;
            final /* synthetic */ Project $project;

            public void onImportFinished(@Nullable String projectPath) {
                if (this.$expectedProjectPath == null || Intrinsics.areEqual((Object)this.$expectedProjectPath, (Object)projectPath)) {
                    Disposer.dispose((Disposable)this.$parentDisposable);
                    ModalityState modalityState$iv = null;
                    boolean $i$f$invokeLater = false;
                    ApplicationManager.getApplication().invokeLater(new Runnable(this){
                        final /* synthetic */ getProjectDataLoadPromise.6 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final void run() {
                            boolean bl = false;
                            this.this$0.$promise.setResult((Object)this.this$0.$project);
                        }
                    }, ModalityState.defaultModalityState());
                }
            }

            public void onImportFailed(@Nullable String projectPath) {
                if (this.$expectedProjectPath == null || Intrinsics.areEqual((Object)this.$expectedProjectPath, (Object)projectPath)) {
                    Disposer.dispose((Disposable)this.$parentDisposable);
                    this.$promise.setError("Import failed for " + projectPath);
                }
            }
            {
                this.$expectedProjectPath = $captured_local_variable$0;
                this.$parentDisposable = $captured_local_variable$1;
                this.$promise = $captured_local_variable$2;
                this.$project = $captured_local_variable$3;
            }
        });
        return (Promise)promise;
    }

    static /* synthetic */ Promise getProjectDataLoadPromise$default(Project project, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return GradleImportingUtil.getProjectDataLoadPromise(project, string2);
    }

    public static final /* synthetic */ boolean access$isResolveTask(ExternalSystemTaskId id) {
        return GradleImportingUtil.isResolveTask(id);
    }

    public static final /* synthetic */ Promise access$getProjectDataLoadPromise(Project project, String expectedProjectPath) {
        return GradleImportingUtil.getProjectDataLoadPromise(project, expectedProjectPath);
    }
}

