/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.ui;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.ui.ClickListener;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.ui.RichTextControlBuilder;

public class RichTextActionProcessor
implements RichTextControlBuilder.RichTextProcessor {
    @Override
    public JComponent process(@NotNull String s) {
        ActionManager actionManager = ActionManager.getInstance();
        final AnAction action2 = actionManager.getAction(s);
        if (action2 == null) {
            return null;
        }
        Presentation presentation = action2.getTemplatePresentation();
        if (presentation.getIcon() != null) {
            return new ActionButton(action2, presentation.clone(), "GRADLE_SYNC_CHANGES_TOOLBAR", (Dimension)JBUI.emptySize()){

                protected void paintButtonLook(Graphics g) {
                    ActionButtonLook look = this.getButtonLook();
                    look.paintBackground(g, (JComponent)((Object)this));
                    look.paintIcon(g, (ActionButtonComponent)this, this.getIcon());
                }
            };
        }
        String text = action2.getTemplatePresentation().getText();
        JLabel result = new JLabel(text){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                int y = g.getClipBounds().height - this.getFontMetrics(this.getFont()).getDescent() + 2;
                int width = this.getFontMetrics(this.getFont()).stringWidth(this.getText());
                g.drawLine(0, y, width, y);
            }
        };
        Color color = StartupUiUtil.isUnderDarcula() ? Color.ORANGE : Color.BLUE;
        result.setForeground(color);
        result.setCursor(Cursor.getPredefinedCursor(12));
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                DataContext context = (DataContext)DataManager.getInstance().getDataContextFromFocus().getResult();
                if (context == null) {
                    return false;
                }
                Presentation presentation = new PresentationFactory().getPresentation(action2);
                action2.actionPerformed(new AnActionEvent((InputEvent)e, context, "GRADLE_SYNC_CHANGES_TOOLBAR", presentation, ActionManager.getInstance(), e.getModifiers()));
                return true;
            }
        }.installOn((Component)result);
        return result;
    }

    @Override
    @NotNull
    public String getKey() {
        return "action";
    }
}

