/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.task;

import com.google.gson.GsonBuilder;
import com.intellij.build.SyncViewManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunnableState;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.task.ExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import gnu.trove.THash;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.gradle.api.Task;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.GradleFileModificationTracker;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManagerExtension;
import org.jetbrains.plugins.gradle.service.task.GradleTaskResultListener;
import org.jetbrains.plugins.gradle.service.task.VersionSpecificInitScript;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleBuildParticipant;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public class GradleTaskManager
implements ExternalSystemTaskManager<GradleExecutionSettings> {
    public static final Key<String> INIT_SCRIPT_KEY = Key.create((String)"INIT_SCRIPT_KEY");
    public static final Key<String> INIT_SCRIPT_PREFIX_KEY = Key.create((String)"INIT_SCRIPT_PREFIX_KEY");
    public static final Key<Collection<VersionSpecificInitScript>> VERSION_SPECIFIC_SCRIPTS_KEY = Key.create((String)"VERSION_SPECIFIC_SCRIPTS_KEY");
    private static final Logger LOG = Logger.getInstance(GradleTaskManager.class);
    private final GradleExecutionHelper myHelper = new GradleExecutionHelper();
    private final Map<ExternalSystemTaskId, CancellationTokenSource> myCancellationMap = new ConcurrentHashMap<ExternalSystemTaskId, CancellationTokenSource>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTasks(@NotNull ExternalSystemTaskId id, @NotNull List<String> taskNames, @NotNull String projectPath, @Nullable GradleExecutionSettings settings2, @Nullable String jvmParametersSetup, @NotNull ExternalSystemTaskNotificationListener listener2) throws ExternalSystemException {
        List<String> tasks2 = taskNames.stream().flatMap(s -> ParametersListUtil.parse((String)s, (boolean)false, (boolean)true).stream()).collect(Collectors.toList());
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
            for (GradleTaskManagerExtension gradleTaskManagerExtension : (GradleTaskManagerExtension[])GradleTaskManagerExtension.EP_NAME.getExtensions()) {
                if (!gradleTaskManagerExtension.executeTasks(id, tasks2, projectPath, settings2, jvmParametersSetup, listener2)) continue;
                return;
            }
        }
        GradleExecutionSettings effectiveSettings = settings2 == null ? new GradleExecutionSettings(null, null, DistributionType.BUNDLED, false) : settings2;
        CancellationTokenSource cancellationTokenSource = GradleConnector.newCancellationTokenSource();
        this.myCancellationMap.put(id, cancellationTokenSource);
        try {
            if (effectiveSettings.getDistributionType() == DistributionType.WRAPPED) {
                String rootProjectPath = GradleUtil.determineRootProject(projectPath);
                CancellationToken cancellationToken = cancellationTokenSource.token();
                this.myHelper.ensureInstalledWrapper(id, rootProjectPath, effectiveSettings, listener2, cancellationToken);
            }
            this.myHelper.execute(projectPath, effectiveSettings, id, listener2, cancellationTokenSource, connection -> {
                this.executeTasks(id, tasks2, projectPath, effectiveSettings, jvmParametersSetup, listener2, (ProjectConnection)connection, cancellationTokenSource);
                return null;
            });
        }
        finally {
            this.myCancellationMap.remove(id);
        }
    }

    private void executeTasks(@NotNull ExternalSystemTaskId id, @NotNull List<String> tasks2, @NotNull String projectPath, @NotNull GradleExecutionSettings settings2, @Nullable String jvmParametersSetup, @NotNull ExternalSystemTaskNotificationListener listener2, @NotNull ProjectConnection connection, @NotNull CancellationTokenSource cancellationTokenSource) {
        BuildEnvironment buildEnvironment = null;
        try {
            BuildLauncher launcher;
            buildEnvironment = GradleExecutionHelper.getBuildEnvironment(connection, id, listener2, cancellationTokenSource, settings2);
            String gradleVersion2 = Optional.ofNullable(buildEnvironment).map(it -> it.getGradle()).map(it -> it.getGradleVersion()).orElse(null);
            GradleTaskManager.setupGradleScriptDebugging(settings2);
            GradleTaskManager.setupDebuggerDispatchPort(settings2);
            GradleTaskManager.appendInitScriptArgument(tasks2, jvmParametersSetup, settings2, gradleVersion2);
            for (GradleBuildParticipant buildParticipant : settings2.getExecutionWorkspace().getBuildParticipants()) {
                settings2.withArguments(new String[]{"--include-build", buildParticipant.getProjectPath()});
            }
            if (Registry.is((String)"gradle.report.recently.saved.paths")) {
                ((GradleFileModificationTracker)ApplicationManager.getApplication().getService(GradleFileModificationTracker.class)).notifyConnectionAboutChangedPaths(connection);
            }
            if (GradleTaskManager.testLauncherIsApplicable(tasks2, settings2)) {
                launcher = this.myHelper.getTestLauncher(id, connection, tasks2, settings2, listener2);
                launcher.withCancellationToken(cancellationTokenSource.token());
                launcher.run();
            } else {
                launcher = this.myHelper.getBuildLauncher(id, connection, settings2, listener2);
                launcher.forTasks(ArrayUtil.toStringArray(tasks2));
                launcher.withCancellationToken(cancellationTokenSource.token());
                launcher.run();
            }
            GradleTaskResultListener.EP_NAME.forEachExtensionSafe(ext -> ext.onSuccess(id, projectPath));
        }
        catch (RuntimeException e) {
            LOG.debug("Gradle build launcher error", (Throwable)e);
            GradleProjectResolverExtension projectResolverChain = GradleProjectResolver.createProjectResolverChain();
            throw projectResolverChain.getUserFriendlyError(buildEnvironment, e, projectPath, null);
        }
    }

    private static boolean testLauncherIsApplicable(@NotNull List<String> taskNames, @NotNull GradleExecutionSettings effectiveSettings) {
        boolean allowedByRegistry = Registry.is((String)"gradle.testLauncherAPI.enabled", (boolean)false);
        boolean allowedByGradleVersion = GradleTaskManager.isSupportedByGradleVersion(effectiveSettings);
        boolean allowedByTasksList = taskNames.size() < 2;
        return Boolean.TRUE == effectiveSettings.getUserData(GradleConstants.RUN_TASK_AS_TEST) && allowedByGradleVersion && allowedByTasksList && allowedByRegistry;
    }

    private static boolean isSupportedByGradleVersion(GradleExecutionSettings effectiveSettings) {
        return Optional.ofNullable(effectiveSettings.getGradleHome()).map(GradleInstallationManager::getGradleVersion).map(GradleInstallationManager::getGradleVersionSafe).map(v -> GradleVersion.version((String)"6.1").compareTo(v) <= 0).orElse(false);
    }

    protected static boolean isGradleScriptDebug(@Nullable GradleExecutionSettings settings2) {
        return Optional.ofNullable(settings2).map(s -> (Boolean)s.getUserData(GradleRunConfiguration.DEBUG_FLAG_KEY)).orElse(false);
    }

    protected static boolean isDebugAllTasks(@Nullable GradleExecutionSettings settings2) {
        return Optional.ofNullable(settings2).map(s -> (Boolean)s.getUserData(GradleRunConfiguration.DEBUG_ALL_KEY)).orElse(false);
    }

    public boolean cancelTask(@NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener2) throws ExternalSystemException {
        CancellationTokenSource cancellationTokenSource = this.myCancellationMap.get(id);
        if (cancellationTokenSource != null) {
            cancellationTokenSource.cancel();
            return true;
        }
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
            for (GradleTaskManagerExtension gradleTaskManagerExtension : (GradleTaskManagerExtension[])GradleTaskManagerExtension.EP_NAME.getExtensions()) {
                if (!gradleTaskManagerExtension.cancelTask(id, listener2)) continue;
                return true;
            }
        }
        return false;
    }

    public static void appendInitScriptArgument(@NotNull List<String> taskNames, @Nullable String jvmParametersSetup, @NotNull GradleExecutionSettings effectiveSettings) {
        GradleTaskManager.appendInitScriptArgument(taskNames, jvmParametersSetup, effectiveSettings, null);
    }

    public static void appendInitScriptArgument(@NotNull List<String> taskNames, @Nullable String jvmParametersSetup, @NotNull GradleExecutionSettings effectiveSettings, @Nullable String gradleVersion2) {
        String initScript;
        ArrayList initScripts = new ArrayList();
        List extensions = GradleProjectResolverUtil.createProjectResolvers(null).collect(Collectors.toList());
        for (GradleProjectResolverExtension resolverExtension : extensions) {
            String debugDispatchAddr;
            String resolverClassName = resolverExtension.getClass().getName();
            Consumer initScriptConsumer = script -> {
                if (StringUtil.isNotEmpty((String)script)) {
                    ContainerUtil.addAllNotNull((Collection)initScripts, (Object[])new String[]{"//-- Generated by " + resolverClassName, script, "//"});
                }
            };
            HashMap<String, String> enhancementParameters = new HashMap<String, String>();
            enhancementParameters.put("JVM_PARAMETERS_SETUP", jvmParametersSetup);
            String isTestExecution = String.valueOf(Boolean.TRUE == effectiveSettings.getUserData(GradleConstants.RUN_TASK_AS_TEST));
            enhancementParameters.put("TEST_EXECUTION_EXPECTED", isTestExecution);
            Integer debugDispatchPort = (Integer)effectiveSettings.getUserData(ExternalSystemRunnableState.DEBUGGER_DISPATCH_PORT_KEY);
            if (debugDispatchPort != null) {
                enhancementParameters.put("DEBUG_DISPATCH_PORT", String.valueOf(debugDispatchPort));
                String debugOptions = (String)effectiveSettings.getUserData(GradleRunConfiguration.DEBUGGER_PARAMETERS_KEY);
                enhancementParameters.put("DEBUG_OPTIONS", debugOptions);
            }
            if ((debugDispatchAddr = (String)effectiveSettings.getUserData(ExternalSystemRunnableState.DEBUGGER_DISPATCH_ADDR_KEY)) != null) {
                enhancementParameters.put("DEBUG_DISPATCH_ADDR", debugDispatchAddr);
            }
            enhancementParameters.put("TEST_LAUNCHER_WILL_BE_USED", String.valueOf(GradleTaskManager.testLauncherIsApplicable(taskNames, effectiveSettings)));
            enhancementParameters.put("GRADLE_VERSION", gradleVersion2);
            resolverExtension.enhanceTaskProcessing(taskNames, (Consumer<String>)initScriptConsumer, enhancementParameters);
        }
        if (!initScripts.isEmpty()) {
            GradleTaskManager.writeAndAppendScript(effectiveSettings, StringUtil.join(initScripts, (String)System.lineSeparator()), "ijresolvers");
        }
        if (StringUtil.isNotEmpty((String)(initScript = (String)effectiveSettings.getUserData(INIT_SCRIPT_KEY)))) {
            GradleTaskManager.writeAndAppendScript(effectiveSettings, initScript, StringUtil.notNullize((String)((String)effectiveSettings.getUserData(INIT_SCRIPT_PREFIX_KEY)), (String)"ijmiscinit"));
        }
        Collection scripts = (Collection)effectiveSettings.getUserData(VERSION_SPECIFIC_SCRIPTS_KEY);
        if (gradleVersion2 != null && scripts != null && !scripts.isEmpty()) {
            try {
                GradleVersion version = GradleVersion.version((String)gradleVersion2);
                scripts.stream().filter(script -> script.isApplicableTo(version)).filter(script -> StringUtil.isNotEmpty((String)script.getScript())).forEach(script -> GradleTaskManager.writeAndAppendScript(effectiveSettings, script.getScript(), StringUtil.notNullize((String)script.getFilePrefix(), (String)"ijverspecinit")));
            }
            catch (IllegalArgumentException e) {
                LOG.error("Failed to parse gradle version value [" + gradleVersion2 + "]", (Throwable)e);
            }
        }
        if (effectiveSettings.getArguments().contains("--init-script")) {
            GradleExecutionHelper.attachTargetPathMapperInitScript(effectiveSettings);
        }
    }

    private static void writeAndAppendScript(@NotNull GradleExecutionSettings effectiveSettings, @NotNull String initScript, @NotNull String initScriptPrefix) {
        try {
            String initScriptPrefixName = FileUtil.sanitizeFileName((String)initScriptPrefix);
            File tempFile = GradleExecutionHelper.writeToFileGradleInitScript(initScript, initScriptPrefixName);
            effectiveSettings.withArguments(new String[]{"--init-script", tempFile.getAbsolutePath()});
        }
        catch (IOException e) {
            throw GradleTaskManager.wrapWithESException(e);
        }
    }

    @NotNull
    private static ExternalSystemException wrapWithESException(IOException e) {
        ExternalSystemException externalSystemException = new ExternalSystemException((Throwable)e);
        externalSystemException.initCause((Throwable)e);
        return externalSystemException;
    }

    public static void setupGradleScriptDebugging(@NotNull GradleExecutionSettings effectiveSettings) {
        Integer gradleScriptDebugPort = (Integer)effectiveSettings.getUserData(ExternalSystemRunnableState.BUILD_PROCESS_DEBUGGER_PORT_KEY);
        if (GradleTaskManager.isGradleScriptDebug(effectiveSettings) && gradleScriptDebugPort != null && gradleScriptDebugPort > 0) {
            boolean isJdk9orLater;
            String dispatchAddr = (String)effectiveSettings.getUserData(ExternalSystemRunnableState.DEBUGGER_DISPATCH_ADDR_KEY);
            String debugAddress = dispatchAddr != null ? dispatchAddr + ":" + gradleScriptDebugPort : ((isJdk9orLater = ExternalSystemJdkUtil.isJdk9orLater((String)effectiveSettings.getJavaHome())) ? "127.0.0.1:" : "") + gradleScriptDebugPort;
            String jvmOpt = "-agentlib:jdwp=transport=dt_socket,server=n,suspend=y,address=" + debugAddress;
            effectiveSettings.withVmOption(jvmOpt);
        }
        if (GradleTaskManager.isDebugAllTasks(effectiveSettings)) {
            effectiveSettings.withVmOption("-Didea.gradle.debug.all=true");
        }
    }

    public static void setupDebuggerDispatchPort(@NotNull GradleExecutionSettings effectiveSettings) {
        String dispatchAddr;
        Integer dispatchPort = (Integer)effectiveSettings.getUserData(ExternalSystemRunnableState.DEBUGGER_DISPATCH_PORT_KEY);
        if (dispatchPort != null) {
            effectiveSettings.withVmOption(String.format("-D%s=%d", "idea.debugger.dispatch.port", dispatchPort));
        }
        if ((dispatchAddr = (String)effectiveSettings.getUserData(ExternalSystemRunnableState.DEBUGGER_DISPATCH_ADDR_KEY)) != null) {
            effectiveSettings.withVmOption(String.format("-D%s=%s", "idea.debugger.dispatch.addr", dispatchAddr));
        }
    }

    public static void runCustomTask(@NotNull Project project, @NotNull @Nls String executionName, @NotNull Class<? extends Task> taskClass, @NotNull String projectPath, @NotNull String gradlePath2, @Nullable String taskConfiguration, @Nullable TaskCallback callback) {
        GradleTaskManager.runCustomTask(project, executionName, taskClass, projectPath, gradlePath2, taskConfiguration, ProgressExecutionMode.IN_BACKGROUND_ASYNC, callback);
    }

    public static void runCustomTask(@NotNull Project project, @NotNull @Nls String executionName, @NotNull Class<? extends Task> taskClass, @NotNull String projectPath, @NotNull String gradlePath2, @Nullable String taskConfiguration, @NotNull ProgressExecutionMode progressExecutionMode, @Nullable TaskCallback callback) {
        String taskName = taskClass.getSimpleName();
        String paths = GradleExecutionHelper.getToolingExtensionsJarPaths(ContainerUtil.set((Object[])new Class[]{taskClass, GsonBuilder.class, THash.class, ExternalSystemException.class}));
        String initScript = "initscript {\n  dependencies {\n    classpath files(" + paths + ")\n  }\n}\nallprojects {\n  afterEvaluate { project ->\n    if(project.path == '" + gradlePath2 + "' || ':' + rootProject.projectDir.name + project.path == '" + gradlePath2 + "' ) {\n        def overwrite = project.tasks.findByName('" + taskName + "') != null\n        project.tasks.create(name: '" + taskName + "', overwrite: overwrite, type: " + taskClass.getName() + ") {\n" + StringUtil.notNullize((String)taskConfiguration) + "\n        }\n    }\n  }\n}\n";
        UserDataHolderBase userData = new UserDataHolderBase();
        userData.putUserData(INIT_SCRIPT_KEY, (Object)initScript);
        userData.putUserData(ExternalSystemRunConfiguration.PROGRESS_LISTENER_KEY, SyncViewManager.class);
        String gradleVmOptions = GradleSettings.getInstance(project).getGradleVmOptions();
        ExternalSystemTaskExecutionSettings settings2 = new ExternalSystemTaskExecutionSettings();
        settings2.setExecutionName(executionName);
        settings2.setExternalProjectPath(projectPath);
        Object taskPrefix = gradlePath2.endsWith(":") ? gradlePath2 : gradlePath2 + ":";
        settings2.setTaskNames(Collections.singletonList((String)taskPrefix + taskName));
        settings2.setVmOptions(gradleVmOptions);
        settings2.setExternalSystemIdString(GradleConstants.SYSTEM_ID.getId());
        ExternalSystemUtil.runTask((ExternalSystemTaskExecutionSettings)settings2, (String)"Run", (Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (TaskCallback)callback, (ProgressExecutionMode)progressExecutionMode, (boolean)false, (UserDataHolderBase)userData);
    }
}

