/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Service(value={Service.Level.PROJECT})
public final class ExternalProjectDataCache {
    @ApiStatus.Internal
    @NotNull
    public static final Key<ExternalProject> KEY = Key.create(ExternalProject.class, (int)(ProjectKeys.TASK.getProcessingWeight() + 1));
    private final Project myProject;

    public static ExternalProjectDataCache getInstance(@NotNull Project project) {
        return (ExternalProjectDataCache)project.getService(ExternalProjectDataCache.class);
    }

    public ExternalProjectDataCache(@NotNull Project project) {
        this.myProject = project;
    }

    @Nullable
    public ExternalProject getRootExternalProject(@NotNull String externalProjectPath2) {
        ExternalProjectInfo projectData = ProjectDataManager.getInstance().getExternalProjectData(this.myProject, GradleConstants.SYSTEM_ID, externalProjectPath2);
        if (projectData == null) {
            return null;
        }
        DataNode projectStructure = projectData.getExternalProjectStructure();
        if (projectStructure == null) {
            return null;
        }
        DataNode projectDataNode = ExternalSystemApiUtil.find((DataNode)projectStructure, KEY);
        if (projectDataNode == null) {
            return null;
        }
        return (ExternalProject)projectDataNode.getData();
    }

    @NotNull
    public Map<String, ExternalSourceSet> findExternalProject(@NotNull ExternalProject parentProject, @NotNull Module module) {
        String externalProjectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        boolean isSourceSet = "sourceSet".equals(ExternalSystemApiUtil.getExternalModuleType((Module)module));
        return externalProjectId != null ? ExternalProjectDataCache.findExternalProject(parentProject, externalProjectId, isSourceSet) : Collections.emptyMap();
    }

    @NotNull
    private static Map<String, ExternalSourceSet> findExternalProject(@NotNull ExternalProject parentProject, @NotNull String externalProjectId, boolean isSourceSet) {
        ExternalProject externalProject;
        ArrayDeque<Object> queue = new ArrayDeque<Object>();
        queue.add(parentProject);
        while ((externalProject = (ExternalProject)queue.pollFirst()) != null) {
            String projectId = externalProject.getId();
            boolean isRelatedProject = projectId.equals(externalProjectId);
            HashMap<String, ExternalSourceSet> result = new HashMap<String, ExternalSourceSet>();
            for (Map.Entry sourceSetEntry : externalProject.getSourceSets().entrySet()) {
                String sourceSetName = (String)sourceSetEntry.getKey();
                String sourceSetId = projectId + ":" + sourceSetName;
                if (!isRelatedProject && (!isSourceSet || !externalProjectId.equals(sourceSetId))) continue;
                result.put(sourceSetName, (ExternalSourceSet)sourceSetEntry.getValue());
            }
            if (!result.isEmpty() || isRelatedProject) {
                return result;
            }
            queue.addAll(externalProject.getChildProjects().values());
        }
        return Collections.emptyMap();
    }
}

