/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.importing.ExternalProjectStructureCustomizer;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.Identifiable;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.util.GradleBundle;

public class GradleProjectStructureCustomizer
extends ExternalProjectStructureCustomizer {
    @NotNull
    public Set<? extends Key<?>> getIgnorableDataKeys() {
        return GradleProjectStructureCustomizer.getDataKeys();
    }

    @NotNull
    public Set<? extends Key<?>> getPublicDataKeys() {
        return GradleProjectStructureCustomizer.getDataKeys();
    }

    @NotNull
    public Set<? extends Key<? extends Identifiable>> getDependencyAwareDataKeys() {
        return GradleProjectStructureCustomizer.getDataKeys();
    }

    @Nullable
    public Icon suggestIcon(@NotNull DataNode node, @NotNull ExternalSystemUiAware uiAware) {
        return null;
    }

    public @NotNull Couple<@Nls String> getRepresentationName(@NotNull DataNode node) {
        if (node.getKey().equals(GradleSourceSetData.KEY)) {
            GradleSourceSetData data = (GradleSourceSetData)((Object)node.getData());
            String comment = StringUtil.substringAfter((String)data.getExternalName(), (String)":");
            return Couple.of((Object)GradleBundle.message("gradle.project.structure.source.set", new Object[0]), (Object)comment);
        }
        if (node.getKey().equals((Object)ProjectKeys.MODULE)) {
            ModuleData moduleData = (ModuleData)node.getData();
            return Couple.of((Object)moduleData.getExternalName(), null);
        }
        return super.getRepresentationName(node);
    }

    @NotNull
    private static Set<? extends Key<? extends Identifiable>> getDataKeys() {
        return ContainerUtil.set((Object[])new Key[]{GradleSourceSetData.KEY, ProjectKeys.MODULE});
    }
}

