/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.ParametersEnhancer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.model.BuildModel;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ModelsHolder;
import org.jetbrains.plugins.gradle.model.ProjectImportModelProvider;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;

public interface GradleProjectResolverExtension
extends ParametersEnhancer {
    @ApiStatus.Internal
    public static final ExtensionPointName<GradleProjectResolverExtension> EP_NAME = ExtensionPointName.create((String)"org.jetbrains.plugins.gradle.projectResolve");
    public static final String JVM_PARAMETERS_SETUP_KEY = "JVM_PARAMETERS_SETUP";
    public static final String TEST_EXECUTION_EXPECTED_KEY = "TEST_EXECUTION_EXPECTED";
    public static final String TEST_LAUNCHER_WILL_BE_USED_KEY = "TEST_LAUNCHER_WILL_BE_USED";
    public static final String DEBUG_DISPATCH_PORT_KEY = "DEBUG_DISPATCH_PORT";
    public static final String DEBUG_DISPATCH_ADDR_KEY = "DEBUG_DISPATCH_ADDR";
    public static final String DEBUG_OPTIONS_KEY = "DEBUG_OPTIONS";
    public static final String GRADLE_VERSION = "GRADLE_VERSION";

    public void setProjectResolverContext(@NotNull ProjectResolverContext var1);

    public void setNext(@NotNull GradleProjectResolverExtension var1);

    @Nullable
    public GradleProjectResolverExtension getNext();

    public void populateProjectExtraModels(@NotNull IdeaProject var1, @NotNull DataNode<ProjectData> var2);

    @Nullable
    public DataNode<ModuleData> createModule(@NotNull IdeaModule var1, @NotNull DataNode<ProjectData> var2);

    public void populateModuleExtraModels(@NotNull IdeaModule var1, @NotNull DataNode<ModuleData> var2);

    public void populateModuleContentRoots(@NotNull IdeaModule var1, @NotNull DataNode<ModuleData> var2);

    public void populateModuleCompileOutputSettings(@NotNull IdeaModule var1, @NotNull DataNode<ModuleData> var2);

    public void populateModuleDependencies(@NotNull IdeaModule var1, @NotNull DataNode<ModuleData> var2, @NotNull DataNode<ProjectData> var3);

    @NotNull
    public Collection<TaskData> populateModuleTasks(@NotNull IdeaModule var1, @NotNull DataNode<ModuleData> var2, @NotNull DataNode<ProjectData> var3);

    @ApiStatus.Experimental
    default public void resolveFinished(@NotNull DataNode<ProjectData> projectDataNode) {
    }

    @NotNull
    public Set<Class<?>> getExtraProjectModelClasses();

    @Nullable
    default public ProjectImportModelProvider getModelProvider() {
        return null;
    }

    @Nullable
    default public ProjectImportModelProvider getProjectsLoadedModelProvider() {
        return null;
    }

    @NotNull
    public Set<Class<?>> getToolingExtensionsClasses();

    default public Set<Class<?>> getTargetTypes() {
        return Collections.emptySet();
    }

    @NotNull
    public List<Pair<String, String>> getExtraJvmArgs();

    @NotNull
    public List<String> getExtraCommandLineArgs();

    @NotNull
    public ExternalSystemException getUserFriendlyError(@Nullable BuildEnvironment var1, @NotNull Throwable var2, @NotNull String var3, @Nullable String var4);

    public void preImportCheck();

    default public void projectsLoaded(@Nullable ModelsHolder<BuildModel, ProjectModel> models) {
    }

    default public void buildFinished(@Nullable GradleConnectionException exception) {
    }

    public void enhanceTaskProcessing(@NotNull List<String> var1, @Nullable String var2, @NotNull Consumer<String> var3);

    @ApiStatus.Experimental
    default public void enhanceTaskProcessing(@NotNull List<String> taskNames, @NotNull Consumer<String> initScriptConsumer, @NotNull Map<String, String> parameters) {
        String jvmParametersSetup = parameters.get(JVM_PARAMETERS_SETUP_KEY);
        this.enhanceTaskProcessing(taskNames, jvmParametersSetup, initScriptConsumer);
    }
}

