/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.notification;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class GotoSourceNotificationCallback
extends NotificationListener.Adapter {
    public static final String ID = "goto_source";
    private final NotificationData myNotificationData;
    private final Project myProject;

    public GotoSourceNotificationCallback(NotificationData notificationData, Project project) {
        this.myNotificationData = notificationData;
        this.myProject = project;
    }

    protected void hyperlinkActivated(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
        if (this.myNotificationData.getFilePath() == null) {
            return;
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myNotificationData.getFilePath());
        assert (virtualFile != null);
        int line = this.myNotificationData.getLine() - 1;
        int column = this.myNotificationData.getColumn() - 1;
        int guiLine = line < 0 ? -1 : line;
        int guiColumn = column < 0 ? -1 : column + 1;
        new OpenFileDescriptor(this.myProject, virtualFile, guiLine, guiColumn).navigate(true);
    }
}

