/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.frameworkSupport.buildscript;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001\u001a\u000e\u0010\n\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0010"}, d2={"getGroovyVersion", "", "getJunit4Version", "getJunit5Version", "getKotlinVersion", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "isSupportedGroovyApache", "", "groovyVersion", "isSupportedImplementationScope", "isSupportedJUnit5", "isSupportedJavaLibraryPlugin", "isSupportedKotlin4", "isSupportedRuntimeOnlyScope", "isSupportedTaskConfigurationAvoidance", "intellij.gradle.common"})
@JvmName(name="GradleBuildScriptBuilderUtil")
public final class GradleBuildScriptBuilderUtil {
    public static final boolean isSupportedJavaLibraryPlugin(@NotNull GradleVersion gradleVersion2) {
        return gradleVersion2.getBaseVersion().compareTo(GradleVersion.version((String)"3.4")) >= 0;
    }

    public static final boolean isSupportedImplementationScope(@NotNull GradleVersion gradleVersion2) {
        return GradleBuildScriptBuilderUtil.isSupportedJavaLibraryPlugin(gradleVersion2);
    }

    public static final boolean isSupportedRuntimeOnlyScope(@NotNull GradleVersion gradleVersion2) {
        return GradleBuildScriptBuilderUtil.isSupportedJavaLibraryPlugin(gradleVersion2);
    }

    public static final boolean isSupportedTaskConfigurationAvoidance(@NotNull GradleVersion gradleVersion2) {
        return gradleVersion2.getBaseVersion().compareTo(GradleVersion.version((String)"4.9")) >= 0;
    }

    public static final boolean isSupportedJUnit5(@NotNull GradleVersion gradleVersion2) {
        return gradleVersion2.getBaseVersion().compareTo(GradleVersion.version((String)"4.7")) >= 0;
    }

    public static final boolean isSupportedKotlin4(@NotNull GradleVersion gradleVersion2) {
        return gradleVersion2.getBaseVersion().compareTo(GradleVersion.version((String)"5.6.2")) >= 0;
    }

    @NotNull
    public static final String getKotlinVersion(@NotNull GradleVersion gradleVersion2) {
        return GradleBuildScriptBuilderUtil.isSupportedKotlin4(gradleVersion2) ? "1.4.32" : "1.3.50";
    }

    @NotNull
    public static final String getGroovyVersion() {
        return "3.0.5";
    }

    @NotNull
    public static final String getJunit4Version() {
        return "4.12";
    }

    @NotNull
    public static final String getJunit5Version() {
        return "5.8.1";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isSupportedGroovyApache(@NotNull String groovyVersion) {
        String string2;
        String string3 = (String)CollectionsKt.firstOrNull((List)StringsKt.split$default((CharSequence)groovyVersion, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null));
        Object object = string3;
        if (string3 == null) return false;
        String p1 = string2 = object;
        boolean bl = false;
        Integer n = Integer.valueOf(p1);
        object = n;
        if (n == null) return false;
        int n2 = (Integer)object;
        int majorVersion = n2;
        if (majorVersion < 4) return false;
        return true;
    }
}

