/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.service.execution.DefaultExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemExecuteTaskTask;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemResolveProjectTask;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.filters.ReRunSyncFilter;
import org.jetbrains.plugins.gradle.execution.filters.ReRunTaskFilter;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleExecutionConsoleManager
extends DefaultExternalSystemExecutionConsoleManager {
    @NotNull
    public ProjectSystemId getExternalSystemId() {
        return GradleConstants.SYSTEM_ID;
    }

    @Nullable
    public ExecutionConsole attachExecutionConsole(@NotNull Project project, @NotNull ExternalSystemTask task2, @Nullable ExecutionEnvironment env, @Nullable ProcessHandler processHandler2) {
        Filter[] filters;
        ConsoleView executionConsole = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
        executionConsole.attachToProcess(processHandler2);
        for (Filter filter : filters = this.getCustomExecutionFilters(project, task2, env)) {
            executionConsole.addMessageFilter(filter);
        }
        return executionConsole;
    }

    public boolean isApplicableFor(@NotNull ExternalSystemTask task2) {
        return GradleConstants.SYSTEM_ID.equals((Object)task2.getId().getProjectSystemId());
    }

    public Filter[] getCustomExecutionFilters(@NotNull Project project, @NotNull ExternalSystemTask task2, @Nullable ExecutionEnvironment env) {
        if (task2 instanceof ExternalSystemExecuteTaskTask) {
            return new Filter[]{new ReRunTaskFilter((ExternalSystemExecuteTaskTask)task2, env)};
        }
        if (task2 instanceof ExternalSystemResolveProjectTask) {
            return new Filter[]{new ReRunSyncFilter((ExternalSystemResolveProjectTask)task2, project)};
        }
        return Filter.EMPTY_ARRAY;
    }
}

