/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.dependency.analyzer;

import com.google.gson.GsonBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAArtifact;
import com.intellij.openapi.externalSystem.dependency.analyzer.DADependency;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAModule;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAProject;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAScope;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAWarning;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerContributor;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerDependency;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerProject;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.dependencies.ArtifactDependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyScopeNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ReferenceNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ResolutionState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.dependency.analyzer.GradleDependencyAnalyzerContributor;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManager;
import org.jetbrains.plugins.gradle.tooling.tasks.DependenciesReport;
import org.jetbrains.plugins.gradle.tooling.tasks.DependencyNodeDeserializer;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleModuleData;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 02\u00020\u0001:\u00010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u00182\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\"\u0010\u001a\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\b2\u0006\u0010\u001c\u001a\u00020\u000eH\u0016J$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\b2\u0006\u0010\u001d\u001a\u00020\u000f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140\b2\u0006\u0010\u001c\u001a\u00020\u000eH\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010!\u001a\u00020\u000fH\u0002J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000e0\bH\u0016J\u001e\u0010#\u001a\u00020\u00112\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00110%2\u0006\u0010&\u001a\u00020'H\u0016J\u000e\u0010(\u001a\u0004\u0018\u00010)*\u00020\u0016H\u0002J\u000e\u0010*\u001a\u0004\u0018\u00010+*\u00020,H\u0002J\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\b*\u00020\u00162\u0006\u0010/\u001a\u00020)H\u0002R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/plugins/gradle/dependency/analyzer/GradleDependencyAnalyzerContributor;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerContributor;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "configurationNodesMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "Lcom/intellij/openapi/externalSystem/model/project/dependencies/DependencyScopeNode;", "dependencyMap", "", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency;", "projects", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerProject;", "Lorg/jetbrains/plugins/gradle/util/GradleModuleData;", "addDependencies", "", "usage", "scope", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Scope;", "dependencyNode", "Lcom/intellij/openapi/externalSystem/model/project/dependencies/DependencyNode;", "dependencies", "", "gradleProjectDir", "createDependency", "getDependencies", "externalProject", "moduleData", "scopeNodes", "getDependencyScopes", "getOrRefreshData", "gradleModuleData", "getProjects", "whenDataChanged", "listener", "Lkotlin/Function0;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "getDependencyData", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Data;", "getModuleData", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "Lcom/intellij/openapi/externalSystem/model/project/dependencies/ProjectDependencyNode;", "getStatus", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Status;", "data", "Companion", "intellij.gradle.common"})
public final class GradleDependencyAnalyzerContributor
implements DependencyAnalyzerContributor {
    private final ConcurrentHashMap<DependencyAnalyzerProject, GradleModuleData> projects;
    private final ConcurrentHashMap<String, List<DependencyScopeNode>> configurationNodesMap;
    private final ConcurrentHashMap<Long, DependencyAnalyzerDependency> dependencyMap;
    private final Project project;
    @NotNull
    private static final DAScope defaultConfiguration;
    @NotNull
    private static final com.intellij.openapi.util.Key<ModuleData> MODULE_DATA;
    @NotNull
    public static final Companion Companion;

    public void whenDataChanged(@NotNull Function0<Unit> listener2, @NotNull Disposable parentDisposable) {
        ExternalSystemProgressNotificationManager progressManager = ExternalSystemProgressNotificationManager.getInstance();
        progressManager.addNotificationListener((ExternalSystemTaskNotificationListener)new ExternalSystemTaskNotificationListenerAdapter(this, listener2){
            final /* synthetic */ GradleDependencyAnalyzerContributor this$0;
            final /* synthetic */ Function0 $listener;

            public void onEnd(@NotNull ExternalSystemTaskId id) {
                if (id.getType() != ExternalSystemTaskType.RESOLVE_PROJECT) {
                    return;
                }
                if (Intrinsics.areEqual((Object)id.getProjectSystemId(), (Object)GradleConstants.SYSTEM_ID) ^ true) {
                    return;
                }
                GradleDependencyAnalyzerContributor.access$getProjects$p(this.this$0).clear();
                GradleDependencyAnalyzerContributor.access$getConfigurationNodesMap$p(this.this$0).clear();
                GradleDependencyAnalyzerContributor.access$getDependencyMap$p(this.this$0).clear();
                this.$listener.invoke();
            }
            {
                this.this$0 = this$0;
                this.$listener = $captured_local_variable$1;
            }
        }, parentDisposable);
    }

    @NotNull
    public List<DependencyAnalyzerProject> getProjects() {
        if (this.projects.isEmpty()) {
            ProjectDataManager projectDataManager = ProjectDataManager.getInstance();
            for (ExternalProjectInfo projectInfo : projectDataManager.getExternalProjectsData(this.project, GradleConstants.SYSTEM_ID)) {
                DataNode projectStructure;
                if (projectInfo.getExternalProjectStructure() == null) {
                    continue;
                }
                for (DataNode moduleNode : ExternalSystemApiUtil.findAll((DataNode)projectStructure, (Key)ProjectKeys.MODULE)) {
                    Module module;
                    ModuleData moduleData = (ModuleData)moduleNode.getData();
                    GradleModuleData gradleModuleData = new GradleModuleData((DataNode<? extends ModuleData>)moduleNode);
                    if (gradleModuleData.isBuildSrcModule()) continue;
                    if (GradleUtil.findGradleModule(this.project, moduleData) == null) {
                        continue;
                    }
                    DAProject externalProject = new DAProject(module, moduleData.getModuleName());
                    ((Map)this.projects).put(externalProject, gradleModuleData);
                }
            }
        }
        return CollectionsKt.toList((Iterable)this.projects.keySet());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<DependencyAnalyzerDependency.Scope> getDependencyScopes(@NotNull DependencyAnalyzerProject externalProject) {
        void $this$mapTo$iv$iv;
        GradleModuleData gradleModuleData = this.projects.get(externalProject);
        if (gradleModuleData == null) {
            return CollectionsKt.emptyList();
        }
        GradleModuleData gradleModuleData2 = gradleModuleData;
        Iterable $this$map$iv = this.getOrRefreshData(gradleModuleData2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DependencyScopeNode dependencyScopeNode = (DependencyScopeNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            DAScope dAScope = GradleDependencyAnalyzerContributor.Companion.toScope((DependencyScopeNode)it);
            collection.add(dAScope);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public List<DependencyAnalyzerDependency> getDependencies(@NotNull DependencyAnalyzerProject externalProject) {
        GradleModuleData gradleModuleData = this.projects.get(externalProject);
        if (gradleModuleData == null) {
            return CollectionsKt.emptyList();
        }
        GradleModuleData gradleModuleData2 = gradleModuleData;
        List<DependencyScopeNode> scopeNodes = this.getOrRefreshData(gradleModuleData2);
        return this.getDependencies(gradleModuleData2, scopeNodes);
    }

    private final List<DependencyScopeNode> getOrRefreshData(GradleModuleData gradleModuleData) {
        return this.configurationNodesMap.computeIfAbsent(gradleModuleData.getGradleProjectDir(), new Function(this, gradleModuleData){
            final /* synthetic */ GradleDependencyAnalyzerContributor this$0;
            final /* synthetic */ GradleModuleData $gradleModuleData;

            @NotNull
            public final List<DependencyScopeNode> apply(@NotNull String it) {
                return org.jetbrains.plugins.gradle.dependency.analyzer.GradleDependencyAnalyzerContributor$Companion.access$getDependencies(GradleDependencyAnalyzerContributor.Companion, this.$gradleModuleData, GradleDependencyAnalyzerContributor.access$getProject$p(this.this$0));
            }
            {
                this.this$0 = gradleDependencyAnalyzerContributor;
                this.$gradleModuleData = gradleModuleData;
            }
        });
    }

    private final List<DependencyAnalyzerDependency> getDependencies(GradleModuleData moduleData, List<? extends DependencyScopeNode> scopeNodes) {
        if (scopeNodes.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ArrayList<DADependency> dependencies = new ArrayList<DADependency>();
        DAModule root = new DAModule(moduleData.getModuleName());
        root.putUserData(MODULE_DATA, (Object)moduleData.getModuleData());
        DADependency rootDependency = new DADependency((DependencyAnalyzerDependency.Data)root, (DependencyAnalyzerDependency.Scope)defaultConfiguration, null, CollectionsKt.emptyList());
        dependencies.add(rootDependency);
        for (DependencyScopeNode dependencyScopeNode : scopeNodes) {
            DAScope scope = GradleDependencyAnalyzerContributor.Companion.toScope(dependencyScopeNode);
            for (DependencyNode dependencyNode : dependencyScopeNode.getDependencies()) {
                this.addDependencies((DependencyAnalyzerDependency)rootDependency, (DependencyAnalyzerDependency.Scope)scope, dependencyNode, (List<DependencyAnalyzerDependency>)dependencies, moduleData.getGradleProjectDir());
            }
        }
        return dependencies;
    }

    private final void addDependencies(DependencyAnalyzerDependency usage, DependencyAnalyzerDependency.Scope scope, DependencyNode dependencyNode, List<DependencyAnalyzerDependency> dependencies, String gradleProjectDir) {
        DependencyAnalyzerDependency dependencyAnalyzerDependency = this.createDependency(dependencyNode, scope, usage);
        if (dependencyAnalyzerDependency == null) {
            return;
        }
        DependencyAnalyzerDependency dependency = dependencyAnalyzerDependency;
        dependencies.add(dependency);
        for (DependencyNode node : dependencyNode.getDependencies()) {
            this.addDependencies(dependency, scope, node, dependencies, gradleProjectDir);
        }
    }

    private final DependencyAnalyzerDependency createDependency(DependencyNode dependencyNode, DependencyAnalyzerDependency.Scope scope, DependencyAnalyzerDependency usage) {
        DADependency dADependency;
        DependencyNode dependencyNode2 = dependencyNode;
        if (dependencyNode2 instanceof ReferenceNode) {
            DependencyAnalyzerDependency dependencyAnalyzerDependency = this.dependencyMap.get(((ReferenceNode)dependencyNode).getId());
            if (dependencyAnalyzerDependency == null) {
                return null;
            }
            DependencyAnalyzerDependency dependency = dependencyAnalyzerDependency;
            return (DependencyAnalyzerDependency)new DADependency(dependency.getData(), scope, usage, dependency.getStatus());
        }
        DependencyAnalyzerDependency.Data data = this.getDependencyData(dependencyNode);
        if (data == null) {
            return null;
        }
        DependencyAnalyzerDependency.Data dependencyData = data;
        List<DependencyAnalyzerDependency.Status> status = this.getStatus(dependencyNode, dependencyData);
        DADependency it = dADependency = new DADependency(dependencyData, scope, usage, status);
        boolean bl = false;
        ((Map)this.dependencyMap).put(dependencyNode.getId(), it);
        return (DependencyAnalyzerDependency)dADependency;
    }

    private final List<DependencyAnalyzerDependency.Status> getStatus(DependencyNode $this$getStatus, DependencyAnalyzerDependency.Data data) {
        String conflictedVersion;
        CharSequence charSequence;
        List status = new ArrayList();
        if ($this$getStatus.getResolutionState() == ResolutionState.UNRESOLVED) {
            String message = ExternalSystemBundle.message((String)"external.system.dependency.analyzer.warning.unresolved", (Object[])new Object[0]);
            status.add(new DAWarning(message));
        }
        String selectionReason = $this$getStatus.getSelectionReason();
        if (data instanceof DependencyAnalyzerDependency.Data.Artifact && selectionReason != null && StringsKt.startsWith$default((String)selectionReason, (String)"between versions", (boolean)false, (int)2, null) && (charSequence = (CharSequence)(conflictedVersion = StringsKt.substringAfter((String)selectionReason, (String)("between versions " + ((DependencyAnalyzerDependency.Data.Artifact)data).getVersion() + " and "), (String)""))).length() > 0) {
            String message = ExternalSystemBundle.message((String)"external.system.dependency.analyzer.warning.version.conflict", (Object[])new Object[]{conflictedVersion});
            status.add(new DAWarning(message));
        }
        return status;
    }

    private final DependencyAnalyzerDependency.Data getDependencyData(DependencyNode $this$getDependencyData) {
        DependencyAnalyzerDependency.Data data;
        DependencyNode dependencyNode = $this$getDependencyData;
        if (dependencyNode instanceof ProjectDependencyNode) {
            DAModule data2 = new DAModule(((ProjectDependencyNode)$this$getDependencyData).getProjectName());
            ModuleData moduleData = this.getModuleData((ProjectDependencyNode)$this$getDependencyData);
            data2.putUserData(MODULE_DATA, (Object)moduleData);
            data = (DependencyAnalyzerDependency.Data)data2;
        } else {
            data = dependencyNode instanceof ArtifactDependencyNode ? (DependencyAnalyzerDependency.Data)new DAArtifact(((ArtifactDependencyNode)$this$getDependencyData).getGroup(), ((ArtifactDependencyNode)$this$getDependencyData).getModule(), ((ArtifactDependencyNode)$this$getDependencyData).getVersion()) : null;
        }
        return data;
    }

    private final ModuleData getModuleData(ProjectDependencyNode $this$getModuleData) {
        Object v0;
        block1: {
            Sequence sequence;
            Sequence sequence2 = sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.projects.values()), (Function1)getModuleData.1.INSTANCE);
            for (Object e : sequence2) {
                ModuleData it = (ModuleData)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)$this$getModuleData.getProjectPath())) continue;
                v0 = e;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public GradleDependencyAnalyzerContributor(@NotNull Project project) {
        this.project = project;
        this.projects = new ConcurrentHashMap();
        this.configurationNodesMap = new ConcurrentHashMap();
        this.dependencyMap = new ConcurrentHashMap();
    }

    static {
        Companion = new Companion(null);
        defaultConfiguration = GradleDependencyAnalyzerContributor.Companion.scope("default");
        MODULE_DATA = com.intellij.openapi.util.Key.create((String)"GradleDependencyAnalyzerContributor.ModuleData");
    }

    public static final /* synthetic */ ConcurrentHashMap access$getProjects$p(GradleDependencyAnalyzerContributor $this) {
        return $this.projects;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getConfigurationNodesMap$p(GradleDependencyAnalyzerContributor $this) {
        return $this.configurationNodesMap;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getDependencyMap$p(GradleDependencyAnalyzerContributor $this) {
        return $this.dependencyMap;
    }

    public static final /* synthetic */ Project access$getProject$p(GradleDependencyAnalyzerContributor $this) {
        return $this.project;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u000e\u001a\u00020\u000b2\u000b\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011H\u0002J\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\f\u0010\u0018\u001a\u00020\u000b*\u00020\u0014H\u0002R'\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/gradle/dependency/analyzer/GradleDependencyAnalyzerContributor$Companion;", "", "()V", "MODULE_DATA", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getMODULE_DATA$intellij_gradle_common", "()Lcom/intellij/openapi/util/Key;", "defaultConfiguration", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DAScope;", "getDefaultConfiguration$intellij_gradle_common", "()Lcom/intellij/openapi/externalSystem/dependency/analyzer/DAScope;", "scope", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "getDependencies", "", "Lcom/intellij/openapi/externalSystem/model/project/dependencies/DependencyScopeNode;", "Lorg/jetbrains/plugins/gradle/util/GradleModuleData;", "project", "Lcom/intellij/openapi/project/Project;", "toScope", "intellij.gradle.common"})
    public static final class Companion {
        @NotNull
        public final DAScope getDefaultConfiguration$intellij_gradle_common() {
            return defaultConfiguration;
        }

        @NotNull
        public final com.intellij.openapi.util.Key<ModuleData> getMODULE_DATA$intellij_gradle_common() {
            return MODULE_DATA;
        }

        /*
         * WARNING - void declaration
         */
        private final List<DependencyScopeNode> getDependencies(GradleModuleData $this$getDependencies, Project project) {
            void dependencyScopeNodes;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = CollectionsKt.emptyList();
            File outputFile = FileUtil.createTempFile((String)"dependencies", (String)".json", (boolean)true);
            String taskConfiguration = StringsKt.trimIndent((String)("\n        outputFile = project.file(\"" + FileUtil.toCanonicalPath((String)outputFile.getAbsolutePath()) + "\")\n        configurations = []\n        "));
            GradleTaskManager.runCustomTask(project, GradleBundle.message("gradle.dependency.analyzer.loading", new Object[0]), DependenciesReport.class, $this$getDependencies.getDirectoryToRunTask(), $this$getDependencies.getFullGradlePath(), taskConfiguration, ProgressExecutionMode.NO_PROGRESS_SYNC, new TaskCallback(outputFile, (Ref.ObjectRef)dependencyScopeNodes){
                final /* synthetic */ File $outputFile;
                final /* synthetic */ Ref.ObjectRef $dependencyScopeNodes;

                public void onSuccess() {
                    String json = FileUtil.loadFile((File)this.$outputFile);
                    GsonBuilder gsonBuilder = new GsonBuilder();
                    gsonBuilder.registerTypeAdapter((Type)((Object)DependencyNode.class), (Object)new DependencyNodeDeserializer());
                    this.$dependencyScopeNodes.element = ArraysKt.asList((Object[])((Object[])gsonBuilder.create().fromJson(json, DependencyScopeNode[].class)));
                }

                public void onFailure() {
                }
                {
                    this.$outputFile = $captured_local_variable$0;
                    this.$dependencyScopeNodes = $captured_local_variable$1;
                }
            });
            FileUtil.asyncDelete((File)outputFile);
            return (List)dependencyScopeNodes.element;
        }

        private final DAScope toScope(DependencyScopeNode $this$toScope) {
            return this.scope($this$toScope.getScope());
        }

        private final DAScope scope(String name2) {
            return new DAScope(name2, StringUtil.toTitleCase((String)name2));
        }

        private Companion() {
        }

        public static final /* synthetic */ List access$getDependencies(Companion $this, GradleModuleData $this$access_u24getDependencies, Project project) {
            return $this.getDependencies($this$access_u24getDependencies, project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

