/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.action;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.statistics.GradleActionsUsagesCollector;
import org.jetbrains.plugins.gradle.util.GradleUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PasteMvnDependencyPreProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        return null;
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        if (this.isApplicable(file) && PasteMvnDependencyPreProcessor.isMvnDependency(text)) {
            GradleActionsUsagesCollector.trigger(project, GradleActionsUsagesCollector.PASTE_MAVEN_DEPENDENCY);
            GradleVersion gradleVersion2 = GradleUtil.getGradleVersion(project, file);
            return PasteMvnDependencyPreProcessor.toGradleDependency(text, gradleVersion2);
        }
        return text;
    }

    protected boolean isApplicable(PsiFile file) {
        return file.getName().endsWith(".gradle");
    }

    @NotNull
    private static String formatGradleDependency(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @NotNull String scope, @NotNull String classifier) {
        Object gradleClassifier = classifier.isEmpty() ? "" : ":" + classifier;
        return scope + " '" + groupId + ":" + artifactId + ":" + version + (String)gradleClassifier + "'";
    }

    @ApiStatus.Internal
    @NotNull
    public static String toGradleDependency(@NotNull String mavenDependency, @NotNull GradleVersion gradleVersion2) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newDefaultInstance();
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(mavenDependency)));
            String gradleDependency = PasteMvnDependencyPreProcessor.extractGradleDependency(document, gradleVersion2);
            return gradleDependency != null ? gradleDependency : mavenDependency;
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            return mavenDependency;
        }
    }

    @Nullable
    private static String extractGradleDependency(Document document, @NotNull GradleVersion gradleVersion2) {
        String groupId = PasteMvnDependencyPreProcessor.getGroupId(document);
        String artifactId = PasteMvnDependencyPreProcessor.getArtifactId(document);
        String version = PasteMvnDependencyPreProcessor.getVersion(document);
        String scope = PasteMvnDependencyPreProcessor.getScope(document, gradleVersion2);
        String classifier = PasteMvnDependencyPreProcessor.getClassifier(document);
        if (groupId.isEmpty() || artifactId.isEmpty() || version.isEmpty()) {
            return null;
        }
        return PasteMvnDependencyPreProcessor.formatGradleDependency(groupId, artifactId, version, scope, classifier);
    }

    @NotNull
    private static String getScope(@NotNull Document document, @NotNull GradleVersion gradleVersion2) {
        String scope = PasteMvnDependencyPreProcessor.firstOrEmpty(document.getElementsByTagName("scope"));
        boolean isSupportedImplementation = GradleUtil.isSupportedImplementationScope(gradleVersion2);
        switch (scope) {
            case "test": {
                return isSupportedImplementation ? "testImplementation" : "testCompile";
            }
            case "provided": {
                return "compileOnly";
            }
            case "runtime": {
                return "runtime";
            }
        }
        return isSupportedImplementation ? "implementation" : "compile";
    }

    private static String getVersion(@NotNull Document document) {
        return PasteMvnDependencyPreProcessor.firstOrEmpty(document.getElementsByTagName("version"));
    }

    private static String getArtifactId(@NotNull Document document) {
        return PasteMvnDependencyPreProcessor.firstOrEmpty(document.getElementsByTagName("artifactId"));
    }

    private static String getGroupId(@NotNull Document document) {
        return PasteMvnDependencyPreProcessor.firstOrEmpty(document.getElementsByTagName("groupId"));
    }

    private static String getClassifier(@NotNull Document document) {
        return PasteMvnDependencyPreProcessor.firstOrEmpty(document.getElementsByTagName("classifier"));
    }

    private static String firstOrEmpty(@NotNull NodeList list2) {
        Node first = list2.item(0);
        return first != null ? first.getTextContent() : "";
    }

    private static boolean isMvnDependency(String text) {
        String trimmed = PasteMvnDependencyPreProcessor.trimLeadingComment(text.trim());
        return trimmed.startsWith("<dependency>") && trimmed.endsWith("</dependency>");
    }

    private static String trimLeadingComment(String text) {
        int start2 = text.indexOf("<!--");
        int end = text.indexOf("-->");
        if (start2 == 0 && end > 0) {
            return text.substring(end + "-->".length()).trim();
        }
        return text;
    }

    public boolean requiresAllDocumentsToBeCommitted(@NotNull Editor editor, @NotNull Project project) {
        return false;
    }
}

