/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.serialization.ClassUtil;
import com.intellij.serialization.MutableAccessor;
import com.intellij.util.xml.dom.XmlElement;
import com.intellij.util.xmlb.BasePrimitiveBinding;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.CollectionBinding;
import com.intellij.util.xmlb.MapBinding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TagBinding
extends BasePrimitiveBinding
implements MultiNodeBinding {
    private final String myTextIfEmpty;

    TagBinding(@NotNull MutableAccessor accessor, @NotNull Tag tagAnnotation) {
        super(accessor, tagAnnotation.value(), null);
        this.myTextIfEmpty = tagAnnotation.textIfEmpty();
    }

    TagBinding(@NotNull MutableAccessor accessor, @NotNull String suggestedName) {
        super(accessor, suggestedName, null);
        this.myTextIfEmpty = "";
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable SerializationFilter filter) {
        Object value = this.myAccessor.read(o);
        if (value == null) {
            return null;
        }
        Element serialized = new Element(this.name);
        if (this.myBinding == null) {
            serialized.addContent(new Text(XmlSerializerImpl.convertToString(value)));
        } else {
            Object node = this.myBinding.serialize(value, serialized, filter);
            if (node != null && node != serialized) {
                Binding.addContent(serialized, node);
            }
        }
        return serialized;
    }

    @Override
    @NotNull
    public Object deserializeList(@NotNull Object context, @NotNull List<Element> elements) {
        List<Element> children2;
        if (elements.size() == 1) {
            children2 = elements.get(0).getChildren();
        } else {
            String name = elements.get(0).getName();
            children2 = new ArrayList<Element>();
            for (Element element : elements) {
                assert (element.getName().equals(name));
                children2.addAll(element.getChildren());
            }
        }
        this.deserialize(context, children2);
        return context;
    }

    @Override
    @NotNull
    public Object deserializeList2(@NotNull Object context, @NotNull List<XmlElement> elements) {
        List<XmlElement> children2;
        if (elements.size() == 1) {
            children2 = elements.get((int)0).children;
        } else {
            String name = elements.get((int)0).name;
            children2 = new ArrayList<XmlElement>();
            for (XmlElement element : elements) {
                assert (element.name.equals(name));
                children2.addAll(element.children);
            }
        }
        this.deserialize2(context, children2);
        return context;
    }

    @Override
    public boolean isMulti() {
        return this.myBinding instanceof MultiNodeBinding && ((MultiNodeBinding)this.myBinding).isMulti();
    }

    @Override
    @NotNull
    public Object deserialize(@NotNull Object context, @NotNull Element element) {
        if (this.myBinding == null) {
            String value = XmlSerializerImpl.getTextValue(element, this.myTextIfEmpty);
            XmlSerializerImpl.doSet(context, value, this.myAccessor, ClassUtil.typeToClass(this.myAccessor.getGenericType()));
        } else {
            this.deserialize(context, element.getChildren());
        }
        return context;
    }

    @Override
    @NotNull
    public Object deserialize(@NotNull Object context, @NotNull XmlElement element) {
        if (this.myBinding == null) {
            String value = element.content;
            if (value == null) {
                value = this.myTextIfEmpty;
            }
            XmlSerializerImpl.doSet(context, value, this.myAccessor, ClassUtil.typeToClass(this.myAccessor.getGenericType()));
        } else {
            this.deserialize2(context, element.children);
        }
        return context;
    }

    private void deserialize(@NotNull Object context, @NotNull List<Element> children2) {
        assert (this.myBinding != null);
        if (this.myBinding instanceof BeanBinding && !this.myAccessor.isWritable()) {
            ((BeanBinding)this.myBinding).deserializeInto(context, children2.get(0));
        } else if ((this.myBinding instanceof CollectionBinding || this.myBinding instanceof MapBinding) && !this.myAccessor.isWritable()) {
            Binding.deserializeList(this.myBinding, this.myAccessor.read(context), children2);
        } else {
            this.myAccessor.set(context, Binding.deserializeList(this.myBinding, this.myAccessor.read(context), children2));
        }
    }

    private void deserialize2(@NotNull Object context, @NotNull List<XmlElement> children2) {
        assert (this.myBinding != null);
        if (this.myBinding instanceof BeanBinding && !this.myAccessor.isWritable()) {
            ((BeanBinding)this.myBinding).deserializeInto(context, children2.get(0));
        } else if ((this.myBinding instanceof CollectionBinding || this.myBinding instanceof MapBinding) && !this.myAccessor.isWritable()) {
            Binding.deserializeList2(this.myBinding, this.myAccessor.read(context), children2);
        } else {
            this.myAccessor.set(context, Binding.deserializeList2(this.myBinding, this.myAccessor.read(context), children2));
        }
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        return element.getName().equals(this.name);
    }

    @Override
    public boolean isBoundTo(@NotNull XmlElement element) {
        return element.name.equals(this.name);
    }
}

