/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.xmlb.XIncludeException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JDOMXIncluder {
    private static final Logger LOG = Logger.getInstance(JDOMXIncluder.class);
    public static final PathResolver DEFAULT_PATH_RESOLVER = new PathResolver(){

        @Override
        @NotNull
        public URL resolvePath(@NotNull String relativePath, @Nullable URL base) throws MalformedURLException {
            return base == null ? new URL(relativePath) : new URL(base, relativePath);
        }
    };
    private final boolean myIgnoreMissing;
    private final PathResolver myPathResolver;

    private JDOMXIncluder(boolean ignoreMissing, @NotNull PathResolver pathResolver) {
        this.myIgnoreMissing = ignoreMissing;
        this.myPathResolver = pathResolver;
    }

    @NotNull
    public static List<Element> resolve(@NotNull Element original, URL base) throws XIncludeException, MalformedURLException {
        return new JDOMXIncluder(false, DEFAULT_PATH_RESOLVER).doResolve(original, base);
    }

    @NotNull
    private List<Element> doResolve(@NotNull Element original, URL base) throws XIncludeException, MalformedURLException {
        Stack bases = new Stack();
        if (base != null) {
            bases.push((Object)base);
        }
        return this.resolve(original, (Stack<URL>)bases);
    }

    private static boolean isIncludeElement(Element element) {
        return element.getName().equals("include") && element.getNamespace().equals(JDOMUtil.XINCLUDE_NAMESPACE);
    }

    @NotNull
    private List<Element> resolve(@NotNull Element original, @NotNull Stack<URL> bases) throws XIncludeException, MalformedURLException {
        if (JDOMXIncluder.isIncludeElement(original)) {
            return this.resolveXIncludeElement(original, bases);
        }
        this.resolveNonXIncludeElement(original, bases);
        return Collections.singletonList(original);
    }

    @NotNull
    private List<Element> resolveXIncludeElement(@NotNull Element element, @NotNull Stack<URL> bases) throws XIncludeException, MalformedURLException {
        String parseAttribute;
        URL base = null;
        if (!bases.isEmpty()) {
            base = (URL)bases.peek();
        }
        String href = element.getAttributeValue("href");
        assert (href != null) : "Missing href attribute";
        String baseAttribute = element.getAttributeValue("base", Namespace.XML_NAMESPACE);
        if (baseAttribute != null) {
            base = new URL(baseAttribute);
        }
        if ((parseAttribute = element.getAttributeValue("parse")) != null) {
            LOG.assertTrue(parseAttribute.equals("xml"), parseAttribute + " is not a legal value for the parse attribute");
        }
        URL remote = this.myPathResolver.resolvePath(href, base);
        assert (!bases.contains((Object)remote)) : "Circular XInclude Reference to " + remote.toExternalForm();
        Element fallbackElement = element.getChild("fallback", element.getNamespace());
        List<Element> remoteParsed = this.parseRemote(bases, remote, fallbackElement);
        if (!remoteParsed.isEmpty()) {
            remoteParsed = JDOMXIncluder.extractNeededChildren(element, remoteParsed);
        }
        for (int i = 0; i < remoteParsed.size(); ++i) {
            Element o = remoteParsed.get(i);
            if (JDOMXIncluder.isIncludeElement(o)) {
                List<Element> list = this.resolveXIncludeElement(o, bases);
                remoteParsed.addAll(i, list);
                remoteParsed.remove(i += list.size() - 1);
                continue;
            }
            this.resolveNonXIncludeElement(o, bases);
        }
        for (Content content : remoteParsed) {
            content.detach();
        }
        return remoteParsed;
    }

    @NotNull
    private static List<Element> extractNeededChildren(@NotNull Element element, @NotNull List<Element> remoteElements) {
        String xpointer = element.getAttributeValue("xpointer");
        if (xpointer == null) {
            return remoteElements;
        }
        Matcher matcher = JDOMUtil.XPOINTER_PATTERN.matcher(xpointer);
        if (!matcher.matches()) {
            throw new XIncludeException("Unsupported XPointer: " + xpointer);
        }
        String pointer = matcher.group(1);
        if (!(matcher = JDOMUtil.CHILDREN_PATTERN.matcher(pointer)).matches()) {
            throw new XIncludeException("Unsupported pointer: " + pointer);
        }
        String rootTagName = matcher.group(1);
        assert (remoteElements.size() == 1);
        Element e = remoteElements.get(0);
        if (!e.getName().equals(rootTagName)) {
            return Collections.emptyList();
        }
        String subTagName = matcher.group(2);
        if (subTagName != null) {
            e = e.getChild(subTagName.substring(1));
            assert (e != null);
        }
        return new ArrayList<Element>(e.getChildren());
    }

    @NotNull
    private List<Element> parseRemote(@NotNull Stack<URL> bases, @NotNull URL remote, @Nullable Element fallbackElement) {
        try {
            bases.push((Object)remote);
            Element root = JDOMUtil.loadResource(remote);
            List<Element> list = this.resolve(root, bases);
            return list;
        }
        catch (JDOMException e) {
            throw new XIncludeException(e);
        }
        catch (IOException e) {
            if (fallbackElement != null) {
                List<Element> list = Collections.emptyList();
                return list;
            }
            if (this.myIgnoreMissing) {
                LOG.info(remote.toExternalForm() + " include ignored: " + e.getMessage());
                List<Element> list = Collections.emptyList();
                return list;
            }
            throw new XIncludeException(e);
        }
        finally {
            bases.pop();
        }
    }

    private void resolveNonXIncludeElement(@NotNull Element original, @NotNull Stack<URL> bases) throws XIncludeException, MalformedURLException {
        List<Content> contentList = original.getContent();
        for (int i = contentList.size() - 1; i >= 0; --i) {
            Content content = contentList.get(i);
            if (!(content instanceof Element)) continue;
            Element element = (Element)content;
            if (JDOMXIncluder.isIncludeElement(element)) {
                original.setContent(i, this.resolveXIncludeElement(element, bases));
                continue;
            }
            this.resolveNonXIncludeElement(element, bases);
        }
    }

    public static interface PathResolver {
        @NotNull
        public URL resolvePath(@NotNull String var1, @Nullable URL var2) throws MalformedURLException;
    }
}

