/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.serialization.MutableAccessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.dom.XmlElement;
import com.intellij.util.xmlb.NestedBinding;
import com.intellij.util.xmlb.NotNullDeserializeBinding;
import com.intellij.util.xmlb.SerializationFilter;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CompactCollectionBinding
extends NotNullDeserializeBinding
implements NestedBinding {
    private final String name;
    private final MutableAccessor accessor;

    CompactCollectionBinding(@NotNull MutableAccessor accessor) {
        this.accessor = accessor;
        this.name = accessor.getName();
    }

    @Override
    @NotNull
    public MutableAccessor getAccessor() {
        return this.accessor;
    }

    @Override
    @NotNull
    public Object serialize(@NotNull Object o, @Nullable Object context, @Nullable SerializationFilter filter) {
        Element result = new Element(this.name);
        List list = (List)o;
        if (list.isEmpty()) {
            return result;
        }
        for (String item : list) {
            result.addContent(new Element("item").setAttribute("value", JDOMUtil.removeControlChars(item)));
        }
        return result;
    }

    @Override
    @NotNull
    public Object deserialize(Object context, @NotNull Element element) {
        List list;
        block4: {
            block3: {
                list = (List)context;
                list.clear();
                if (!element.getName().equals(this.name)) break block3;
                for (Element item : element.getChildren("item")) {
                    ContainerUtil.addIfNotNull(list, item.getAttributeValue("value"));
                }
                break block4;
            }
            Element value = element.getChild("value");
            if (value != null) {
                value = value.getChild("list");
            }
            if (value == null) break block4;
            for (Element item : value.getChildren("item")) {
                ContainerUtil.addIfNotNull(list, item.getAttributeValue("itemvalue"));
            }
        }
        return list;
    }

    @Override
    @NotNull
    public Object deserialize(Object context, @NotNull XmlElement element) {
        List list;
        block4: {
            block3: {
                list = (List)context;
                list.clear();
                if (!element.name.equals(this.name)) break block3;
                for (XmlElement item : element.children) {
                    String v;
                    if (!item.name.equals("item") || (v = item.attributes.get("value")) == null) continue;
                    list.add(v);
                }
                break block4;
            }
            XmlElement value = element.getChild("value");
            if (value != null) {
                value = value.getChild("list");
            }
            if (value == null) break block4;
            for (XmlElement item : value.children) {
                String v;
                if (!item.name.equals("item") || (v = item.getAttributeValue("itemvalue")) == null) continue;
                list.add(v);
            }
        }
        return list;
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        String elementName = element.getName();
        if (this.isNameEqual(elementName)) {
            return true;
        }
        if (elementName.equals("option")) {
            return this.isNameEqual(element.getAttributeValue("name"));
        }
        return false;
    }

    @Override
    public boolean isBoundTo(@NotNull XmlElement element) {
        String elementName = element.name;
        if (this.isNameEqual(elementName)) {
            return true;
        }
        if (elementName.equals("option")) {
            return this.isNameEqual(element.getAttributeValue("name"));
        }
        return false;
    }

    private boolean isNameEqual(@Nullable String value) {
        if (value == null) {
            return false;
        }
        if (value.equals(this.name)) {
            return true;
        }
        if (value.length() == this.name.length() + 2 && value.startsWith("my")) {
            return Character.isUpperCase(value.charAt(2)) && value.regionMatches(true, 2, this.name, 0, this.name.length());
        }
        return false;
    }
}

