/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xml.dom.XmlElement;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.Serializer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Binding {
    @Nullable
    public Object serialize(@NotNull Object var1, @Nullable Object var2, @Nullable SerializationFilter var3);

    public boolean isBoundTo(@NotNull Element var1);

    public boolean isBoundTo(@NotNull XmlElement var1);

    default public void init(@NotNull Type originalType, @NotNull Serializer serializer) {
    }

    @Nullable
    public static Object deserializeList(@NotNull Binding binding, @Nullable Object context, @NotNull List<Element> nodes) {
        if (binding instanceof MultiNodeBinding) {
            return ((MultiNodeBinding)binding).deserializeList(context, nodes);
        }
        if (nodes.size() == 1) {
            return binding.deserializeUnsafe(context, nodes.get(0));
        }
        if (nodes.isEmpty()) {
            return null;
        }
        throw new AssertionError((Object)("Duplicate data for " + binding + " will be ignored"));
    }

    @Nullable
    public static Object deserializeList2(@NotNull Binding binding, @Nullable Object context, @NotNull List<XmlElement> nodes) {
        if (binding instanceof MultiNodeBinding) {
            return ((MultiNodeBinding)binding).deserializeList2(context, nodes);
        }
        if (nodes.size() == 1) {
            return binding.deserializeUnsafe(context, nodes.get(0));
        }
        if (nodes.isEmpty()) {
            return null;
        }
        throw new AssertionError((Object)("Duplicate data for " + binding + " will be ignored"));
    }

    public Object deserializeUnsafe(Object var1, @NotNull Element var2);

    public Object deserializeUnsafe(Object var1, @NotNull XmlElement var2);

    public static void addContent(@NotNull Element targetElement, Object node) {
        if (node instanceof Content) {
            targetElement.addContent((Content)node);
        } else if (node instanceof List) {
            targetElement.addContent((Collection)((List)node));
        } else {
            throw new IllegalArgumentException("Wrong node: " + node);
        }
    }
}

