/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.serialization.MutableAccessor;
import com.intellij.serialization.PropertyCollector;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.xml.dom.XmlElement;
import com.intellij.util.xmlb.AccessorBindingWrapper;
import com.intellij.util.xmlb.AttributeBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.CompactCollectionBinding;
import com.intellij.util.xmlb.Converter;
import com.intellij.util.xmlb.JDOMElementBinding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.NestedBinding;
import com.intellij.util.xmlb.NotNullDeserializeBinding;
import com.intellij.util.xmlb.OptionTagBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.Serializer;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import com.intellij.util.xmlb.TagBinding;
import com.intellij.util.xmlb.TextBinding;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.CollectionBean;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Text;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.util.xmlb.annotations.XMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class BeanBinding
extends NotNullDeserializeBinding {
    private static final XmlSerializerPropertyCollector PROPERTY_COLLECTOR = new XmlSerializerPropertyCollector(new MyPropertyCollectorConfiguration());
    private final String myTagName;
    protected NestedBinding[] bindings;
    protected final Class<?> myBeanClass;
    ThreeState compareByFields = ThreeState.UNSURE;

    public BeanBinding(@NotNull Class<?> beanClass) {
        assert (!beanClass.isArray()) : "Bean is an array: " + beanClass;
        assert (!beanClass.isPrimitive()) : "Bean is primitive type: " + beanClass;
        this.myBeanClass = beanClass;
        this.myTagName = BeanBinding.getTagName(beanClass);
        assert (!StringUtilRt.isEmptyOrSpaces((CharSequence)this.myTagName)) : "Bean name is empty: " + beanClass;
    }

    @Override
    public final synchronized void init(@NotNull Type originalType, @NotNull Serializer serializer) {
        assert (this.bindings == null);
        Property classAnnotation = this.myBeanClass.getAnnotation(Property.class);
        List<MutableAccessor> accessors = BeanBinding.getAccessors(this.myBeanClass);
        this.bindings = new NestedBinding[accessors.size()];
        int size = accessors.size();
        for (int i = 0; i < size; ++i) {
            NestedBinding binding = BeanBinding.createBinding(accessors.get(i), serializer, classAnnotation == null ? Property.Style.OPTION_TAG : classAnnotation.style());
            binding.init(originalType, serializer);
            this.bindings[i] = binding;
        }
    }

    @Override
    @Nullable
    public final Object serialize(@NotNull Object o, @Nullable Object context, @Nullable SerializationFilter filter) {
        return this.serializeInto(o, context == null ? null : new Element(this.myTagName), filter);
    }

    public final Element serialize(@NotNull Object object, boolean createElementIfEmpty, @Nullable SerializationFilter filter) {
        return this.serializeInto(object, createElementIfEmpty ? new Element(this.myTagName) : null, filter);
    }

    @Nullable
    public Element serializeInto(@NotNull Object o, @Nullable Element element, @Nullable SerializationFilter filter) {
        for (NestedBinding binding : this.bindings) {
            if (o instanceof SerializationFilter && !((SerializationFilter)o).accepts(binding.getAccessor(), o)) continue;
            element = this.serializePropertyInto(binding, o, element, filter, true);
        }
        return element;
    }

    @Nullable
    protected final Element serializePropertyInto(@NotNull NestedBinding binding, @NotNull Object o, @Nullable Element element, @Nullable SerializationFilter filter, boolean isFilterPropertyItself) {
        Object node;
        MutableAccessor accessor = binding.getAccessor();
        Property property = accessor.getAnnotation(Property.class);
        if (property == null || !property.alwaysWrite()) {
            if (filter != null && isFilterPropertyItself && (filter instanceof SkipDefaultsSerializationFilter ? ((SkipDefaultsSerializationFilter)filter).equal(binding, o) : !filter.accepts(accessor, o))) {
                return element;
            }
            if (property != null && property.filter() != SerializationFilter.class && !ReflectionUtil.newInstance(property.filter()).accepts(accessor, o)) {
                return element;
            }
        }
        if (element == null) {
            element = new Element(this.myTagName);
        }
        if ((node = binding.serialize(o, element, filter)) != null) {
            if (node instanceof org.jdom.Attribute) {
                element.setAttribute((org.jdom.Attribute)node);
            } else {
                Binding.addContent(element, node);
            }
        }
        return element;
    }

    @Override
    @NotNull
    public final Object deserialize(@Nullable Object context, @NotNull Element element) {
        Object instance = this.newInstance();
        this.deserializeInto(instance, element);
        return instance;
    }

    @Override
    @NotNull
    public final Object deserialize(@Nullable Object context, @NotNull XmlElement element) {
        Object instance = this.newInstance();
        this.deserializeInto(instance, element);
        return instance;
    }

    @NotNull
    protected Object newInstance() {
        return ReflectionUtil.newInstance(this.myBeanClass, false);
    }

    final boolean equalByFields(@NotNull Object currentValue, @NotNull Object defaultValue, @NotNull SkipDefaultsSerializationFilter filter) {
        for (NestedBinding binding : this.bindings) {
            MutableAccessor accessor = binding.getAccessor();
            if (filter.equal(binding, accessor.read(currentValue), accessor.read(defaultValue))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final Object2FloatMap<String> computeBindingWeights(@NotNull Set<String> accessorNameTracker) {
        Object2FloatOpenHashMap weights = new Object2FloatOpenHashMap(accessorNameTracker.size());
        float weight = 0.0f;
        float step = (float)this.bindings.length / (float)accessorNameTracker.size();
        for (String name : accessorNameTracker) {
            weights.put((Object)name, weight);
            weight += step;
        }
        weight = 0.0f;
        for (NestedBinding binding : this.bindings) {
            String name = binding.getAccessor().getName();
            if (!weights.containsKey((Object)name)) {
                weights.put((Object)name, weight);
            }
            weight += 1.0f;
        }
        return weights;
    }

    public final void sortBindings(@NotNull Object2FloatMap<? super String> weights) {
        Arrays.sort(this.bindings, (o1, o2) -> {
            String n1 = o1.getAccessor().getName();
            String n2 = o2.getAccessor().getName();
            float w1 = weights.getFloat((Object)n1);
            float w2 = weights.getFloat((Object)n2);
            return (int)(w1 - w2);
        });
    }

    public final void deserializeInto(@NotNull Object result, @NotNull Element element) {
        this.deserializeInto(result, element, null);
    }

    public final void deserializeInto(@NotNull Object result, @NotNull Element element, @Nullable Set<String> accessorNameTracker) {
        block0: for (org.jdom.Attribute attribute : element.getAttributes()) {
            if (!StringUtilRt.isEmpty((CharSequence)attribute.getNamespaceURI())) continue;
            for (NestedBinding binding : this.bindings) {
                if (!(binding instanceof AttributeBinding) || !((AttributeBinding)binding).name.equals(attribute.getName())) continue;
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                ((AttributeBinding)binding).set(result, attribute.getValue());
                continue block0;
            }
        }
        LinkedHashMap<NestedBinding, List> data = null;
        block2: for (Content content : element.getContent()) {
            if (content instanceof Comment) continue;
            for (NestedBinding binding : this.bindings) {
                if (content instanceof org.jdom.Text) {
                    if (!(binding instanceof TextBinding)) continue;
                    ((TextBinding)binding).set(result, content.getValue());
                    continue;
                }
                Element child = (Element)content;
                if (!binding.isBoundTo(child)) continue;
                if (binding instanceof MultiNodeBinding && ((MultiNodeBinding)((Object)binding)).isMulti()) {
                    if (data == null) {
                        data = new LinkedHashMap<NestedBinding, List>();
                    }
                    data.computeIfAbsent(binding, it -> new ArrayList()).add(child);
                    continue block2;
                }
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                binding.deserializeUnsafe(result, child);
                continue block2;
            }
        }
        for (NestedBinding binding : this.bindings) {
            if (!(binding instanceof AccessorBindingWrapper) || !((AccessorBindingWrapper)binding).isFlat) continue;
            binding.deserializeUnsafe(result, element);
        }
        if (data != null) {
            for (NestedBinding binding : data.keySet()) {
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                ((MultiNodeBinding)((Object)binding)).deserializeList(result, (List)data.get(binding));
            }
        }
    }

    public final void deserializeInto(@NotNull Object result, @NotNull XmlElement element) {
        int attributeBindingCount = 0;
        for (NestedBinding binding : this.bindings) {
            if (binding instanceof AttributeBinding) {
                ++attributeBindingCount;
                AttributeBinding attributeBinding = (AttributeBinding)binding;
                String value = element.attributes.get(attributeBinding.name);
                if (value == null) continue;
                attributeBinding.set(result, value);
                continue;
            }
            if (element.content == null || !(binding instanceof TextBinding)) continue;
            ((TextBinding)binding).set(result, element.content);
        }
        if (attributeBindingCount == this.bindings.length) {
            return;
        }
        LinkedHashMap<NestedBinding, List> data = null;
        block1: for (XmlElement child : element.children) {
            for (NestedBinding binding : this.bindings) {
                if (binding instanceof AttributeBinding || binding instanceof TextBinding || !binding.isBoundTo(child)) continue;
                if (binding instanceof MultiNodeBinding && ((MultiNodeBinding)((Object)binding)).isMulti()) {
                    if (data == null) {
                        data = new LinkedHashMap<NestedBinding, List>();
                    }
                    data.computeIfAbsent(binding, it -> new ArrayList()).add(child);
                    continue block1;
                }
                binding.deserializeUnsafe(result, child);
                continue block1;
            }
        }
        for (NestedBinding binding : this.bindings) {
            if (!(binding instanceof AccessorBindingWrapper) || !((AccessorBindingWrapper)binding).isFlat) continue;
            binding.deserializeUnsafe(result, element);
        }
        if (data != null) {
            for (NestedBinding binding : data.keySet()) {
                ((MultiNodeBinding)((Object)binding)).deserializeList2(result, (List)data.get(binding));
            }
        }
    }

    @Override
    public final boolean isBoundTo(@NotNull Element element) {
        return element.getName().equals(this.myTagName);
    }

    @Override
    public final boolean isBoundTo(@NotNull XmlElement element) {
        return element.name.equals(this.myTagName);
    }

    @NotNull
    private static String getTagName(@NotNull Class<?> aClass) {
        int lastIndexOf;
        for (Class<?> c = aClass; c != null; c = c.getSuperclass()) {
            String name = BeanBinding.getTagNameFromAnnotation(c);
            if (name == null) continue;
            return name;
        }
        String name = aClass.getSimpleName();
        if (name.isEmpty()) {
            name = aClass.getSuperclass().getSimpleName();
        }
        if ((lastIndexOf = name.lastIndexOf(36)) > 0 && name.length() > lastIndexOf + 1) {
            return name.substring(lastIndexOf + 1);
        }
        return name;
    }

    @Nullable
    private static String getTagNameFromAnnotation(@NotNull Class<?> aClass) {
        Tag tag = aClass.getAnnotation(Tag.class);
        return tag != null && !tag.value().isEmpty() ? tag.value() : null;
    }

    @NotNull
    public static List<MutableAccessor> getAccessors(@NotNull Class<?> aClass) {
        return PROPERTY_COLLECTOR.collect(aClass);
    }

    private static boolean isAssertBindings(@NotNull Class<?> aClass) {
        do {
            Property property;
            if ((property = aClass.getAnnotation(Property.class)) == null || property.assertIfNoBindings()) continue;
            return true;
        } while ((aClass = aClass.getSuperclass()) != null);
        return false;
    }

    public String toString() {
        return "BeanBinding[" + this.myBeanClass.getName() + ", tagName=" + this.myTagName + "]";
    }

    @NotNull
    private static NestedBinding createBinding(@NotNull MutableAccessor accessor, @NotNull Serializer serializer, @NotNull Property.Style propertyStyle) {
        XMap xMap;
        Attribute attribute = accessor.getAnnotation(Attribute.class);
        if (attribute != null) {
            return new AttributeBinding(accessor, attribute);
        }
        Text text = accessor.getAnnotation(Text.class);
        if (text != null) {
            return new TextBinding(accessor);
        }
        OptionTag optionTag = accessor.getAnnotation(OptionTag.class);
        if (optionTag != null && optionTag.converter() != Converter.class) {
            return new OptionTagBinding(accessor, optionTag);
        }
        Binding binding = serializer.getBinding(accessor);
        if (binding instanceof JDOMElementBinding) {
            return (JDOMElementBinding)binding;
        }
        Tag tag = accessor.getAnnotation(Tag.class);
        if (tag != null) {
            return new TagBinding(accessor, tag);
        }
        if (binding instanceof CompactCollectionBinding) {
            return new AccessorBindingWrapper(accessor, binding, false, Property.Style.OPTION_TAG);
        }
        boolean surroundWithTag = true;
        boolean inline = false;
        Property property = accessor.getAnnotation(Property.class);
        if (property != null) {
            surroundWithTag = property.surroundWithTag();
            inline = property.flat();
        }
        if (!surroundWithTag || inline) {
            if (inline && !(binding instanceof BeanBinding)) {
                throw new XmlSerializationException("inline supported only for BeanBinding: " + accessor);
            }
            if (binding == null || binding instanceof TextBinding) {
                throw new XmlSerializationException("Text-serializable properties can't be serialized without surrounding tags: " + accessor);
            }
            return new AccessorBindingWrapper(accessor, binding, inline, property.style());
        }
        XCollection xCollection = accessor.getAnnotation(XCollection.class);
        if (!(xCollection == null || xCollection.propertyElementName().isEmpty() && xCollection.style() != XCollection.Style.v2)) {
            return new TagBinding(accessor, xCollection.propertyElementName());
        }
        if (optionTag == null && (xMap = accessor.getAnnotation(XMap.class)) != null) {
            return new TagBinding(accessor, xMap.propertyElementName());
        }
        if (propertyStyle == Property.Style.ATTRIBUTE) {
            return new AttributeBinding(accessor, null);
        }
        return new OptionTagBinding(accessor, optionTag);
    }

    private static final class MyPropertyCollectorConfiguration
    extends PropertyCollector.Configuration {
        private MyPropertyCollectorConfiguration() {
            super(true, false, false);
        }

        @Override
        public boolean isAnnotatedAsTransient(@NotNull AnnotatedElement element) {
            return element.isAnnotationPresent(Transient.class);
        }

        @Override
        public boolean hasStoreAnnotations(@NotNull AccessibleObject element) {
            return element.isAnnotationPresent(OptionTag.class) || element.isAnnotationPresent(Tag.class) || element.isAnnotationPresent(Attribute.class) || element.isAnnotationPresent(Property.class) || element.isAnnotationPresent(Text.class) || element.isAnnotationPresent(CollectionBean.class) || element.isAnnotationPresent(MapAnnotation.class) || element.isAnnotationPresent(XMap.class) || element.isAnnotationPresent(XCollection.class) || element.isAnnotationPresent(AbstractCollection.class);
        }
    }

    private static final class XmlSerializerPropertyCollectorListClassValue
    extends ClassValue<List<MutableAccessor>> {
        @NotNull
        private final PropertyCollector.Configuration configuration;

        private XmlSerializerPropertyCollectorListClassValue(@NotNull PropertyCollector.Configuration configuration) {
            this.configuration = configuration;
        }

        @Override
        protected List<MutableAccessor> computeValue(Class<?> aClass) {
            List<MutableAccessor> result = PropertyCollector.doCollect(aClass, this.configuration, null);
            if (result.isEmpty() && !BeanBinding.isAssertBindings(aClass)) {
                if (JDOMExternalizable.class.isAssignableFrom(aClass)) {
                    NotNullDeserializeBinding.LOG.error("Do not compute bindings for JDOMExternalizable: " + aClass.getName());
                } else if (aClass.isEnum()) {
                    NotNullDeserializeBinding.LOG.error("Do not compute bindings for enum: " + aClass.getName());
                } else if (aClass == String.class) {
                    NotNullDeserializeBinding.LOG.error("Do not compute bindings for String");
                }
                NotNullDeserializeBinding.LOG.warn("no accessors for " + aClass.getName());
            }
            return result;
        }
    }

    private static final class XmlSerializerPropertyCollector
    extends PropertyCollector {
        private final ClassValue<List<MutableAccessor>> accessorCache;

        XmlSerializerPropertyCollector(@NotNull PropertyCollector.Configuration configuration) {
            super(configuration);
            this.accessorCache = new XmlSerializerPropertyCollectorListClassValue(configuration);
        }

        @Override
        @NotNull
        public List<MutableAccessor> collect(@NotNull Class<?> aClass) {
            return this.accessorCache.get(aClass);
        }
    }
}

