/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.serialization.ClassUtil;
import com.intellij.serialization.MutableAccessor;
import com.intellij.util.xml.dom.XmlElement;
import com.intellij.util.xmlb.BasePrimitiveBinding;
import com.intellij.util.xmlb.Converter;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AttributeBinding
extends BasePrimitiveBinding {
    private final Class<?> valueClass;

    AttributeBinding(@NotNull MutableAccessor accessor, @Nullable Attribute attribute) {
        super(accessor, attribute == null ? null : attribute.value(), attribute == null ? null : attribute.converter());
        this.valueClass = ClassUtil.typeToClass(accessor.getGenericType());
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable SerializationFilter filter) {
        String stringValue;
        Object value = this.myAccessor.read(o);
        if (value == null) {
            return null;
        }
        Converter<Object> converter = this.getConverter();
        if (converter == null) {
            stringValue = XmlSerializerImpl.convertToString(value);
        } else {
            stringValue = converter.toString(value);
            if (stringValue == null) {
                return null;
            }
        }
        return new org.jdom.Attribute(this.name, stringValue);
    }

    @Override
    @NotNull
    public Object deserialize(@NotNull Object context, @NotNull Element element) {
        return context;
    }

    @Override
    @NotNull
    public Object deserialize(@NotNull Object context, @NotNull XmlElement element) {
        return context;
    }

    void set(@NotNull Object host, @NotNull String value) {
        if (this.myConverter == null) {
            XmlSerializerImpl.doSet(host, value, this.myAccessor, this.valueClass);
        } else {
            this.myAccessor.set(host, this.myConverter.fromString(value));
        }
    }

    public String toString() {
        return "AttributeBinding[" + this.name + "]";
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        return false;
    }

    @Override
    public boolean isBoundTo(@NotNull XmlElement element) {
        return false;
    }
}

