/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.serialization.MutableAccessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.dom.XmlElement;
import com.intellij.util.xmlb.AbstractCollectionBinding;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ArrayBinding
extends AbstractCollectionBinding {
    ArrayBinding(@NotNull Class<?> valueClass, @Nullable MutableAccessor accessor) {
        super(valueClass.getComponentType(), accessor);
    }

    @Override
    @NotNull
    protected String getCollectionTagName(@Nullable Object target) {
        return "array";
    }

    @Override
    @NotNull
    protected Object doDeserializeList(@Nullable Object context, @NotNull List<Element> elements) {
        int size = elements.size();
        T[] result = ArrayUtil.newArray(this.itemType, size);
        for (int i = 0; i < size; ++i) {
            result[i] = this.deserializeItem(elements.get(i), context);
        }
        return result;
    }

    @Override
    @NotNull
    protected Object doDeserializeList2(@Nullable Object context, @NotNull List<XmlElement> elements) {
        int size = elements.size();
        T[] result = ArrayUtil.newArray(this.itemType, size);
        for (int i = 0; i < size; ++i) {
            result[i] = this.deserializeItem(elements.get(i), context);
        }
        return result;
    }

    @NotNull
    Collection<Object> getIterable(@NotNull Object o) {
        Object[] list = (Object[])o;
        return list.length == 0 ? Collections.emptyList() : Arrays.asList(list);
    }
}

