/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.serialization.MutableAccessor;
import com.intellij.util.xml.dom.XmlElement;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MapBinding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.NestedBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.annotations.Property;
import java.awt.Rectangle;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AccessorBindingWrapper
implements MultiNodeBinding,
NestedBinding {
    private final Binding binding;
    private final MutableAccessor accessor;
    final boolean isFlat;
    private final Property.Style beanStyle;

    AccessorBindingWrapper(@NotNull MutableAccessor accessor, @NotNull Binding binding, boolean isFlat, Property.Style beanStyle) {
        this.accessor = accessor;
        this.binding = binding;
        this.isFlat = isFlat;
        this.beanStyle = beanStyle;
    }

    @Override
    @NotNull
    public MutableAccessor getAccessor() {
        return this.accessor;
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable Object context, @Nullable SerializationFilter filter) {
        Object value = this.accessor.read(o);
        if (value == null) {
            return null;
        }
        if (this.isFlat) {
            Element element = (Element)context;
            if (this.beanStyle == Property.Style.ATTRIBUTE && value instanceof Rectangle) {
                Rectangle bounds = (Rectangle)value;
                assert (element != null);
                element.setAttribute("x", Integer.toString(bounds.x));
                element.setAttribute("y", Integer.toString(bounds.y));
                element.setAttribute("width", Integer.toString(bounds.width));
                element.setAttribute("height", Integer.toString(bounds.height));
            } else {
                ((BeanBinding)this.binding).serializeInto(value, element, filter);
            }
            return null;
        }
        return this.binding.serialize(value, context, filter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object deserializeUnsafe(Object context, @NotNull Element element) {
        Object currentValue = this.accessor.read(context);
        if (this.binding instanceof BeanBinding && !this.accessor.isWritable()) {
            ((BeanBinding)this.binding).deserializeInto(currentValue, element);
            return context;
        } else {
            Object deserializedValue;
            if (this.beanStyle == Property.Style.ATTRIBUTE && this.binding instanceof BeanBinding && ((BeanBinding)this.binding).myBeanClass == Rectangle.class) {
                String xA = element.getAttributeValue("x");
                String yA = element.getAttributeValue("y");
                String wA = element.getAttributeValue("width");
                String hA = element.getAttributeValue("height");
                if (xA == null || yA == null || wA == null || hA == null) return context;
                int x = StringUtilRt.parseInt((String)xA, (int)0);
                int y = StringUtilRt.parseInt((String)yA, (int)0);
                int h = StringUtilRt.parseInt((String)hA, (int)0);
                int w = StringUtilRt.parseInt((String)wA, (int)0);
                deserializedValue = new Rectangle(x, y, w, h);
            } else {
                deserializedValue = this.binding.deserializeUnsafe(currentValue, element);
            }
            if (currentValue == deserializedValue) return context;
            this.accessor.set(context, deserializedValue);
        }
        return context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object deserializeUnsafe(Object context, @NotNull XmlElement element) {
        Object currentValue = this.accessor.read(context);
        if (this.binding instanceof BeanBinding && !this.accessor.isWritable()) {
            ((BeanBinding)this.binding).deserializeInto(currentValue, element);
            return context;
        } else {
            Object deserializedValue;
            if (this.beanStyle == Property.Style.ATTRIBUTE && this.binding instanceof BeanBinding && ((BeanBinding)this.binding).myBeanClass == Rectangle.class) {
                String xA = element.getAttributeValue("x");
                String yA = element.getAttributeValue("y");
                String wA = element.getAttributeValue("width");
                String hA = element.getAttributeValue("height");
                if (xA == null || yA == null || wA == null || hA == null) return context;
                int x = StringUtilRt.parseInt((String)xA, (int)0);
                int y = StringUtilRt.parseInt((String)yA, (int)0);
                int h = StringUtilRt.parseInt((String)hA, (int)0);
                int w = StringUtilRt.parseInt((String)wA, (int)0);
                deserializedValue = new Rectangle(x, y, w, h);
            } else {
                deserializedValue = this.binding.deserializeUnsafe(currentValue, element);
            }
            if (currentValue == deserializedValue) return context;
            this.accessor.set(context, deserializedValue);
        }
        return context;
    }

    @Override
    @NotNull
    public Object deserializeList(@NotNull Object context, @NotNull List<Element> elements) {
        Object currentValue = this.accessor.read(context);
        if (this.binding instanceof BeanBinding && !this.accessor.isWritable()) {
            ((BeanBinding)this.binding).deserializeInto(currentValue, elements.get(0));
        } else {
            Object deserializedValue = Binding.deserializeList(this.binding, currentValue, elements);
            if (currentValue != deserializedValue) {
                this.accessor.set(context, deserializedValue);
            }
        }
        return context;
    }

    @Override
    @NotNull
    public Object deserializeList2(@NotNull Object context, @NotNull List<XmlElement> elements) {
        Object currentValue = this.accessor.read(context);
        if (this.binding instanceof BeanBinding && !this.accessor.isWritable()) {
            ((BeanBinding)this.binding).deserializeInto(currentValue, elements.get(0));
        } else {
            Object deserializedValue = Binding.deserializeList2(this.binding, currentValue, elements);
            if (currentValue != deserializedValue) {
                this.accessor.set(context, deserializedValue);
            }
        }
        return context;
    }

    @Override
    public boolean isMulti() {
        return this.binding instanceof MultiNodeBinding && ((MultiNodeBinding)this.binding).isMulti();
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (this.binding instanceof MapBinding) {
            return ((MapBinding)this.binding).isBoundToWithoutProperty(element.getName());
        }
        return this.binding.isBoundTo(element);
    }

    @Override
    public boolean isBoundTo(@NotNull XmlElement element) {
        if (this.binding instanceof MapBinding) {
            return ((MapBinding)this.binding).isBoundToWithoutProperty(element.name);
        }
        return this.binding.isBoundTo(element);
    }

    public String toString() {
        return this.binding.toString();
    }
}

