/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.ReflectionUtil;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class EdtInvocationManager {
    private static final AtomicReference<EdtInvocationManager> ourInstance = new AtomicReference();
    private static MethodHandle dispatchEventMethod;

    @TestOnly
    public static void dispatchAllInvocationEvents() {
        AWTEvent event;
        assert (EdtInvocationManager.getInstance().isEventDispatchThread()) : Thread.currentThread() + "; EDT: " + EdtInvocationManager.getEventQueueThread();
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        MethodHandle dispatchEventMethod = EdtInvocationManager.dispatchEventMethod;
        if (dispatchEventMethod == null) {
            try {
                Method method = EventQueue.class.getDeclaredMethod("dispatchEvent", AWTEvent.class);
                method.setAccessible(true);
                dispatchEventMethod = MethodHandles.lookup().unreflect(method);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new RuntimeException();
            }
            EdtInvocationManager.dispatchEventMethod = dispatchEventMethod;
        }
        boolean threadsDumped = false;
        int i = 1;
        while ((event = eventQueue.peekEvent()) != null) {
            try {
                event = eventQueue.getNextEvent();
                if (event instanceof InvocationEvent) {
                    dispatchEventMethod.bindTo(eventQueue).invoke(event);
                }
            }
            catch (Throwable e) {
                ExceptionUtilRt.rethrowUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
            if (i % 10000 == 0) {
                System.out.println("Suspiciously many (" + i + ") AWT events, last dispatched " + event);
                if (!threadsDumped) {
                    threadsDumped = true;
                    try {
                        Object application = ReflectionUtil.getMethod(Class.forName("com.intellij.openapi.application.ApplicationManager"), "getApplication", new Class[0]).invoke(null, new Object[0]);
                        System.err.println("Application=" + application + "\n" + ThreadDumper.dumpThreadsToString());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            ++i;
        }
    }

    @NotNull
    private static Thread getEventQueueThread() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        try {
            Method method = ReflectionUtil.getDeclaredMethod(EventQueue.class, "getDispatchThread", new Class[0]);
            return (Thread)method.invoke((Object)eventQueue, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable) {
        EdtInvocationManager edtInvocationManager = EdtInvocationManager.getInstance();
        if (edtInvocationManager.isEventDispatchThread()) {
            runnable.run();
        } else {
            edtInvocationManager.invokeLater(runnable);
        }
    }

    public abstract boolean isEventDispatchThread();

    public abstract void invokeLater(@NotNull Runnable var1);

    public abstract void invokeAndWait(@NotNull Runnable var1) throws InvocationTargetException, InterruptedException;

    @NotNull
    public static EdtInvocationManager getInstance() {
        EdtInvocationManager result = ourInstance.get();
        if (result == null && !ourInstance.compareAndSet(null, result = new SwingEdtInvocationManager())) {
            result = ourInstance.get();
        }
        return result;
    }

    @Nullable
    public static EdtInvocationManager setEdtInvocationManager(@NotNull EdtInvocationManager edtInvocationManager) {
        return ourInstance.getAndSet(edtInvocationManager);
    }

    @ApiStatus.Internal
    public static void restoreEdtInvocationManager(@NotNull EdtInvocationManager current, @Nullable EdtInvocationManager old) {
        ourInstance.compareAndSet(current, old);
    }

    public static void invokeAndWaitIfNeeded(@NotNull Runnable runnable) {
        EdtInvocationManager manager = EdtInvocationManager.getInstance();
        if (manager.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                manager.invokeAndWait(runnable);
            }
            catch (Exception e) {
                Logger.getInstance(EdtInvocationManager.class).error(e);
            }
        }
    }

    public static class SwingEdtInvocationManager
    extends EdtInvocationManager {
        @Override
        public boolean isEventDispatchThread() {
            return EventQueue.isDispatchThread();
        }

        @Override
        public void invokeLater(@NotNull Runnable task) {
            EventQueue.invokeLater(task);
        }

        @Override
        public void invokeAndWait(@NotNull Runnable task) throws InvocationTargetException, InterruptedException {
            EventQueue.invokeAndWait(task);
        }
    }
}

