/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import java.awt.EventQueue;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class EDT {
    private static Thread myEventDispatchThread;

    private EDT() {
    }

    @ApiStatus.Internal
    public static void updateEdt() {
        if (myEventDispatchThread != Thread.currentThread()) {
            myEventDispatchThread = Thread.currentThread();
        }
    }

    @ApiStatus.Internal
    public static boolean isEdt(@NotNull Thread thread) {
        return thread == myEventDispatchThread;
    }

    @ApiStatus.Internal
    @NotNull
    public static Thread getEventDispatchThread() {
        return myEventDispatchThread;
    }

    public static boolean isCurrentThreadEdt() {
        return myEventDispatchThread == null ? EventQueue.isDispatchThread() : EDT.isEdt(Thread.currentThread());
    }

    public static void assertIsEdt() {
        if (!EDT.isCurrentThreadEdt()) {
            Logger.getInstance(EDT.class).error("Assert: must be called on EDT");
        }
    }
}

