/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UniqueNameGenerator
implements Condition<String> {
    private final Set<String> myExistingNames = new HashSet<String>();

    public <T> UniqueNameGenerator(@NotNull Collection<? extends T> elements, @Nullable Function<? super T, String> namer) {
        for (T t : elements) {
            this.addExistingName(namer != null ? StringUtil.notNullize((String)namer.fun(t)) : t.toString());
        }
    }

    public UniqueNameGenerator() {
    }

    public final boolean value(@NotNull String candidate) {
        return this.isUnique(candidate);
    }

    public final boolean isUnique(@NotNull String candidate) {
        return !this.myExistingNames.contains(candidate);
    }

    public final boolean isUnique(@NotNull String name, @NotNull String prefix, @NotNull String suffix) {
        return this.value(prefix + name + suffix);
    }

    @NlsSafe
    @NotNull
    public static String generateUniqueName(@NotNull String defaultName, @NotNull Collection<String> existingNames) {
        return UniqueNameGenerator.generateUniqueName(defaultName, "", "", existingNames);
    }

    @NlsSafe
    @NotNull
    public static String generateUniqueName(@NotNull String defaultName, @NotNull String prefix, @NotNull String suffix, @NotNull Collection<String> existingNames) {
        return UniqueNameGenerator.generateUniqueName(defaultName, prefix, suffix, (Condition<? super String>)((Condition)s -> !existingNames.contains(s)));
    }

    @NlsSafe
    @NotNull
    public static String generateUniqueName(@NotNull String defaultName, @NotNull Condition<? super String> validator) {
        return UniqueNameGenerator.generateUniqueName(defaultName, "", "", validator);
    }

    @NlsSafe
    @NotNull
    public static String generateUniqueName(@NotNull String defaultName, @NotNull String prefix, @NotNull String suffix, @NotNull Condition<? super String> validator) {
        return UniqueNameGenerator.generateUniqueName(defaultName, prefix, suffix, "", "", validator);
    }

    @NlsSafe
    @NotNull
    public static String generateUniqueName(@NotNull String defaultName, @NotNull String prefix, @NotNull String suffix, @NotNull String beforeNumber, @NotNull String afterNumber, @NotNull Condition<? super String> validator) {
        String defaultFullName = (prefix + defaultName + suffix).trim();
        if (validator.value((Object)defaultFullName)) {
            return defaultFullName;
        }
        int i = 2;
        String fullName;
        while (!validator.value((Object)(fullName = (prefix + defaultName + beforeNumber + i + afterNumber + suffix).trim()))) {
            ++i;
        }
        return fullName;
    }

    @NlsSafe
    @NotNull
    public String generateUniqueName(@NotNull String defaultName, @NotNull String prefix, @NotNull String suffix) {
        return this.generateUniqueName(defaultName, prefix, suffix, "", "");
    }

    @NlsSafe
    @NotNull
    public String generateUniqueName(@NotNull String defaultName, @NotNull String prefix, @NotNull String suffix, @NotNull String beforeNumber, @NotNull String afterNumber) {
        String result = UniqueNameGenerator.generateUniqueName(defaultName, prefix, suffix, beforeNumber, afterNumber, this);
        this.addExistingName(result);
        return result;
    }

    public void addExistingName(@NotNull String result) {
        this.myExistingNames.add(result);
    }

    @NlsSafe
    @NotNull
    public String generateUniqueName(@NotNull String defaultName) {
        return this.generateUniqueName(defaultName, "", "");
    }
}

