/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class StringOperation {
    @NotNull
    private final TextRange myRange;
    @NotNull
    private final CharSequence myReplacement;
    private static final Comparator<StringOperation> ourComparator = Comparator.comparing(o -> o.myRange, Comparator.comparingInt(TextRange::getStartOffset).thenComparingInt(TextRange::getEndOffset));

    private StringOperation(@NotNull TextRange range, @NotNull CharSequence replacement) {
        this.myRange = range;
        this.myReplacement = replacement;
    }

    @NotNull
    public TextRange getRange() {
        return this.myRange;
    }

    @NotNull
    public CharSequence getReplacement() {
        return this.myReplacement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringOperation operation = (StringOperation)o;
        return this.myRange.equals(operation.myRange) && this.myReplacement.equals(operation.myReplacement);
    }

    public int hashCode() {
        return Objects.hash(this.myRange, this.myReplacement);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static StringOperation replace(@NotNull TextRange range, @NotNull CharSequence replacement) {
        return new StringOperation(range, replacement);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static StringOperation replace(int startOffset, int endOffset, @NotNull CharSequence replacement) {
        return StringOperation.replace(TextRange.create(startOffset, endOffset), replacement);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static StringOperation insert(int offset, @NotNull CharSequence replacement) {
        return StringOperation.replace(offset, offset, replacement);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static StringOperation remove(@NotNull TextRange range) {
        return StringOperation.replace(range, "");
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static StringOperation remove(int startOffset, int endOffset) {
        return StringOperation.remove(TextRange.create(startOffset, endOffset));
    }

    @Contract(pure=true)
    @NotNull
    private static @NotNull List<@NotNull StringOperation> sort(@NotNull @NotNull Collection<@NotNull StringOperation> operations) {
        ArrayList<StringOperation> sorted = new ArrayList<StringOperation>(operations);
        sorted.sort(ourComparator);
        return sorted;
    }

    @Contract(pure=true)
    @NotNull
    public static CharSequence applyOperations(@NotNull CharSequence original, @NotNull @NotNull Collection<@NotNull StringOperation> operations) {
        if (operations.isEmpty()) {
            return original;
        }
        List<StringOperation> sorted = StringOperation.sort(operations);
        StringBuilder result = new StringBuilder();
        int previousRangeEnd = 0;
        for (StringOperation operation : sorted) {
            TextRange range = operation.myRange;
            result.append(original, previousRangeEnd, range.getStartOffset());
            result.append(operation.myReplacement);
            previousRangeEnd = range.getEndOffset();
        }
        result.append(original, previousRangeEnd, original.length());
        return result.toString();
    }
}

