/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.TextRange;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PlaceholderTextRanges {
    private PlaceholderTextRanges() {
    }

    @NotNull
    public static Set<TextRange> getPlaceholderRanges(@NotNull String s, @NotNull String prefix, @NotNull String suffix) {
        return PlaceholderTextRanges.getPlaceholderRanges(s, prefix, suffix, false);
    }

    @NotNull
    public static Set<TextRange> getPlaceholderRanges(@NotNull String s, @NotNull String prefix, @NotNull String suffix, boolean useFullTextRange) {
        return PlaceholderTextRanges.getPlaceholderRanges(s, prefix, suffix, useFullTextRange, false);
    }

    @NotNull
    public static Set<TextRange> getPlaceholderRanges(@NotNull String s, @NotNull String prefix, @NotNull String suffix, boolean useFullTextRange, boolean filterNestedRanges) {
        int nextSuffix;
        if (!s.contains(prefix)) {
            return Collections.emptySet();
        }
        LinkedHashSet<TextRange> ranges = new LinkedHashSet<TextRange>(2);
        ArrayDeque<Integer> prefixes = new ArrayDeque<Integer>();
        int searchFrom = 0;
        while (searchFrom < s.length() && (nextSuffix = s.indexOf(suffix, searchFrom)) >= 0) {
            int nextPrefix = s.indexOf(prefix, searchFrom);
            if (prefixes.isEmpty()) {
                if (nextPrefix < 0) break;
                prefixes.push(nextPrefix);
                searchFrom = nextPrefix + 1;
                continue;
            }
            if (nextPrefix < 0 || nextSuffix <= nextPrefix || nextPrefix + prefix.length() > nextSuffix) {
                int prefixPairPos = (Integer)prefixes.pop();
                int startOffset = prefixPairPos + (useFullTextRange ? 0 : prefix.length());
                int endOffset = useFullTextRange ? nextSuffix + suffix.length() : nextSuffix;
                ranges.add(TextRange.create(startOffset, endOffset));
                while (!prefixes.isEmpty() && (Integer)prefixes.peek() + prefix.length() > prefixPairPos) {
                    prefixes.pop();
                }
                searchFrom = nextSuffix + suffix.length();
                continue;
            }
            prefixes.push(nextPrefix);
            searchFrom = nextPrefix + 1;
        }
        return filterNestedRanges ? PlaceholderTextRanges.filterNested(ranges) : ranges;
    }

    private static Set<TextRange> filterNested(Set<? extends TextRange> allRanges) {
        LinkedHashSet<TextRange> filtered = new LinkedHashSet<TextRange>(allRanges.size());
        for (TextRange textRange : allRanges) {
            boolean contains = PlaceholderTextRanges.anyRangeContains(allRanges, textRange);
            if (contains) continue;
            filtered.add(textRange);
        }
        return filtered;
    }

    private static boolean anyRangeContains(Set<? extends TextRange> allRanges, TextRange inner) {
        for (TextRange textRange : allRanges) {
            if (inner.equals(textRange) || !textRange.contains(inner)) continue;
            return true;
        }
        return false;
    }
}

