/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.text.CharArrayUtil;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ByteArrayCharSequence
implements CharSequenceWithStringHash {
    private final int myStart;
    private final int myEnd;
    private transient int hash;
    private final byte[] myChars;
    private static final boolean JAVA_9;

    public ByteArrayCharSequence(byte @NotNull [] chars) {
        this(chars, 0, chars.length);
    }

    public ByteArrayCharSequence(byte @NotNull [] chars, int start, int end) {
        this.myChars = chars;
        this.myStart = start;
        this.myEnd = end;
    }

    @Override
    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = Strings.stringHashCode(this, 0, this.length());
        }
        return h;
    }

    @Override
    public int length() {
        return this.myEnd - this.myStart;
    }

    @Override
    public char charAt(int index) {
        return (char)(this.myChars[index + this.myStart] & 0xFF);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        return start == 0 && end == this.length() ? this : new ByteArrayCharSequence(this.myChars, this.myStart + start, this.myStart + end);
    }

    @Override
    @NotNull
    public String toString() {
        return new String(this.myChars, this.myStart, this.length(), StandardCharsets.ISO_8859_1);
    }

    public void getChars(int start, int end, char[] dest, int pos) {
        for (int idx = start; idx < end; ++idx) {
            dest[idx - start + pos] = (char)(this.myChars[idx + this.myStart] & 0xFF);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static CharSequence convertToBytesIfAsciiString(@NotNull String name) {
        return name;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static CharSequence convertToBytesIfPossible(@NotNull CharSequence string2) {
        if (JAVA_9) {
            return string2;
        }
        if (string2.length() == 0) {
            return "";
        }
        if (string2 instanceof ByteArrayCharSequence) {
            return string2;
        }
        byte[] bytes = ByteArrayCharSequence.toBytesIfPossible(string2);
        return bytes == null ? string2 : new ByteArrayCharSequence(bytes);
    }

    private byte @NotNull [] getBytes() {
        return this.myStart == 0 && this.myEnd == this.myChars.length ? this.myChars : Arrays.copyOfRange(this.myChars, this.myStart, this.myEnd);
    }

    private static byte @Nullable [] toBytesIfPossible(@NotNull CharSequence seq) {
        if (seq instanceof ByteArrayCharSequence) {
            return ((ByteArrayCharSequence)seq).getBytes();
        }
        byte[] bytes = new byte[seq.length()];
        char[] chars = CharArrayUtil.fromSequenceWithoutCopying(seq);
        if (chars == null) {
            for (int i = 0; i < bytes.length; ++i) {
                char c = seq.charAt(i);
                if ((c & 0xFF00) != 0) {
                    return null;
                }
                bytes[i] = (byte)c;
            }
        } else {
            for (int i = 0; i < bytes.length; ++i) {
                char c = chars[i];
                if ((c & 0xFF00) != 0) {
                    return null;
                }
                bytes[i] = (byte)c;
            }
        }
        return bytes;
    }

    static {
        boolean hasModuleClass;
        try {
            Class.class.getMethod("getModule", new Class[0]);
            hasModuleClass = true;
        }
        catch (Throwable t) {
            hasModuleClass = false;
        }
        JAVA_9 = hasModuleClass;
    }
}

